package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;


import com.google.common.collect.Iterables;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

@Mixin(class_1297.class)
public abstract class EntityMixin {

    @ModifyReturnValue(method = "getAllSlots", at = @At("RETURN"))
    private Iterable<class_1799> addAccessories(Iterable<class_1799> original){
        if((Object) this instanceof class_1309 livingEntity && !livingEntity.method_31481()) {
            var capability = livingEntity.accessoriesCapability();

            if(capability != null) return Iterables.concat(original, capability.getAllEquipped().stream().map(SlotEntryReference::stack).toList());
        }

        return original;
    }
}
