package io.wispforest.accessories.mixin;

import Z;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Predicate;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6862;

@Mixin(class_1661.class)
public abstract class InventoryMixin {

    @Shadow @Final public class_1657 player;

    @Inject(method = "clearOrCountMatchingItems", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;isEmpty()Z", shift = At.Shift.AFTER))
    private void clearAccessories(Predicate<class_1799> stackPredicate, int maxCount, class_1263 inventory, CallbackInfoReturnable<Integer> cir, @Local(ordinal = 1) LocalIntRef i) {
        var capability = AccessoriesCapability.get(player);

        if(capability == null) return;

        capability.getContainers().forEach((s, container) -> {
            var accessories = container.getAccessories();
            i.set(i.get() + class_1262.method_29234(accessories, stackPredicate, maxCount - i.get(), maxCount - i.get() == 0));

            var cosmetics = container.getCosmeticAccessories();
            i.set(i.get() + class_1262.method_29234(cosmetics, stackPredicate, maxCount - i.get(), maxCount - i.get() == 0));
        });
    }

    @Inject(method = "contains(Lnet/minecraft/world/item/ItemStack;)Z", at = @At("TAIL"))
    private void extendContainsCheck(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        var capability = AccessoriesCapability.get(player);

        if (capability == null) return;

        var bl = capability.isEquipped(stack1 -> stack1.method_7960() && class_1799.method_31577(stack1, stack));

        if (bl) cir.setReturnValue(true);
    }

    @Inject(method = "contains(Lnet/minecraft/tags/TagKey;)Z", at = @At("TAIL"))
    private void extendContainsCheck(class_6862<class_1792> tag, CallbackInfoReturnable<Boolean> cir){
        var capability = AccessoriesCapability.get(player);

        if(capability == null) return;

        var bl = capability.isEquipped(stack1 -> !stack1.method_7960() && stack1.method_31573(tag));

        if(bl) cir.setReturnValue(true);
    }
}