package io.wispforest.accessories.mixin;

import ;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_2487.class)
public abstract class NbtCompoundMixin {

    @Shadow @Nullable public abstract class_2520 get(String string);

    @Inject(method = "hasUUID", at = @At(value = "INVOKE", target = "Lnet/minecraft/nbt/CompoundTag;get(Ljava/lang/String;)Lnet/minecraft/nbt/Tag;", shift = At.Shift.BY, by = 2), locals = LocalCapture.CAPTURE_FAILHARD, cancellable = true)
    private void adjustCheckForListVariants(String key, CallbackInfoReturnable<Boolean> cir, class_2520 tag) {
        if(tag instanceof class_2499 listTag && listTag.method_10601() == class_2520.field_33253 && listTag.size() == 4) {
            cir.setReturnValue(true);
        }
    }

    @Inject(method = "getByteArray", at = @At(value = "INVOKE", target = "Lnet/minecraft/nbt/CompoundTag;contains(Ljava/lang/String;I)Z"), cancellable = true)
    private void adjustByteArrayForRegularList(String key, CallbackInfoReturnable<byte[]> cir) {
        var tag = get(key);

        if(tag instanceof class_2499 listTag && listTag.method_10601() == class_2520.field_33251) {
            var array = new byte[listTag.size()];

            for (int i = 0; i < listTag.size(); i++) {
                var tagEntry = listTag.method_10534(i);

                array[i] = ((class_2514) tagEntry).method_10698();
            }

            cir.setReturnValue(array);
        }
    }

    @Inject(method = "getIntArray", at = @At(value = "INVOKE", target = "Lnet/minecraft/nbt/CompoundTag;contains(Ljava/lang/String;I)Z"), cancellable = true)
    private void adjustIntArrayForRegularList(String key, CallbackInfoReturnable<int[]> cir) {
        var tag = get(key);

        if(tag instanceof class_2499 listTag && listTag.method_10601() == class_2520.field_33253) {
            var array = new int[listTag.size()];

            for (int i = 0; i < listTag.size(); i++) {
                var tagEntry = listTag.method_10534(i);

                array[i] = ((class_2514) tagEntry).method_10701();
            }

            cir.setReturnValue(array);
        }
    }

    @Inject(method = "getLongArray", at = @At(value = "INVOKE", target = "Lnet/minecraft/nbt/CompoundTag;contains(Ljava/lang/String;I)Z"), cancellable = true)
    private void adjustLongArrayForRegularList(String key, CallbackInfoReturnable<long[]> cir) {
        var tag = get(key);

        if(tag instanceof class_2499 listTag && listTag.method_10601() == class_2520.field_33254) {
            var array = new long[listTag.size()];

            for (int i = 0; i < listTag.size(); i++) {
                var tagEntry = listTag.method_10534(i);

                array[i] = ((class_2514) tagEntry).method_10699();
            }

            cir.setReturnValue(array);
        }
    }
}
