package io.wispforest.accessories.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ;
import java.util.UUID;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_4844;

@Mixin(class_2512.class)
public abstract class NbtUtilsMixin {
    @Inject(method = "loadUUID", at = @At(value = "HEAD"), cancellable = true)
    private static void adjustLoadToAllowListVariant(class_2520 tag, CallbackInfoReturnable<UUID> cir) {
        if(tag instanceof class_2499 listTag && listTag.method_10601() == class_2520.field_33253) {
            if(listTag.size() != 4) {
                throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + listTag.size() + ".");
            }

            var array = new int[listTag.size()];

            for (int i = 0; i < listTag.size(); i++) {
                var tagEntry = listTag.method_10534(i);

                array[i] = ((class_2514) tagEntry).method_10701();
            }

            cir.setReturnValue(class_4844.method_26276(array));
        }
    }
}
