package io.wispforest.accessories.mixin.client;

import I;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.client.AccessoriesClient;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.networking.server.ScreenOpen;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_485;
import net.minecraft.class_490;
import net.minecraft.class_7919;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_490.class)
public abstract class InventoryScreenMixin extends class_485<class_1723> {

    public InventoryScreenMixin(class_1723 menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
    }

    @Unique
    private class_4185 accessoryButton = null;

    @Inject(method = "init", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/inventory/InventoryScreen;addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;"))
    private void injectAccessoryButton(CallbackInfo ci){
        var xOffset = Accessories.getConfig().clientData.inventoryButtonXOffset;
        var yOffset = Accessories.getConfig().clientData.inventoryButtonYOffset;

        accessoryButton = this.method_37063(
                class_4185.method_46430(class_2561.method_43473(), button -> {
                    AccessoriesClient.attemptToOpenScreen();
                }).method_46434(this.field_2776 + xOffset, this.field_2800 + yOffset, 8, 8)
                        .method_46436(class_7919.method_47407(class_2561.method_43471(Accessories.translation("open.screen"))))
                        .method_46431()
        ).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
            guiGraphics.method_25290(AccessoriesScreen.SPRITES_8X8.getLocation(button), x, y, width, height, 8, 8, 8, 8);

            return true;
        });
    }

    @Inject(method = "method_19891", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/Button;setPosition(II)V"))
    private void adjustAccessoryButton(CallbackInfo ci){
        if(this.accessoryButton == null) return;

        var xOffset = Accessories.getConfig().clientData.inventoryButtonXOffset;
        var yOffset = Accessories.getConfig().clientData.inventoryButtonYOffset;

        accessoryButton.method_48229(this.field_2776 + xOffset, this.field_2800 + yOffset);
    }
}
