package io.wispforest.accessories.mixin.client;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.Map.Entry;
import net.minecraft.class_1007;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_1007.class)
public abstract class PlayerRendererMixin {

    @Shadow public abstract void render(class_742 entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight);

    @Unique
    private static class_1306 currentArm = null;

//    @WrapWithCondition(method = "renderHand", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/model/geom/ModelPart;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V"))
//    private boolean accessories$fixOverridenInvisibility(ModelPart instance, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay) {
//        var returned = AccessoriesClient.IS_PLAYER_INVISIBLE;
//        AccessoriesClient.IS_PLAYER_INVISIBLE = false;
//        return returned;
//    }

    @Inject(method = "renderHand", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/model/geom/ModelPart;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V", ordinal = 1, shift = At.Shift.AFTER), locals = LocalCapture.CAPTURE_FAILHARD)
    private void accessories$firstPersonAccessories(class_4587 poseStack, class_4597 buffer, int combinedLight, class_742 player, class_630 rendererArm, class_630 rendererArmwear, CallbackInfo ci, class_591 playerModel) {        if (currentArm != null) {
            var capability = AccessoriesCapability.get(player);

            if (capability == null) return;

            for (var entry : capability.getContainers().entrySet()) {
                var container = entry.getValue();

                var accessories = container.getAccessories();
                var cosmetics = container.getCosmeticAccessories();

                for (int i = 0; i < accessories.method_5439(); i++) {
                    var stack = accessories.method_5438(i);
                    var cosmeticStack = cosmetics.method_5438(i);

                    if (!cosmeticStack.method_7960()) stack = cosmeticStack;

                    if (stack.method_7960()) continue;

                    var renderer = AccessoriesRendererRegistry.getRender(stack);

                    if(renderer == null || !renderer.shouldRender(container.shouldRender(i))) continue;

                    poseStack.method_22903();

                    renderer.renderOnFirstPerson(
                        currentArm,
                        stack,
                        SlotReference.of(player, container.getSlotName(), i),
                        poseStack,
                        playerModel,
                        buffer,
                        combinedLight
                    );

                    poseStack.method_22909();
                }
            }
        }
        currentArm = null;
    }

    @Inject(method = "renderRightHand", at = @At("HEAD"))
    private void accessories$firstPersonRightAccessories(class_4587 poseStack, class_4597 buffer, int combinedLight, class_742 player, CallbackInfo ci) {
        currentArm = class_1306.field_6183;
    }

    @Inject(method = "renderLeftHand", at = @At("HEAD"))
    private void accessories$firstPersonLeftAccessories(class_4587 poseStack, class_4597 buffer, int combinedLight, class_742 player, CallbackInfo ci) {
        currentArm = class_1306.field_6182;
    }
}