package io.wispforest.accessories.networking.client;

import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.MinecraftEndecs;
import io.wispforest.accessories.impl.SlotGroupImpl;
import io.wispforest.accessories.impl.SlotTypeImpl;
import io.wispforest.accessories.networking.BaseAccessoriesPacket;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_7923;
import java.util.*;
import java.util.Map.Entry;
import java.util.stream.Collectors;

public record SyncData(List<SlotType> slotTypes, Map<class_1299<?>, Set<String>> entitySlots, Set<SlotGroup> slotGroups, Set<String> uniqueGroups, Map<String, ExtraSlotTypeProperties> uniqueExtraProperties) implements BaseAccessoriesPacket {

    public static Endec<SyncData> ENDEC = StructEndecBuilder.of(
            SlotTypeImpl.ENDEC.listOf().fieldOf("slotTypes", SyncData::slotTypes),
            Endec.map(MinecraftEndecs.ofRegistry(class_7923.field_41177), Endec.STRING.setOf()).fieldOf("entitySlots", SyncData::entitySlots),
            SlotGroupImpl.ENDEC.setOf().fieldOf("slotGroups", SyncData::slotGroups),
            Endec.STRING.setOf().fieldOf("uniqueGroups", SyncData::uniqueGroups),
            ExtraSlotTypeProperties.ENDEC.mapOf().fieldOf("uniqueExtraProperties", SyncData::uniqueExtraProperties),
            SyncData::new
    );

    public static SyncData create(){
        var allSlotTypes = SlotTypeLoader.INSTANCE.getSlotTypes(false);

        var entitySlotData = EntitySlotLoader.INSTANCE.getEntitySlotData(false);

        var entitySlots = new HashMap<class_1299<?>, Set<String>>();

        for (var entry : entitySlotData.entrySet()) {
            entitySlots.put(entry.getKey(), entry.getValue().keySet());
        }

        var slotGroups = new HashSet<SlotGroup>();

        slotGroups.addAll(SlotGroupLoader.INSTANCE.getGroups(false, false));

        return new SyncData(List.copyOf(allSlotTypes.values()), entitySlots, slotGroups, UniqueSlotHandling.getGroups(false), ExtraSlotTypeProperties.getProperties(false));
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void handle(class_1657 player) {
        Map<String, SlotType> slotTypes = new HashMap<>();

        for (SlotType slotType : this.slotTypes()) {
            slotTypes.put(slotType.name(), slotType);
        }

        SlotTypeLoader.INSTANCE.setSlotType(slotTypes);

        UniqueSlotHandling.buildClientSlotReferences();

        Map<class_1299<?>, Map<String, SlotType>> entitySlotTypes = new HashMap<>();

        for (var entry : this.entitySlots().entrySet()) {
            var map = entry.getValue().stream()
                    .map(slotTypes::get)
                    .collect(Collectors.toUnmodifiableMap(SlotType::name, slotType -> slotType));

            entitySlotTypes.put(entry.getKey(), map);
        }

        EntitySlotLoader.INSTANCE.setEntitySlotData(entitySlotTypes);

        var slotGroups = this.slotGroups().stream()
                .collect(Collectors.toUnmodifiableMap(SlotGroup::name, group -> group));

        SlotGroupLoader.INSTANCE.setGroups(slotGroups);

        UniqueSlotHandling.setClientGroups(this.uniqueGroups());
        ExtraSlotTypeProperties.setClientPropertyMap(this.uniqueExtraProperties());
    }
}
