package io.wispforest.accessories.networking.server;

import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.networking.BaseAccessoriesPacket;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public record MenuScroll(int index, boolean smooth) implements BaseAccessoriesPacket {

    public static final Endec<MenuScroll> ENDEC = StructEndecBuilder.of(
            Endec.VAR_INT.fieldOf("index", MenuScroll::index),
            Endec.BOOLEAN.fieldOf("smooth", MenuScroll::smooth),
            MenuScroll::new
    );

    @Override
    public void handle(class_1657 player) {
        if(player.field_7512 instanceof AccessoriesMenu menu && menu.scrollTo(this.index, this.smooth) && player instanceof class_3222 serverPlayer){
            AccessoriesInternals.getNetworkHandler().sendToPlayer(serverPlayer, new MenuScroll(this.index, this.smooth));
        }
    }
}
