package io.wispforest.accessories.utils;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.endec.MinecraftEndecs;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.BuiltInEndecs;
import io.wispforest.endec.impl.StructEndecBuilder;
import it.unimi.dsi.fastutil.Pair;
import org.slf4j.Logger;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_5131;

public class AttributeUtils {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void addTransientAttributeModifiers(class_1309 livingEntity, AccessoryAttributeBuilder attributes) {
        if(attributes.isEmpty()) return;

        var attributeMap = livingEntity.method_6127();
        var capability = livingEntity.accessoriesCapability();

        var containers = capability.getContainers();

        attributes.getSlotModifiers().asMap().forEach((s, modifiers) -> {
            var container = containers.get(s);

            if(container == null) return;

            modifiers.stream()
                    .filter(modifier -> !container.hasModifier(modifier.method_6189()))
                    .forEach(container::addTransientModifier);
        });

        attributes.getAttributeModifiers(true).asMap().forEach((holder, modifiers) -> {
            var instance = attributeMap.method_26842(holder);

            if(instance == null) return;

            modifiers.stream()
                    .filter(modifier -> !instance.method_6196(modifier))
                    .forEach(instance::method_26835);
        });
    }

    public static void removeTransientAttributeModifiers(class_1309 livingEntity, AccessoryAttributeBuilder attributes) {
        if(attributes.isEmpty()) return;

        var attributeMap = livingEntity.method_6127();
        var capability = livingEntity.accessoriesCapability();

        var containers = capability.getContainers();

        attributes.getSlotModifiers().asMap().forEach((s, modifiers) -> {
            var container = containers.get(s);

            if(container == null) return;

            modifiers.stream()
                    .map(class_1322::method_6189)
                    .forEach(container::removeModifier);
        });

        attributes.getAttributeModifiers(true).asMap().forEach((holder, modifiers) -> {
            var instance = attributeMap.method_26842(holder);

            if(instance == null) return;

            modifiers.stream()
                    .map(class_1322::method_6189)
                    .forEach(instance::method_6200);
        });
    }

    public static final StructEndec<class_1322> ATTRIBUTE_MODIFIER_ENDEC = StructEndecBuilder.of(
            BuiltInEndecs.UUID.fieldOf("uuid", class_1322::method_6189),
            Endec.STRING.fieldOf("name", class_1322::method_6185),
            Endec.DOUBLE.fieldOf("amount", class_1322::method_6186),
            Endec.forEnum(class_1322.class_1323.class).fieldOf("operation", class_1322::method_6182),
            class_1322::new
    );

    public static class_2960 getLocation(String name) {
        var safeName = name.toLowerCase(Locale.ROOT)
                .replace(" ", "_")
                .replaceAll("(?![a-z0-9/._-]).|\n", "");

        var location = class_2960.method_12829(safeName);

        if (location == null) location = Accessories.of(safeName);

        return location;
    }

    public static Pair<String, UUID> getModifierData(class_2960 location) {
        var name = location.toString();
        var id = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));

        return Pair.of(name, id);
    }
}
