/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.endec.CodecUtils;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.networking.BaseAccessoriesPacket;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.endec.util.MapCarrier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.slf4j.Logger;

public record SyncContainerData(int entityId, Map<String, NbtMapCarrier> updatedContainers, Map<String, class_1799> dirtyStacks, Map<String, class_1799> dirtyCosmeticStacks) implements BaseAccessoriesPacket
{
    public static Endec<SyncContainerData> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", SyncContainerData::entityId), (StructField)NbtMapCarrier.ENDEC.mapOf().fieldOf("updatedContainers", SyncContainerData::updatedContainers), (StructField)CodecUtils.ofCodec(class_1799.field_24671).mapOf().fieldOf("dirtyStacks", SyncContainerData::dirtyStacks), (StructField)CodecUtils.ofCodec(class_1799.field_24671).mapOf().fieldOf("dirtyCosmeticStacks", SyncContainerData::dirtyCosmeticStacks), SyncContainerData::new);
    private static final Logger LOGGER = LogUtils.getLogger();

    public static SyncContainerData of(class_1309 livingEntity, Collection<AccessoriesContainer> updatedContainers, Map<String, class_1799> dirtyStacks, Map<String, class_1799> dirtyCosmeticStacks) {
        HashMap<String, NbtMapCarrier> updatedContainerTags = new HashMap<String, NbtMapCarrier>();
        for (AccessoriesContainer updatedContainer : updatedContainers) {
            NbtMapCarrier syncCarrier = NbtMapCarrier.of();
            ((AccessoriesContainerImpl)updatedContainer).write(syncCarrier, SerializationContext.empty(), true);
            updatedContainerTags.put(updatedContainer.getSlotName(), syncCarrier);
        }
        return new SyncContainerData(livingEntity.method_5628(), updatedContainerTags, dirtyStacks, dirtyCosmeticStacks);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void handle(class_1657 player) {
        class_1703 class_17032;
        class_1937 level = player.method_37908();
        class_1297 entity = level.method_8469(this.entityId);
        if (entity == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as it is null on the Client! [EntityId: {}]", (Object)this.entityId);
            return;
        }
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        AccessoriesCapability capability = AccessoriesCapability.get(livingEntity);
        if (capability == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as its Capability is null on the Client! [EntityId: {}]", (Object)this.entityId);
            return;
        }
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        boolean aContainerHasResized = false;
        HashSet<String> invalidSyncedContainers = new HashSet<String>();
        for (Map.Entry<String, NbtMapCarrier> entry : this.updatedContainers.entrySet()) {
            if (!containers.containsKey(entry.getKey())) {
                invalidSyncedContainers.add(entry.getKey());
                continue;
            }
            AccessoriesContainer accessoriesContainer = containers.get(entry.getKey());
            ((AccessoriesContainerImpl)accessoriesContainer).read((MapCarrier)entry.getValue(), SerializationContext.empty(), true);
            if (!accessoriesContainer.getAccessories().wasNewlyConstructed()) continue;
            aContainerHasResized = true;
        }
        if (!invalidSyncedContainers.isEmpty()) {
            LOGGER.warn("Unable to sync container data for the following containers: {}", invalidSyncedContainers);
        }
        HashSet<String> invalidDirtyStackContainers = new HashSet<String>();
        for (Map.Entry entry : this.dirtyStacks.entrySet()) {
            String[] stringArray = ((String)entry.getKey()).split("/");
            String slot = stringArray[0];
            if (!containers.containsKey(slot)) {
                invalidDirtyStackContainers.add(slot);
                continue;
            }
            AccessoriesContainer container = containers.get(slot);
            try {
                container.getAccessories().method_5447(Integer.parseInt(stringArray[1]), (class_1799)entry.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!invalidDirtyStackContainers.isEmpty()) {
            LOGGER.warn("Unable to sync dirty stack data for the following containers: {}", invalidSyncedContainers);
        }
        HashSet<String> invalidDirtyCosmeticContainers = new HashSet<String>();
        for (Map.Entry<String, class_1799> entry : this.dirtyCosmeticStacks.entrySet()) {
            String[] parts = entry.getKey().split("/");
            String slot = parts[0];
            if (!containers.containsKey(slot)) {
                invalidDirtyCosmeticContainers.add(slot);
                continue;
            }
            AccessoriesContainer container = containers.get(slot);
            try {
                container.getCosmeticAccessories().method_5447(Integer.parseInt(parts[1]), entry.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!invalidDirtyCosmeticContainers.isEmpty()) {
            LOGGER.warn("Unable to sync dirty stack data for the following containers: {}", invalidSyncedContainers);
        }
        if ((class_17032 = player.field_7512) instanceof AccessoriesMenu) {
            AccessoriesMenu accessoriesMenu = (AccessoriesMenu)class_17032;
            if (aContainerHasResized) {
                accessoriesMenu.reopenMenu();
            }
        }
    }
}

