/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.components.AccessoryStackSizeComponent;
import io.wispforest.accessories.api.events.AdjustAttributeModifierCallback;
import io.wispforest.accessories.api.events.CanEquipCallback;
import io.wispforest.accessories.api.events.CanUnequipCallback;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.accessories.networking.client.AccessoryBreak;
import io.wispforest.accessories.utils.AttributeUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesAPI {
    private static final Logger LOGGER = LogUtils.getLogger();
    @ApiStatus.Internal
    public static final Accessory DEFAULT = new Accessory(){

        @Override
        public int maxStackSize(ItemStack stack) {
            AccessoryStackSizeComponent data = AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.STACK_SIZE, stack);
            if (data.useStackSize()) {
                return stack.m_41741_();
            }
            return Math.min(Math.max(data.sizeOverride(), 1), stack.m_41741_());
        }
    };
    private static final Map<ResourceLocation, SlotBasedPredicate> PREDICATE_REGISTRY = new HashMap<ResourceLocation, SlotBasedPredicate>();
    private static final Map<Item, Accessory> REGISTER = new HashMap<Item, Accessory>();
    @Deprecated(forRemoval=true)
    public static final TagKey<Item> ALL_ACCESSORIES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Accessories.of("all"));
    public static final TagKey<Item> ANY_ACCESSORIES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Accessories.of("any"));

    @ApiStatus.Internal
    public static Map<Item, Accessory> getAllAccessories() {
        return Collections.unmodifiableMap(REGISTER);
    }

    public static void registerAccessory(Item item, Accessory accessory) {
        REGISTER.put(item, accessory);
    }

    @Nullable
    public static Accessory getAccessory(ItemStack stack) {
        return AccessoriesAPI.getAccessory(stack.m_41720_());
    }

    @Nullable
    public static Accessory getAccessory(Item item) {
        return REGISTER.get(item);
    }

    public static Accessory getOrDefaultAccessory(ItemStack stack) {
        return AccessoriesAPI.getOrDefaultAccessory(stack.m_41720_());
    }

    public static Accessory getOrDefaultAccessory(Item item) {
        return REGISTER.getOrDefault(item, AccessoriesAPI.defaultAccessory());
    }

    public static Accessory defaultAccessory() {
        return DEFAULT;
    }

    public static boolean isValidAccessory(ItemStack stack, Level level) {
        return AccessoriesAPI.getAccessory(stack) != null || !AccessoriesAPI.getStackSlotTypes(level, stack).isEmpty();
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, SlotReference slotReference) {
        return AccessoriesAPI.getAttributeModifiers(stack, slotReference, false);
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, SlotReference slotReference, boolean useTooltipCheck) {
        return AccessoriesAPI.getAttributeModifiers(stack, slotReference.entity(), slotReference.slotName(), slotReference.slot(), useTooltipCheck);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, String slotName, int slot) {
        return AccessoriesAPI.getAttributeModifiers(stack, null, slotName, slot);
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, @Nullable LivingEntity entity, String slotName, int slot) {
        return AccessoriesAPI.getAttributeModifiers(stack, entity, slotName, slot, false);
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, @Nullable LivingEntity entity, String slotName, int slot, boolean hideTooltipIfDisabled) {
        SlotReference slotReference = SlotReference.of(entity, slotName, slot);
        AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(slotReference);
        AccessoryNestUtils.recursiveStackConsumption(stack, slotReference, (innerStack, innerRef) -> {
            AccessoryItemAttributeModifiers component = AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.ATTRIBUTES, innerStack);
            AccessoryAttributeBuilder innerBuilder = !hideTooltipIfDisabled || component.showInTooltip() ? component.gatherAttributes((SlotReference)innerRef) : new AccessoryAttributeBuilder(slotName, slot);
            builder.addFrom(innerBuilder);
        });
        if (entity != null) {
            Accessory accessory = AccessoriesAPI.getAccessory(stack);
            if (accessory != null) {
                accessory.getDynamicModifiers(stack, slotReference, builder);
            }
            ((AdjustAttributeModifierCallback)AdjustAttributeModifierCallback.EVENT.invoker()).adjustAttributes(stack, slotReference, builder);
        }
        return builder;
    }

    public static void addAttribute(ItemStack stack, String slotName, Attribute attribute, ResourceLocation location, double amount, AttributeModifier.Operation operation, boolean isStackable) {
        Pair<String, UUID> attributeData = AttributeUtils.getModifierData(location);
        AccessoriesAPI.addAttribute(stack, slotName, attribute, (String)attributeData.first(), (UUID)attributeData.right(), amount, operation, isStackable);
    }

    public static void addAttribute(ItemStack stack, String slotName, Attribute attribute, String name, UUID id, double amount, AttributeModifier.Operation operation, boolean isStackable) {
        AccessoriesDataComponents.update(AccessoriesDataComponents.ATTRIBUTES, stack, modifiers -> modifiers.withModifierAdded(attribute, new AttributeModifier(id, name, amount, operation), slotName, isStackable));
    }

    public static ResourceLocation createSlotLocation(SlotType slotType, int index) {
        return AccessoriesAPI.createSlotLocation(slotType.name(), index);
    }

    public static ResourceLocation createSlotLocation(String slotName, int index) {
        return Accessories.of(slotName.replace(":", "_") + "/" + index);
    }

    public static boolean canInsertIntoSlot(ItemStack stack, SlotReference reference) {
        SlotType slotType = reference.type();
        if (slotType == null) {
            throw new IllegalStateException("Unable to get the needed SlotType from the SlotReference passed within `canInsertIntoSlot`! [Name: " + reference.slotName() + "]");
        }
        return AccessoriesAPI.getPredicateResults(slotType.validators(), reference.entity().m_9236_(), slotType, 0, stack) && AccessoriesAPI.canEquip(stack, reference);
    }

    public static boolean canEquip(ItemStack stack, SlotReference reference) {
        TriState result = ((CanEquipCallback)CanEquipCallback.EVENT.invoker()).canEquip(stack, reference);
        if (!result.equals((Object)TriState.DEFAULT)) {
            return result.orElse(true);
        }
        return AccessoriesAPI.getOrDefaultAccessory(stack).canEquip(stack, reference);
    }

    public static boolean canUnequip(ItemStack stack, SlotReference reference) {
        TriState result = ((CanUnequipCallback)CanUnequipCallback.EVENT.invoker()).canUnequip(stack, reference);
        if (!result.equals((Object)TriState.DEFAULT)) {
            return result.orElse(true);
        }
        return AccessoriesAPI.getOrDefaultAccessory(stack).canUnequip(stack, reference);
    }

    public static Collection<SlotType> getValidSlotTypes(LivingEntity entity, ItemStack stack) {
        Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots(entity);
        ArrayList<SlotType> validSlots = new ArrayList<SlotType>();
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            Map<String, AccessoriesContainer> containers = capability.getContainers();
            for (SlotType value : slots.values()) {
                if (!containers.containsKey(value.name())) continue;
                AccessoriesContainer container = containers.get(value.name());
                int size = containers.get(value.name()).getSize();
                if (size == 0) {
                    size = 1;
                }
                for (int i = 0; i < size; ++i) {
                    SlotReference reference = SlotReference.of(entity, container.getSlotName(), i);
                    if (!AccessoriesAPI.canInsertIntoSlot(stack, reference)) continue;
                    validSlots.add(value);
                }
            }
        }
        return validSlots;
    }

    public static Collection<SlotType> getStackSlotTypes(Level level, ItemStack stack) {
        ArrayList<SlotType> validSlots = new ArrayList<SlotType>();
        for (SlotType value : SlotTypeLoader.getSlotTypes(level).values()) {
            if (!AccessoriesAPI.getPredicateResults(value.validators(), level, value, 0, stack)) continue;
            validSlots.add(value);
        }
        return validSlots;
    }

    public static Collection<SlotType> getUsedSlotsFor(Player player) {
        return AccessoriesAPI.getUsedSlotsFor((LivingEntity)player, (Container)player.m_150109_());
    }

    public static Collection<SlotType> getUsedSlotsFor(LivingEntity entity, Container container) {
        AccessoriesCapability capability = entity.accessoriesCapability();
        if (capability == null) {
            return Set.of();
        }
        HashSet<SlotType> slots = new HashSet<SlotType>();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            slots.addAll(AccessoriesAPI.getValidSlotTypes(entity, stack));
        }
        for (SlotEntryReference ref : capability.getAllEquipped()) {
            slots.addAll(AccessoriesAPI.getValidSlotTypes(entity, ref.stack()));
        }
        slots.addAll(SlotTypeLoader.getUsedSlotsByRegistryItem(entity));
        return slots;
    }

    public static void breakStack(SlotReference reference) {
        AccessoriesInternals.getNetworkHandler().sendToTrackingAndSelf((Entity)reference.entity(), AccessoryBreak.of(reference));
    }

    @Nullable
    public static SlotBasedPredicate getPredicate(ResourceLocation location) {
        return PREDICATE_REGISTRY.get(location);
    }

    public static void registerPredicate(ResourceLocation location, SlotBasedPredicate predicate) {
        if (PREDICATE_REGISTRY.containsKey(location)) {
            LOGGER.warn("[AccessoriesAPI]: A SlotBasedPredicate attempted to be registered but a duplicate entry existed already! [Id: {}]", (Object)location);
            return;
        }
        PREDICATE_REGISTRY.put(location, predicate);
    }

    public static boolean getPredicateResults(Set<ResourceLocation> predicateIds, Level level, SlotType slotType, int index, ItemStack stack) {
        ResourceLocation predicateId;
        SlotBasedPredicate predicate;
        TriState result = TriState.DEFAULT;
        Iterator<ResourceLocation> iterator = predicateIds.iterator();
        while (iterator.hasNext() && ((predicate = AccessoriesAPI.getPredicate(predicateId = iterator.next())) == null || (result = predicate.isValid(level, slotType, index, stack)) == TriState.DEFAULT)) {
        }
        return result.orElse(false);
    }

    public static TagKey<Item> getSlotTag(SlotType slotType) {
        ResourceLocation location;
        ResourceLocation resourceLocation = location = UniqueSlotHandling.isUniqueSlot(slotType.name()) ? ResourceLocation.m_135820_((String)slotType.name()) : Accessories.of(slotType.name());
        if (location == null) {
            throw new IllegalStateException("Unable tot parse the given slot type as a ResourceLocation: [Location: " + String.valueOf(slotType) + "]");
        }
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)location);
    }

    static {
        AccessoriesAPI.registerPredicate(Accessories.of("all"), (level, slotType, i, stack) -> TriState.TRUE);
        AccessoriesAPI.registerPredicate(Accessories.of("none"), (level, slotType, i, stack) -> TriState.FALSE);
        AccessoriesAPI.registerPredicate(Accessories.of("tag"), (level, slotType, i, stack) -> stack.m_204117_(AccessoriesAPI.getSlotTag(slotType)) || stack.m_204117_(ANY_ACCESSORIES) ? TriState.TRUE : TriState.DEFAULT);
        AccessoriesAPI.registerPredicate(Accessories.of("relevant"), (level, slotType, i, stack) -> {
            boolean bl = !AccessoriesAPI.getAttributeModifiers(stack, null, slotType.name(), i).getAttributeModifiers(false).isEmpty();
            return bl ? TriState.TRUE : TriState.DEFAULT;
        });
        AccessoriesAPI.registerPredicate(Accessories.of("component"), (level, slotType, index, stack) -> {
            if (AccessoriesDataComponents.has(AccessoriesDataComponents.SLOT_VALIDATION, stack)) {
                AccessorySlotValidationComponent slotValidationData = AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.SLOT_VALIDATION, stack);
                String name = slotType.name();
                Set<String> invalidSlots = slotValidationData.invalidSlotOverrides();
                for (String invalidSlot : invalidSlots) {
                    if (!name.equals(invalidSlot)) continue;
                    return TriState.FALSE;
                }
                Set<String> validSlots = slotValidationData.validSlotOverrides();
                for (String validSlot : validSlots) {
                    if (validSlot.equals("any")) {
                        return TriState.TRUE;
                    }
                    if (!name.equals(validSlot)) continue;
                    return TriState.TRUE;
                }
            }
            return TriState.DEFAULT;
        });
    }
}

