/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.utils;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.BuiltInEndecs;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import it.unimi.dsi.fastutil.Pair;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.slf4j.Logger;

public class AttributeUtils {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final StructEndec<AttributeModifier> ATTRIBUTE_MODIFIER_ENDEC = StructEndecBuilder.of((StructField)BuiltInEndecs.UUID.fieldOf("uuid", AttributeModifier::m_22209_), (StructField)Endec.STRING.fieldOf("name", AttributeModifier::m_22214_), (StructField)Endec.DOUBLE.fieldOf("amount", AttributeModifier::m_22218_), (StructField)Endec.forEnum(AttributeModifier.Operation.class).fieldOf("operation", AttributeModifier::m_22217_), AttributeModifier::new);

    public static void addTransientAttributeModifiers(LivingEntity livingEntity, AccessoryAttributeBuilder attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        AttributeMap attributeMap = livingEntity.m_21204_();
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        attributes.getSlotModifiers().asMap().forEach((s, modifiers) -> {
            AccessoriesContainer container = (AccessoriesContainer)containers.get(s);
            if (container == null) {
                return;
            }
            modifiers.stream().filter(modifier -> !container.hasModifier(modifier.m_22209_())).forEach(container::addTransientModifier);
        });
        attributes.getAttributeModifiers(true).asMap().forEach((holder, modifiers) -> {
            AttributeInstance instance = attributeMap.m_22146_(holder);
            if (instance == null) {
                return;
            }
            modifiers.stream().filter(modifier -> !instance.m_22109_(modifier)).forEach(arg_0 -> ((AttributeInstance)instance).m_22118_(arg_0));
        });
    }

    public static void removeTransientAttributeModifiers(LivingEntity livingEntity, AccessoryAttributeBuilder attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        AttributeMap attributeMap = livingEntity.m_21204_();
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        attributes.getSlotModifiers().asMap().forEach((s, modifiers) -> {
            AccessoriesContainer container = (AccessoriesContainer)containers.get(s);
            if (container == null) {
                return;
            }
            modifiers.stream().map(AttributeModifier::m_22209_).forEach(container::removeModifier);
        });
        attributes.getAttributeModifiers(true).asMap().forEach((holder, modifiers) -> {
            AttributeInstance instance = attributeMap.m_22146_(holder);
            if (instance == null) {
                return;
            }
            modifiers.stream().map(AttributeModifier::m_22209_).forEach(arg_0 -> ((AttributeInstance)instance).m_22120_(arg_0));
        });
    }

    public static ResourceLocation getLocation(String name) {
        String safeName = name.toLowerCase(Locale.ROOT).replace(" ", "_").replaceAll("(?![a-z0-9/._-]).|\n", "");
        ResourceLocation location = ResourceLocation.m_135820_((String)safeName);
        if (location == null) {
            location = Accessories.of(safeName);
        }
        return location;
    }

    public static Pair<String, UUID> getModifierData(ResourceLocation location) {
        String name = location.toString();
        UUID id = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        return Pair.of((Object)name, (Object)id);
    }
}

