/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories;

import com.google.common.reflect.Reflection;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.AccessoriesLoaderInternals;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.commands.AccessoriesCommands;
import io.wispforest.accessories.compat.config.AccessoriesConfig;
import io.wispforest.accessories.criteria.AccessoryChangedCriterion;
import io.wispforest.accessories.data.CustomRendererLoader;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.event.VanillaItemPredicates;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.mixin.CriteriaTriggersAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.ScreenVariantPing;
import io.wispforest.accessories.networking.client.SyncServerOverrideOption;
import io.wispforest.accessories.utils.EndecUtils;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_6025;
import net.minecraft.class_8942;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.slf4j.Logger;

public class Accessories {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final class_2960 SLOT_LOADER_LOCATION = Accessories.of("slot_loader");
    public static final class_2960 ENTITY_SLOT_LOADER_LOCATION = Accessories.of("entity_slot_loader");
    public static final class_2960 SLOT_GROUP_LOADER_LOCATION = Accessories.of("slot_group_loader");
    public static final class_2960 DATA_RELOAD_HOOK = Accessories.of("data_reload_hook");
    public static final boolean DEBUG;
    public static final String MODID = "accessories";
    private static final AccessoriesConfig CONFIG;
    public static AccessoryChangedCriterion ACCESSORY_EQUIPPED;
    public static AccessoryChangedCriterion ACCESSORY_UNEQUIPPED;

    public static class_2960 of(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }

    public static class_2960 parseLocationOrDefault(String s) {
        class_2960 location = class_2960.method_12829((String)s);
        if (location == null) {
            location = Accessories.of(s);
        }
        return location;
    }

    public static String translationKey(String path) {
        return "accessories." + path;
    }

    public static class_2561 translation(String path) {
        return class_2561.method_43471((String)Accessories.translationKey(path));
    }

    public static AccessoriesConfig config() {
        return CONFIG;
    }

    public static void askPlayerForVariant(class_3222 player) {
        Accessories.askPlayerForVariant(player, null);
    }

    public static void askPlayerForVariant(class_3222 player, @Nullable class_1309 targetEntity) {
        AccessoriesNetworking.sendToPlayer(player, ScreenVariantPing.of(targetEntity));
    }

    public static boolean attemptOpenScreenPlayer(class_3222 player, AccessoriesMenuVariant variant) {
        class_239 result = class_1675.method_49998((class_1297)player, e -> e instanceof class_1309, (double)player.method_55755());
        if (!(result instanceof class_3966)) {
            return false;
        }
        class_3966 entityHitResult = (class_3966)result;
        Accessories.openAccessoriesMenu((class_1657)player, variant, (class_1309)entityHitResult.method_17782());
        return true;
    }

    public static void openAccessoriesMenu(class_1657 player, AccessoriesMenuVariant variant, @Nullable class_1309 targetEntity) {
        Accessories.openAccessoriesMenu(player, variant, targetEntity, null);
    }

    public static void openAccessoriesMenu(class_1657 player, AccessoriesMenuVariant variant, @Nullable class_1309 targetEntity, @Nullable class_1799 carriedStack) {
        TriState result;
        if (!(targetEntity == null || player.equals((Object)targetEntity) || (result = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(targetEntity, player, null)).orElse(false) || player.method_64475(3))) {
            return;
        }
        AccessoriesInternals.INSTANCE.openAccessoriesMenu(player, variant, targetEntity, carriedStack);
    }

    public static void init() {
        Reflection.initialize((Class[])new Class[]{SlotTypeLoader.class, SlotGroupLoader.class, EntitySlotLoader.class, CustomRendererLoader.class});
        AccessoriesCommands.init();
        AllowEntityModificationCallback.EVENT.register((target, player, reference) -> {
            class_6025 ownableEntity;
            boolean isOwnersPet;
            class_1299 type = target.method_5864();
            if (type.method_20210(AccessoriesTags.MODIFIABLE_ENTITY_BLACKLIST)) {
                return TriState.FALSE;
            }
            boolean bl = isOwnersPet = target instanceof class_6025 && (ownableEntity = (class_6025)target).method_35057() != null && ownableEntity.method_35057().equals((Object)player);
            if (isOwnersPet || type.method_20210(AccessoriesTags.MODIFIABLE_ENTITY_WHITELIST)) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        });
        ArmorSlotTypes.INSTANCE.init();
        VanillaItemPredicates.init();
        AccessoriesConfig config = Accessories.config();
        AccessoriesConfig.ContentOptions contentOptions = Accessories.config().contentOptions;
        AccessoriesConfig.Keys keys = Accessories.config().keys;
        SyncServerOverrideOption.hookUpdate(contentOptions::subscribeToValidBannerSlots, config, keys.contentOptions_validBannerSlots);
        SyncServerOverrideOption.hookUpdate(contentOptions::subscribeToValidGliderSlots, config, keys.contentOptions_validGliderSlots);
        SyncServerOverrideOption.hookUpdate(contentOptions::subscribeToValidTotemSlots, config, keys.contentOptions_validTotemSlots);
        SyncServerOverrideOption.hookUpdate(contentOptions::subscribeToAllowBannerEquip, config, keys.contentOptions_allowBannerEquip);
        SyncServerOverrideOption.hookUpdate(contentOptions::subscribeToAllowGliderEquip, config, keys.contentOptions_allowGliderEquip);
        SyncServerOverrideOption.hookUpdate(contentOptions::subscribeToAllowTotemEquip, config, keys.contentOptions_allowTotemEquip);
    }

    public static void registerCriteria() {
        ACCESSORY_EQUIPPED = CriteriaTriggersAccessor.accessories$callRegister("accessories:equip_accessory", new AccessoryChangedCriterion());
        ACCESSORY_UNEQUIPPED = CriteriaTriggersAccessor.accessories$callRegister("accessories:unequip_accessory", new AccessoryChangedCriterion());
    }

    public static <T> T handleIoError(String dataName, Function<class_8942.class_11340, T> function) {
        return Accessories.handleIoError(() -> dataName, function);
    }

    public static <T> T handleIoError(class_8942.class_11336 pathElement, Function<class_8942.class_11340, T> function) {
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(pathElement, LOGGER);){
            T t = function.apply(scopedCollector);
            return t;
        }
    }

    public static void handleIoError(String dataName, Consumer<class_8942.class_11340> function) {
        Accessories.handleIoError(() -> dataName, function);
    }

    public static void handleIoError(class_8942.class_11336 pathElement, Consumer<class_8942.class_11340> function) {
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(pathElement, LOGGER);){
            function.accept(scopedCollector);
        }
    }

    static {
        boolean debug = AccessoriesLoaderInternals.INSTANCE.isDevelopmentEnv();
        if (System.getProperty("accessories.debug") != null) {
            debug = Boolean.getBoolean("accessories.debug");
        }
        DEBUG = debug;
        CONFIG = AccessoriesConfig.createAndLoad(serializationBuilder -> {
            serializationBuilder.addEndec(Vector2i.class, EndecUtils.VECTOR_2_I_ENDEC);
            serializationBuilder.addEndec(AccessoriesPlayerOptionsHolder.class, AccessoriesPlayerOptionsHolder.ENDEC);
        });
    }
}

