/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface AccessoriesStorage {
    public String getSlotName();

    @Nullable
    default public SlotType slotType() {
        return SlotTypeLoader.INSTANCE.getSlotType(this.isClientSide(), this.getSlotName());
    }

    default public SlotPath createPath(int index) {
        return SlotPath.of(this.getSlotName(), index);
    }

    @ApiStatus.Internal
    public Map<Integer, Boolean> renderOptions();

    default public boolean shouldRender(int index) {
        return this.renderOptions().getOrDefault(index, true);
    }

    public class_1263 getAccessories();

    public class_1263 getCosmeticAccessories();

    public int getSize();

    public boolean isClientSide();

    default public void forEach(StorageStacksConsumer consumer) {
        class_1263 accessories = this.getAccessories();
        class_1263 cosmetics = this.getAccessories();
        for (int i = 0; i < this.getSize(); ++i) {
            class_1799 stack = accessories.method_5438(i);
            class_1799 cosmetic = cosmetics.method_5438(i);
            consumer.accept(i, stack, cosmetic);
        }
    }

    default public void forEachWithOverride(StorageStacksConsumer consumer) {
        class_1263 accessories = this.getAccessories();
        class_1263 cosmetics = this.getAccessories();
        for (int i = 0; i < this.getSize(); ++i) {
            class_1799 stack = accessories.method_5438(i);
            class_1799 cosmetic = cosmetics.method_5438(i);
            consumer.accept(i, stack, cosmetic);
        }
    }

    public static interface StorageStacksConsumer {
        public void accept(Integer var1, class_1799 var2, class_1799 var3);
    }
}

