/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesStorage;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.core.AccessoryNestUtils;
import io.wispforest.accessories.api.equip.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotPathWithStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_1799;

class AccessoriesStorageLookupUtils {
    AccessoriesStorageLookupUtils() {
    }

    static <E extends SlotPathWithStack> E getFirstEquipped(Map<String, ? extends AccessoriesStorage> containers, BiFunction<SlotPath, class_1799, E> stackEntryMaker, ItemStackBasedPredicate predicate, EquipmentChecking check) {
        for (AccessoriesStorage accessoriesStorage : containers.values()) {
            int i = 0;
            for (class_1799 stack : accessoriesStorage.getAccessories()) {
                SlotPathWithStack ref;
                class_1799 cosmetic;
                SlotPath path = accessoriesStorage.createPath(i);
                if (check == EquipmentChecking.COSMETICALLY_OVERRIDABLE && !(cosmetic = accessoriesStorage.getCosmeticAccessories().method_5438(i)).method_7960() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                    stack = cosmetic;
                }
                if ((ref = AccessoryNestUtils.recursivelyHandle(stack, path, (innerStack, ref1) -> !innerStack.method_7960() && predicate.test(innerStack) ? (SlotPathWithStack)stackEntryMaker.apply(path, innerStack) : null)) != null) {
                    return (E)ref;
                }
                ++i;
            }
        }
        return null;
    }

    static <E extends SlotPathWithStack> List<E> getAllEquipped(Map<String, ? extends AccessoriesStorage> containers, BiFunction<SlotPath, class_1799, E> stackEntryMaker) {
        ArrayList references = new ArrayList();
        for (AccessoriesStorage accessoriesStorage : containers.values()) {
            int i = 0;
            for (class_1799 stack : accessoriesStorage.getAccessories()) {
                if (!stack.method_7960()) {
                    SlotPath path = accessoriesStorage.createPath(i);
                    AccessoryNestUtils.recursivelyConsume(stack, path, (innerStack, path1) -> references.add((SlotPathWithStack)stackEntryMaker.apply(path1, innerStack)));
                }
                ++i;
            }
        }
        return Collections.unmodifiableList(references);
    }
}

