/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.google.common.base.Suppliers;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesStorage;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.SimpleAccessoriesStorage;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.client.DefaultedContextKey;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotPath;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_10444;
import net.minecraft.class_12075;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class AccessoriesRenderStateKeys {
    public static final class_169<SlotPath> SLOT_PATH = new class_169(Accessories.of("slot_path"));
    public static final class_169<class_1799> ITEM_STACK = new class_169(Accessories.of("item_stack"));
    public static final class_169<@Nullable class_10444> ITEM_STACK_STATE = new class_169(Accessories.of("item_stack_state"));
    public static final class_169<class_10042> ENTITY_STATE = new class_169(Accessories.of("entity_state"));
    public static final class_169<@Nullable Map<SlotPath, AccessoryRenderState>> ACCESSORY_RENDER_STATES = new class_169(Accessories.of("item_stack_render_state"));
    public static final class_169<@Nullable AccessoriesStorageLookup> STORAGE_LOOKUP = new class_169(Accessories.of("storage_lookup"));
    public static final DefaultedContextKey<List<@Nullable AccessoryRenderState>> NESTED_ACCESSORY_RENDER_STATES = new DefaultedContextKey<List>(Accessories.of("item_stack_render_state"), List::of);
    public static final class_169<@Nullable class_12075> CAMERA_STATE = new class_169(Accessories.of("entity_uuid"));
    public static final DefaultedContextKey<UUID> ENTITY_UUID = new DefaultedContextKey(Accessories.of("entity_uuid"), Suppliers.memoize(UUID::randomUUID));
    public static final class_169<Integer> ENTITY_ID = new DefaultedContextKey<Integer>(Accessories.of("entity_id"), () -> 0);
    public static final DefaultedContextKey<Float> PARTIAL_TICKS = new DefaultedContextKey<Float>(Accessories.of("partial_ticks"), () -> Float.valueOf(0.0f));
    public static final DefaultedContextKey<Integer> LIGHT = new DefaultedContextKey<Integer>(Accessories.of("light"), () -> 1);
    public static final class_169<class_1306> ARM = new class_169(Accessories.of("arm"));

    public static void setupStateForAccessories(class_10017 state, class_1297 entity, float partialTick, class_1306 arm) {
        if (state instanceof class_10042) {
            class_10042 livingState = (class_10042)state;
            livingState.setStateData(ARM, (Object)arm);
        }
        AccessoriesRenderStateKeys.setupStateForAccessories(state, entity, partialTick);
    }

    public static void setupStateForAccessories(class_10017 state, class_1297 entity, float partialTick) {
        class_10042 livingState;
        block10: {
            block9: {
                if (!(state instanceof class_10042)) break block9;
                livingState = (class_10042)state;
                if (entity instanceof class_1309) break block10;
            }
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        livingState.setStateData(ENTITY_UUID, (Object)livingEntity.method_5667());
        livingState.setStateData(ENTITY_ID, (Object)livingEntity.method_5628());
        livingState.setStateData(PARTIAL_TICKS, (Object)Float.valueOf(partialTick));
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability == null) {
            return;
        }
        LinkedHashMap<String, AccessoriesStorage> map = new LinkedHashMap<String, AccessoriesStorage>();
        for (Map.Entry<String, AccessoriesContainer> entry : capability.getContainers().entrySet()) {
            map.put(entry.getKey(), SimpleAccessoriesStorage.copy(entry.getValue()));
        }
        if (map.isEmpty()) {
            return;
        }
        AccessoriesStorageLookup lookup = () -> map;
        livingState.setStateData(STORAGE_LOOKUP, (Object)lookup);
        LinkedHashMap<SlotPath, AccessoryRenderState> renderStates = new LinkedHashMap<SlotPath, AccessoryRenderState>();
        for (AccessoriesStorage accessoriesStorage : lookup.getContainers().values()) {
            class_1263 accessories = accessoriesStorage.getAccessories();
            class_1263 cosmetics = accessoriesStorage.getCosmeticAccessories();
            for (int i = 0; i < accessoriesStorage.getSize(); ++i) {
                SlotPath path;
                AccessoryRenderState accessoryState;
                AccessoryRenderer renderer;
                class_1799 stack = accessories.method_5438(i);
                class_1799 cosmeticStack = cosmetics.method_5438(i);
                if (!cosmeticStack.method_7960() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                    stack = cosmeticStack;
                }
                if (stack.method_7960() || (renderer = AccessoriesRendererRegistry.getRenderer(stack)).isEmpty() || (accessoryState = renderer.createRenderState(stack, path = accessoriesStorage.createPath(i), lookup, livingEntity, livingState)) == null) continue;
                renderStates.put(path, accessoryState);
            }
        }
        livingState.setStateData(ACCESSORY_RENDER_STATES, renderStates);
    }
}

