/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.client.renderers.BuiltinAccessoryRenderers;
import io.wispforest.accessories.api.client.renderers.DefaultAccessoryRenderer;
import io.wispforest.accessories.api.client.renderers.WrappedAccessoryRenderer;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryCustomRendererComponent;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesRendererRegistry {
    public static final class_2960 NO_RENDERER_ID = Accessories.of("no_renderer");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<class_1792, class_2960> ITEM_TO_RENDERER = new HashMap<class_1792, class_2960>();
    private static final Map<class_1792, class_2960> DATA_LOADED_ITEM_TO_RENDERER = new HashMap<class_1792, class_2960>();
    private static final Map<class_2960, Supplier<AccessoryRenderer>> RENDERERS = new HashMap<class_2960, Supplier<AccessoryRenderer>>();
    private static final BiMap<class_2960, AccessoryRenderer> CACHED_RENDERERS = HashBiMap.create();

    public static void bindItemToRenderer(class_1792 item, class_2960 rendererId) {
        class_2960 entry = ITEM_TO_RENDERER.putIfAbsent(item, rendererId);
        if (entry != null) {
            LOGGER.error("Unable to bind Item with the given Register as Item already has binding: [Item: {}, Renderer: {}]", (Object)item, (Object)rendererId);
        }
    }

    public static void bindItemToRenderer(class_1792 item, class_2960 rendererId, Supplier<AccessoryRenderer> renderer) {
        AccessoriesRendererRegistry.bindItemToRenderer(item, rendererId);
        AccessoriesRendererRegistry.registerRenderer(rendererId, renderer);
    }

    public static void bindItemToEmptyRenderer(class_1792 item) {
        AccessoriesRendererRegistry.bindItemToRenderer(item, NO_RENDERER_ID);
    }

    public static void bindItemToArmorRenderer(class_1792 item) {
        AccessoriesRendererRegistry.bindItemToRenderer(item, BuiltinAccessoryRenderers.ARMOR_RENDERER_ID);
    }

    public static void registerRenderer(class_2960 location, Supplier<AccessoryRenderer> renderer) {
        RENDERERS.put(location, renderer);
    }

    public static boolean hasRenderer(class_1792 item) {
        return AccessoriesRendererRegistry.getBoundRenderer(item) != null;
    }

    public static boolean hasRenderer(class_2960 rendererId) {
        return RENDERERS.containsKey(rendererId);
    }

    public static AccessoryRenderer getRenderer(class_1799 stack) {
        if (stack.method_57826(AccessoriesDataComponents.CUSTOM_RENDERER) && !stack.method_31574(class_1802.field_27023)) {
            AccessoryCustomRendererComponent data = (AccessoryCustomRendererComponent)stack.method_58694(AccessoriesDataComponents.CUSTOM_RENDERER);
            if (data != null) {
                return BuiltinAccessoryRenderers.DATA_DRIVEN;
            }
            Boolean defaultRenderOverride = data.defaultRenderOverride();
            if (defaultRenderOverride != null) {
                if (defaultRenderOverride.booleanValue()) {
                    return DefaultAccessoryRenderer.INSTANCE;
                }
                if (AccessoryRegistry.isDefaultAccessory(stack)) {
                    return new BuiltinAccessoryRenderers.EmptyRenderer();
                }
            }
        }
        return AccessoriesRendererRegistry.getRenderer(stack.method_7909());
    }

    public static AccessoryRenderer getRenderer(class_1792 item) {
        AccessoryRenderer renderer;
        class_2960 id = AccessoriesRendererRegistry.getBoundRenderer(item);
        if (id != null) {
            renderer = AccessoriesRendererRegistry.getRenderer(id);
            if (renderer == null) {
                renderer = DefaultAccessoryRenderer.INSTANCE;
            }
        } else {
            renderer = DefaultAccessoryRenderer.INSTANCE;
        }
        if (renderer instanceof BuiltinAccessoryRenderers.EmptyRenderer && Accessories.config().clientOptions.forceNullRenderReplacement()) {
            renderer = DefaultAccessoryRenderer.INSTANCE;
        } else if (renderer == null) {
            renderer = new BuiltinAccessoryRenderers.EmptyRenderer();
        }
        return renderer == null ? new BuiltinAccessoryRenderers.EmptyRenderer() : renderer;
    }

    @Nullable
    public static AccessoryRenderer getRenderer(class_2960 rendererId) {
        if (rendererId.equals((Object)NO_RENDERER_ID)) {
            return new BuiltinAccessoryRenderers.EmptyRenderer();
        }
        return (AccessoryRenderer)CACHED_RENDERERS.get((Object)rendererId);
    }

    @Nullable
    public static class_2960 getRendererId(AccessoryRenderer renderer) {
        return (class_2960)CACHED_RENDERERS.inverse().get((Object)renderer);
    }

    @Nullable
    public static class_2960 getBoundRenderer(class_1792 item) {
        if (DATA_LOADED_ITEM_TO_RENDERER.containsKey(item)) {
            return DATA_LOADED_ITEM_TO_RENDERER.get(item);
        }
        return ITEM_TO_RENDERER.get(item);
    }

    @ApiStatus.Internal
    public static void setDataLoadedItemToRenderer(Map<class_1792, class_2960> data) {
        DATA_LOADED_ITEM_TO_RENDERER.clear();
        DATA_LOADED_ITEM_TO_RENDERER.putAll(data);
    }

    @ApiStatus.Internal
    public static void onReload() {
        CACHED_RENDERERS.clear();
        RENDERERS.forEach((rendererId, supplier) -> {
            class_2960 otherRendererId;
            AccessoryRenderer renderer = (AccessoryRenderer)supplier.get();
            if (renderer == null) {
                LOGGER.warn("A given renderer [{}] was found to be returning a null renderer which is not advised as method to indicate no rendering!", rendererId);
                renderer = new BuiltinAccessoryRenderers.EmptyRenderer();
            }
            if ((otherRendererId = (class_2960)CACHED_RENDERERS.inverse().get((Object)renderer)) != null) {
                LOGGER.warn("A given renderer [{}] was found to be shared by another renderer [{}], such will be wrapped to prevent crashing and should be reported!", rendererId, (Object)otherRendererId);
                renderer = new WrappedAccessoryRenderer(renderer);
            }
            CACHED_RENDERERS.put(rendererId, (Object)renderer);
        });
    }

    @Deprecated(forRemoval=true)
    public static class_2960 getRendererId(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item);
    }

    @Deprecated(forRemoval=true)
    public static void registerRenderer(class_1792 item, Supplier<@NotNull AccessoryRenderer> renderer) {
        class_2960 rendererId = AccessoriesRendererRegistry.getRendererId(item);
        AccessoriesRendererRegistry.registerRenderer(rendererId, renderer);
        AccessoriesRendererRegistry.bindItemToRenderer(item, rendererId);
    }

    @Deprecated(forRemoval=true)
    public static void registerNoRenderer(class_1792 item) {
        AccessoriesRendererRegistry.bindItemToRenderer(item, NO_RENDERER_ID);
    }

    @Deprecated(forRemoval=true)
    public static void registerArmorRendering(class_1792 item) {
        if (!AccessoriesRendererRegistry.hasRenderer(item)) {
            class_2960 rendererId = AccessoriesRendererRegistry.getRendererId(item);
            AccessoriesRendererRegistry.registerRenderer(rendererId, () -> BuiltinAccessoryRenderers.ARMOR_RENDERER);
            AccessoriesRendererRegistry.bindItemToRenderer(item, rendererId);
        }
    }
}

