/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.DefaultedContextKey;
import io.wispforest.accessories.api.client.RenderStateStorage;
import io.wispforest.accessories.api.slot.SlotPath;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10042;
import net.minecraft.class_10444;
import net.minecraft.class_1309;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_811;

public class AccessoryRenderState
implements RenderStateStorage {
    private final List<RenderStateStorage> otherStates = new ArrayList<RenderStateStorage>();
    private final Reference2ObjectMap<class_169<?>, Object> stateData = new Reference2ObjectOpenHashMap();

    @Override
    public <T> T getStateData(class_169<T> key) {
        T t;
        if (this.stateData.containsKey(key)) {
            return (T)this.stateData.get(key);
        }
        for (RenderStateStorage otherState : this.otherStates) {
            if (!otherState.hasStateData(key)) continue;
            return this.getStateData(key);
        }
        if (key instanceof DefaultedContextKey) {
            DefaultedContextKey defaultedKey = (DefaultedContextKey)key;
            t = defaultedKey.getDefaultValue();
        } else {
            t = null;
        }
        return t;
    }

    @Override
    public <T> boolean hasStateData(class_169<T> key) {
        if (this.stateData.containsKey(key)) {
            return true;
        }
        return this.otherStates.stream().anyMatch(state -> state.hasStateData(key));
    }

    @Override
    public <T> void setStateData(class_169<T> key, T data) {
        if (data == null) {
            this.stateData.remove(key);
        } else {
            this.stateData.put(key, data);
        }
    }

    @Override
    public void clearExtraData() {
        this.stateData.clear();
    }

    public static AccessoryRenderState setupState(SlotPath path, class_1799 stack, class_1309 entity, class_10042 entityState, boolean createStackRenderState) {
        AccessoryRenderState state = new AccessoryRenderState();
        state.setStateData(AccessoriesRenderStateKeys.SLOT_PATH, path);
        state.setStateData(AccessoriesRenderStateKeys.ITEM_STACK, stack);
        state.setStateData(AccessoriesRenderStateKeys.ENTITY_STATE, entityState);
        if (createStackRenderState) {
            class_10444 stackRenderState = new class_10444();
            class_310.method_1551().method_65386().method_65597(stackRenderState, stack, class_811.field_4319, entity);
            state.setStateData(AccessoriesRenderStateKeys.ITEM_STACK_STATE, stackRenderState);
        }
        return state;
    }
}

