/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.renderers;

import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.slot.SlotPath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10042;
import net.minecraft.class_11659;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_583;
import org.jetbrains.annotations.Nullable;

public interface AccessoryNestRenderer
extends AccessoryRenderer {
    default public List<class_1799> getInnerStacks(class_1799 holderStack) {
        AccessoryNestContainerContents data = (AccessoryNestContainerContents)holderStack.method_58694(AccessoriesDataComponents.NESTED_ACCESSORIES);
        if (data == null) {
            return List.of();
        }
        return data.accessories();
    }

    @Override
    default public <S extends class_10042> void render(AccessoryRenderState accessoryState, S entityState, class_583<S> model, class_4587 matrices, class_11659 collector) {
        List<AccessoryRenderState> innerStates = accessoryState.getStateData(AccessoriesRenderStateKeys.NESTED_ACCESSORY_RENDER_STATES);
        for (AccessoryRenderState innerState : innerStates) {
            if (innerState == null) continue;
            class_1799 innerStack = innerState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(innerStack);
            matrices.method_22903();
            try {
                renderer.render(innerState, entityState, model, matrices, collector);
            }
            catch (Exception e) {
                throw new IllegalStateException("[AccessoryNestRenderer] Unable to render a given inner item stack due the following error: ", e);
            }
            finally {
                matrices.method_22909();
            }
        }
    }

    @Override
    default public void extractRenderState(class_1799 stack, SlotPath path, AccessoriesStorageLookup storageLookup, class_1309 entity, class_10042 entityState, AccessoryRenderState accessoryState) {
        AccessoryRenderer.super.extractRenderState(stack, path, storageLookup, entity, entityState, accessoryState);
        ArrayList<@Nullable AccessoryRenderState> innerStates = new ArrayList<AccessoryRenderState>();
        List<class_1799> innerStacks = this.getInnerStacks(stack);
        for (int i = 0; i < innerStacks.size(); ++i) {
            class_1799 innerStack = innerStacks.get(i);
            AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(innerStack);
            AccessoryRenderState state = renderer.createRenderState(innerStack, SlotPath.withInnerIndex(path, i), storageLookup, entity, entityState);
            innerStates.add(state);
        }
        accessoryState.setStateData(AccessoriesRenderStateKeys.NESTED_ACCESSORY_RENDER_STATES, innerStates);
    }

    @Override
    default public boolean shouldRender(class_1799 stack, SlotPath path, AccessoriesStorageLookup storageLookup, class_1309 entity, class_10042 renderState, boolean isRenderingEnabled) {
        List<class_1799> innerStacks = this.getInnerStacks(stack);
        for (class_1799 innerStack : innerStacks) {
            AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(innerStack);
            if (!renderer.shouldRender(stack, path, storageLookup, entity, renderState, isRenderingEnabled)) continue;
            return true;
        }
        return AccessoryRenderer.super.shouldRender(stack, path, storageLookup, entity, renderState, isRenderingEnabled);
    }
}

