/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.renderers;

import com.google.common.collect.Streams;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesLoaderInternals;
import io.wispforest.accessories.api.AccessoriesStorageLookup;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderState;
import io.wispforest.accessories.api.client.renderers.AccessoryNestRenderer;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.client.renderers.DefaultAccessoryRenderer;
import io.wispforest.accessories.api.client.rendering.RenderingFunctionOps;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryCustomRendererComponent;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.compat.GeckoLibCompat;
import io.wispforest.accessories.mixin.client.HumanoidArmorLayerAccessor;
import io.wispforest.accessories.mixin.client.LivingEntityRendererAccessor;
import io.wispforest.accessories.pond.WingsLayerExtension;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10034;
import net.minecraft.class_10042;
import net.minecraft.class_10192;
import net.minecraft.class_11659;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import net.minecraft.class_970;
import net.minecraft.class_979;
import org.jetbrains.annotations.ApiStatus;

public class BuiltinAccessoryRenderers {
    public static final AccessoryRenderer ARMOR_RENDERER = new AccessoryRenderer(){

        @Override
        public <S extends class_10042> void render(AccessoryRenderState accessoryState, S entityState, class_583<S> model, class_4587 matrices, class_11659 collector) {
            if (!(entityState instanceof class_10034)) {
                return;
            }
            class_10034 humanoidRenderState = (class_10034)entityState;
            class_897 entityRender = class_310.method_1551().method_1561().method_68832(entityState);
            if (!(entityRender instanceof LivingEntityRendererAccessor)) {
                return;
            }
            LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)entityRender;
            class_1799 stack = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            if (!stack.method_57826(class_9334.field_54196)) {
                return;
            }
            class_1304 equipmentSlot = ((class_10192)stack.method_58694(class_9334.field_54196)).comp_3174();
            Optional<class_3887> possibleLayer = accessor.getLayers().stream().filter(renderLayer -> renderLayer instanceof class_970).findFirst();
            possibleLayer.ifPresent(layer -> BuiltinAccessoryRenderers.rendererArmor((class_970)layer, stack, matrices, collector, humanoidRenderState, equipmentSlot));
        }
    };
    public static final AccessoryRenderer ELYTRA_RENDERER = new AccessoryRenderer(){

        @Override
        public <S extends class_10042> void render(AccessoryRenderState accessoryState, S entityState, class_583<S> model, class_4587 matrices, class_11659 collector) {
            if (!(entityState instanceof class_10034)) {
                return;
            }
            class_10034 humanoidRenderState = (class_10034)entityState;
            class_897 entityRender = class_310.method_1551().method_1561().method_68832(entityState);
            if (!(entityRender instanceof LivingEntityRendererAccessor)) {
                return;
            }
            LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)entityRender;
            class_1799 stack = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            if (!stack.method_57826(class_9334.field_54197)) {
                return;
            }
            Optional<class_3887> possibleLayer = accessor.getLayers().stream().filter(renderLayer -> renderLayer instanceof class_979).findFirst();
            Integer light = (Integer)entityState.getStateData(AccessoriesRenderStateKeys.LIGHT);
            possibleLayer.ifPresent(layer -> ((WingsLayerExtension)layer).renderStack(stack, matrices, collector, light, humanoidRenderState));
        }
    };
    public static final DataDrivenAccessoryRenderer DATA_DRIVEN = new DataDrivenAccessoryRenderer();
    public static final class_2960 BUNDLE_RENDERER_ID = Accessories.of("bundle_renderer");
    public static final class_2960 DEFAULT_RENDERER_ID = Accessories.of("default_renderer");
    public static final class_2960 ARMOR_RENDERER_ID = Accessories.of("armor_renderer");
    public static final class_2960 ELYTRA_RENDERER_ID = Accessories.of("elytra_renderer");

    private static <S extends class_10034, M extends class_572<S>, A extends class_572<S>> void rendererArmor(class_970<S, M, A> armorLayer, class_1799 stack, class_4587 poseStack, class_11659 submitNodeCollector, S renderState, class_1304 equipmentSlot) {
        HumanoidArmorLayerAccessor armorLayerAccessor = (HumanoidArmorLayerAccessor)armorLayer;
        Integer light = (Integer)renderState.getStateData(AccessoriesRenderStateKeys.LIGHT);
        Float partialTicks = (Float)renderState.getStateData(AccessoriesRenderStateKeys.PARTIAL_TICKS);
        if (!BuiltinAccessoryRenderers.attemptGeckoRender(stack, poseStack, submitNodeCollector, renderState, equipmentSlot, light, partialTicks.floatValue(), (class_572)armorLayer.method_17165())) {
            armorLayerAccessor.accessories$renderArmorPiece(poseStack, submitNodeCollector, stack, equipmentSlot, light, renderState);
        }
    }

    private static <S extends class_10034, M extends class_572<S>, A extends class_572<S>> boolean attemptGeckoRender(class_1799 stack, class_4587 poseStack, class_11659 submitNodeCollector, S renderState, class_1304 equipmentSlot, int light, float partialTicks, M parentModel) {
        if (!AccessoriesLoaderInternals.INSTANCE.isModLoaded("geckolib")) {
            return false;
        }
        return GeckoLibCompat.renderGeckoArmor(poseStack, submitNodeCollector, renderState, stack, equipmentSlot, parentModel, partialTicks, light);
    }

    public static void onAddCallback(class_1792 item) {
    }

    static {
        AccessoriesRendererRegistry.bindItemToRenderer(class_1802.field_27023, BUNDLE_RENDERER_ID, BundleAccessoryRenderer::new);
        AccessoriesRendererRegistry.registerRenderer(DEFAULT_RENDERER_ID, () -> DefaultAccessoryRenderer.INSTANCE);
        AccessoriesRendererRegistry.registerRenderer(ARMOR_RENDERER_ID, () -> ARMOR_RENDERER);
        AccessoriesRendererRegistry.registerRenderer(ELYTRA_RENDERER_ID, () -> ELYTRA_RENDERER);
    }

    @ApiStatus.Internal
    public static class DataDrivenAccessoryRenderer
    implements AccessoryRenderer {
        @Override
        public <S extends class_10042> void render(AccessoryRenderState accessoryState, S entityState, class_583<S> model, class_4587 matrices, class_11659 collector) {
            class_1799 stack = accessoryState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            SlotPath path = accessoryState.getStateData(AccessoriesRenderStateKeys.SLOT_PATH);
            AccessoryCustomRendererComponent data = (AccessoryCustomRendererComponent)stack.method_58694(AccessoriesDataComponents.CUSTOM_RENDERER);
            if (data == null || data.renderingFunctions() == null) {
                return;
            }
            Integer light = (Integer)entityState.getStateData(AccessoriesRenderStateKeys.LIGHT);
            Float partialTicks = (Float)entityState.getStateData(AccessoriesRenderStateKeys.PARTIAL_TICKS);
            RenderingFunctionOps.handleFunctions(stack, path, matrices, model, entityState, collector, light, partialTicks.floatValue(), (class_1306)entityState.getStateData(AccessoriesRenderStateKeys.ARM), 0xF000F0, class_4608.field_21444, -1, data.renderingFunctions());
        }

        @Override
        public boolean shouldRender(class_1799 stack, SlotPath path, AccessoriesStorageLookup storageLookup, class_1309 entity, class_10042 entityState, boolean isRenderingEnabled) {
            AccessoryCustomRendererComponent data = (AccessoryCustomRendererComponent)stack.method_58694(AccessoriesDataComponents.CUSTOM_RENDERER);
            if (data == null || data.renderingFunctions() == null) {
                return false;
            }
            return RenderingFunctionOps.shouldRender(stack, path, storageLookup, entity, entityState, data.renderingFunctions()) && isRenderingEnabled;
        }
    }

    public static final class EmptyRenderer
    implements AccessoryRenderer {
        @Override
        public <S extends class_10042> void render(AccessoryRenderState accessoryState, S entityState, class_583<S> model, class_4587 matrices, class_11659 collector) {
        }
    }

    @ApiStatus.Internal
    public static class BundleAccessoryRenderer
    implements AccessoryNestRenderer {
        @Override
        public List<class_1799> getInnerStacks(class_1799 holderStack) {
            List stacks;
            class_9276 contents = (class_9276)holderStack.method_58694(class_9334.field_49650);
            Iterable items = contents.method_57421();
            return items instanceof List ? (stacks = (List)items) : Streams.stream((Iterable)items).toList();
        }
    }
}

