/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.screen;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.screen.PlayerBasedTargetGetter;
import io.wispforest.accessories.api.client.screen.ScreenBasedTargetGetter;
import io.wispforest.accessories.api.client.screen.ScreenOpener;
import io.wispforest.accessories.api.client.screen.ScreenReopener;
import io.wispforest.accessories.compat.config.MenuButtonInjection;
import io.wispforest.accessories.mixin.HorseInventoryMenuAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.ContainerClose;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_491;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class AccessoriesScreenTransitionHelper {
    private static boolean INITIALIZED_INJECTIONS = false;
    public static final Event<MenuButtonInjectionCallback> EVENT = EventFactory.createArrayBacked(MenuButtonInjectionCallback.class, invokers -> registerFunc -> {
        for (MenuButtonInjectionCallback invoker : invokers) {
            invoker.registerInjections(registerFunc);
        }
    });
    private static final List<Class<class_465<class_1703>>> SCREEN_CLASSES = new ArrayList<Class<class_465<class_1703>>>();
    private static final Map<class_2960, MenuButtonInjection> BUTTON_INJECTION_DATA = new HashMap<class_2960, MenuButtonInjection>();
    private static final Map<Predicate<class_465<class_1703>>, ScreenTransitionHelper> SCREEN_PREDICATES = new LinkedHashMap<Predicate<class_465<class_1703>>, ScreenTransitionHelper>();
    private static final List<PlayerBasedTargetGetter> SCREENLESS_TARGET_GETTERS = new ArrayList<PlayerBasedTargetGetter>();
    private static final List<ScreenOpener> SCREEN_OPENERS = new ArrayList<ScreenOpener>();
    @Nullable
    private static class_437 prevScreen = null;
    @Nullable
    private static MenuButtonInjection prevInjection = null;
    @Nullable
    private static ScreenTransitionHelper prevScreenInfo = null;

    public static void registerTargetGetter(PlayerBasedTargetGetter getter) {
        SCREENLESS_TARGET_GETTERS.add(getter);
    }

    public static void registerScreenOpener(ScreenOpener screenOpener) {
        SCREEN_OPENERS.add(screenOpener);
    }

    @SafeVarargs
    public static void registerScreensForButton(Class<? extends class_465<?>> ... screenClasses) {
        SCREEN_CLASSES.addAll(List.of(screenClasses));
    }

    public static <M extends class_1703, S extends class_465<M>> void registerPlayerScreenTransition(class_2960 location, Class<S> screenClass) {
        AccessoriesScreenTransitionHelper.registerPlayerScreenTransition(location, screenClass::isInstance);
        AccessoriesScreenTransitionHelper.registerScreensForButton(screenClass);
    }

    public static void registerPlayerScreenTransition(class_2960 location, Predicate<class_465<class_1703>> screenPredicate) {
        AccessoriesScreenTransitionHelper.registerScreenTransition(location, screenPredicate, ScreenBasedTargetGetter.PLAYER_DEFAULTED_TARGET, ScreenReopener.PLAYER_INVENTORY);
    }

    public static <M extends class_1703, S extends class_465<M>> void registerScreenTransitionWithCustomInvReopener(class_2960 location, Class<S> screenClass, ScreenBasedTargetGetter<M, S> getter) {
        AccessoriesScreenTransitionHelper.registerScreenTransition(location, screenClass, getter, ScreenReopener.CUSTOM_INVENTORY);
    }

    public static <M extends class_1703, S extends class_465<M>> void registerScreenTransition(class_2960 location, Class<S> screenClass, ScreenBasedTargetGetter<M, S> getter, ScreenReopener<M, S> reopener) {
        AccessoriesScreenTransitionHelper.registerScreenTransition(location, screenClass::isInstance, getter, reopener);
        AccessoriesScreenTransitionHelper.registerScreensForButton(screenClass);
    }

    public static void registerScreenTransition(class_2960 location, Predicate<class_465<class_1703>> screenPredicate, ScreenBasedTargetGetter<class_1703, class_465<class_1703>> targetEntityGetter, ScreenReopener<class_1703, class_465<class_1703>> reopener) {
        SCREEN_PREDICATES.put(screenPredicate, new ScreenTransitionHelper(location, targetEntityGetter, reopener));
    }

    @ApiStatus.Internal
    public static Class<class_465>[] getScreenClasses() {
        return (Class[])List.copyOf(SCREEN_CLASSES).toArray(Class[]::new);
    }

    @ApiStatus.Internal
    @Nullable
    public static MenuButtonInjection getInjection(class_465<class_1703> screen) {
        if (!INITIALIZED_INJECTIONS) {
            AccessoriesScreenTransitionHelper.initInjections();
        }
        if (screen.equals((Object)prevScreen)) {
            return prevInjection;
        }
        MenuButtonInjection injection = null;
        ScreenTransitionHelper info = null;
        try {
            class_2960 typeLocation = class_7923.field_41187.method_10221((Object)screen.method_17577().method_17358());
            injection = BUTTON_INJECTION_DATA.get(typeLocation);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (injection == null && (info = AccessoriesScreenTransitionHelper.getInfo(screen)) != null) {
            injection = BUTTON_INJECTION_DATA.get(info.location());
        }
        prevScreen = screen;
        prevInjection = injection;
        prevScreenInfo = info;
        return injection;
    }

    @Nullable
    private static ScreenTransitionHelper getInfo(class_465<class_1703> screen) {
        for (Map.Entry<Predicate<class_465<class_1703>>, ScreenTransitionHelper> entry : SCREEN_PREDICATES.entrySet()) {
            if (!entry.getKey().test(screen)) continue;
            return entry.getValue();
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static class_1309 getTargetEntity(class_465<class_1703> screen) {
        if (prevScreenInfo == null) {
            return null;
        }
        return prevScreenInfo.getter().getTarget(screen);
    }

    @ApiStatus.Internal
    @Nullable
    public static class_1309 getTargetEntity(class_746 player) {
        for (PlayerBasedTargetGetter targetGetter : SCREENLESS_TARGET_GETTERS) {
            class_1309 target = targetGetter.getTarget(player);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    @ApiStatus.Internal
    public static void openPrevScreen(class_1657 player, class_1309 targetEntity, @Nullable class_465<class_1703> screen) {
        if (screen != null) {
            ScreenTransitionHelper info = AccessoriesScreenTransitionHelper.getInfo(screen);
            if (info != null && info.reopener.reopenScreen(player, targetEntity, screen)) {
                return;
            }
        } else {
            if (Accessories.config().screenOptions.backButtonClosesScreen()) {
                class_310.method_1551().method_1507(null);
                return;
            }
            for (ScreenOpener screenOpener : SCREEN_OPENERS) {
                if (!screenOpener.openScreen(player, targetEntity)) continue;
                return;
            }
        }
        class_310.method_1551().method_1507((class_437)new class_490(player));
        player.field_7512 = player.field_7498;
        AccessoriesNetworking.sendToServer(new ContainerClose());
    }

    @ApiStatus.Internal
    public static void init() {
        AccessoriesScreenTransitionHelper.registerPlayerScreenTransition(class_2960.method_60656((String)"creative_player_inventory"), class_481.class);
        AccessoriesScreenTransitionHelper.registerPlayerScreenTransition(class_2960.method_60656((String)"player_inventory"), class_490.class);
        AccessoriesScreenTransitionHelper.registerScreenTransitionWithCustomInvReopener(class_2960.method_60656((String)"horse_inventory"), class_491.class, screen -> ((HorseInventoryMenuAccessor)screen.method_17577()).accessories$horse());
        AccessoriesScreenTransitionHelper.registerTargetGetter(player -> {
            class_1496 abstractHorse;
            class_1297 patt0$temp = player.method_5854();
            return patt0$temp instanceof class_1496 ? (abstractHorse = (class_1496)patt0$temp) : null;
        });
        AccessoriesScreenTransitionHelper.registerScreenOpener(ScreenOpener.CUSTOM_INVENTORY);
    }

    public static void initInjections() {
        Consumer<List<MenuButtonInjection>> consumer = injections -> {
            BUTTON_INJECTION_DATA.clear();
            injections.forEach(injection -> BUTTON_INJECTION_DATA.putIfAbsent(injection.menuType(), (MenuButtonInjection)injection));
            ((MenuButtonInjectionCallback)EVENT.invoker()).registerInjections(BUTTON_INJECTION_DATA::putIfAbsent);
        };
        Accessories.config().screenOptions.subscribeToMenuButtonInjections(consumer);
        consumer.accept(Accessories.config().screenOptions.menuButtonInjections());
        INITIALIZED_INJECTIONS = true;
    }

    private record ScreenTransitionHelper(class_2960 location, ScreenBasedTargetGetter<class_1703, class_465<class_1703>> getter, ScreenReopener<class_1703, class_465<class_1703>> reopener) {
    }

    public static interface MenuButtonInjectionCallback {
        public void registerInjections(BiConsumer<class_2960, MenuButtonInjection> var1);
    }
}

