/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.core;

import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryStackSettings;
import io.wispforest.accessories.api.events.DropRule;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.mixin.LivingEntityAccessor;
import java.util.List;
import net.minecraft.class_10192;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5244;
import net.minecraft.class_6880;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public interface Accessory {
    default public void tick(class_1799 stack, SlotReference reference) {
    }

    default public void onEquip(class_1799 stack, SlotReference reference) {
    }

    default public void onUnequip(class_1799 stack, SlotReference reference) {
    }

    @ApiStatus.OverrideOnly
    default public boolean canEquip(class_1799 stack, SlotReference reference) {
        return true;
    }

    @ApiStatus.OverrideOnly
    default public boolean canUnequip(class_1799 stack, SlotReference reference) {
        if (class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51656)) {
            class_1657 player;
            class_1309 class_13092 = reference.entity();
            return class_13092 instanceof class_1657 && (player = (class_1657)class_13092).method_68878();
        }
        return true;
    }

    default public void getDynamicModifiers(class_1799 stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        this.getModifiers(stack, reference, builder);
    }

    default public void getStaticModifiers(class_1792 item, AccessoryItemAttributeModifiers.Builder builder) {
    }

    @MustBeInvokedByOverriders
    default public DropRule getDropRule(class_1799 stack, SlotReference reference, class_1282 source) {
        return ((AccessoryStackSettings)stack.method_58695(AccessoriesDataComponents.STACK_SETTINGS, (Object)AccessoryStackSettings.DEFAULT)).dropRule();
    }

    @MustBeInvokedByOverriders
    default public void onEquipFromUse(class_1799 stack, SlotReference reference) {
        SoundEventData sound = this.getEquipSound(stack, reference);
        if (sound == null) {
            return;
        }
        reference.entity().method_5783((class_3414)sound.event().comp_349(), sound.volume(), sound.pitch());
    }

    @Nullable
    default public SoundEventData getEquipSound(class_1799 stack, SlotReference reference) {
        class_6880 equipSound = stack.method_57826(class_9334.field_54196) ? ((class_10192)stack.method_58694(class_9334.field_54196)).comp_3175() : class_3417.field_14883;
        return new SoundEventData((class_6880<class_3414>)equipSound, 1.0f, 1.0f);
    }

    @MustBeInvokedByOverriders
    default public boolean canEquipFromUse(class_1799 stack, SlotReference reference) {
        if (stack.method_57826(AccessoriesDataComponents.STACK_SETTINGS)) {
            return ((AccessoryStackSettings)stack.method_58694(AccessoriesDataComponents.STACK_SETTINGS)).canEquipFromUse();
        }
        if (stack.method_57826(class_9334.field_54196)) {
            return ((class_10192)stack.method_58694(class_9334.field_54196)).comp_3213();
        }
        return true;
    }

    default public boolean canEquipFromDispenser(class_1799 stack, SlotReference reference) {
        if (stack.method_57826(AccessoriesDataComponents.STACK_SETTINGS)) {
            return ((AccessoryStackSettings)stack.method_58694(AccessoriesDataComponents.STACK_SETTINGS)).canEquipFromDispenser();
        }
        if (stack.method_57826(class_9334.field_54196)) {
            return ((class_10192)stack.method_58694(class_9334.field_54196)).comp_3178();
        }
        return true;
    }

    default public void onBreak(class_1799 stack, SlotReference reference) {
        ((LivingEntityAccessor)reference.entity()).accessors$breakItem(stack);
    }

    default public int maxStackSize(class_1799 stack) {
        AccessoryStackSettings data = (AccessoryStackSettings)stack.method_58695(AccessoriesDataComponents.STACK_SETTINGS, (Object)AccessoryStackSettings.DEFAULT);
        if (data.useStackSize()) {
            return stack.method_7914();
        }
        return Math.min(Math.max(data.sizeOverride(), 1), stack.method_7914());
    }

    default public void getAttributesTooltip(class_1799 stack, SlotType type, List<class_2561> tooltips, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        this.getAttributesTooltip(stack, type, tooltips);
        class_2561 component = ((AccessoryStackSettings)stack.method_58695(AccessoriesDataComponents.STACK_SETTINGS, (Object)AccessoryStackSettings.DEFAULT)).slotBasedTooltips().get(type.name());
        if (component != null && !component.equals((Object)class_5244.field_39003)) {
            tooltips.add(component);
        }
    }

    default public void getExtraTooltip(class_1799 stack, List<class_2561> tooltips, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        this.getExtraTooltip(stack, tooltips);
        class_2561 component = ((AccessoryStackSettings)stack.method_58695(AccessoriesDataComponents.STACK_SETTINGS, (Object)AccessoryStackSettings.DEFAULT)).extraTooltip();
        if (!component.equals((Object)class_5244.field_39003)) {
            tooltips.add(component);
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    default public boolean canEquipFromUse(class_1799 stack) {
        try {
            return this.canEquipFromUse(stack, null);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    default public void getModifiers(class_1799 stack, SlotReference reference, AccessoryAttributeBuilder builder) {
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    default public void getAttributesTooltip(class_1799 stack, SlotType type, List<class_2561> tooltips) {
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    default public void getExtraTooltip(class_1799 stack, List<class_2561> tooltips) {
    }
}

