/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.core;

import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNestUtils;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.events.DropRule;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import net.minecraft.class_9851;
import org.jetbrains.annotations.Nullable;

public interface AccessoryNest
extends Accessory {
    public static boolean isNest(class_1799 holderStack) {
        return AccessoryRegistry.getAccessoryOrDefault(holderStack) instanceof AccessoryNest;
    }

    default public List<class_1799> getInnerStacks(class_1799 holderStack) {
        AccessoryNestContainerContents data = (AccessoryNestContainerContents)holderStack.method_58694(AccessoriesDataComponents.NESTED_ACCESSORIES);
        return data == null ? List.of() : data.accessories();
    }

    default public boolean setInnerStack(class_1799 holderStack, int index, class_1799 newStack) {
        if (!AccessoryNest.isNest(holderStack)) {
            return false;
        }
        if (AccessoryNest.isNest(newStack) && !this.allowDeepRecursion()) {
            return false;
        }
        holderStack.method_57368(AccessoriesDataComponents.NESTED_ACCESSORIES, (Object)new AccessoryNestContainerContents(List.of()), contents -> contents.setStack(index, newStack));
        return true;
    }

    default public boolean allowDeepRecursion() {
        return false;
    }

    default public List<Pair<DropRule, class_1799>> getDropRules(class_1799 stack, SlotReference reference, class_1282 source) {
        ArrayList<Pair<DropRule, class_1799>> innerRules = new ArrayList<Pair<DropRule, class_1799>>();
        List<class_1799> innerStacks = this.getInnerStacks(stack);
        for (int i = 0; i < innerStacks.size(); ++i) {
            class_1799 innerStack = innerStacks.get(i);
            DropRule rule = AccessoryRegistry.getAccessoryOrDefault(innerStack).getDropRule(innerStack, SlotPath.cloneWithInnerIndex(reference, i), source);
            innerRules.add((Pair<DropRule, class_1799>)Pair.of((Object)((Object)rule), (Object)innerStack));
        }
        return innerRules;
    }

    default public void onStackChanges(class_1799 holderStack, AccessoryNestContainerContents data, @Nullable class_1309 livingEntity) {
    }

    @Override
    default public void onBreak(class_1799 stack, SlotReference reference) {
        AccessoryNestUtils.consumeEntries(stack, reference, Accessory::onBreak);
    }

    @Override
    default public boolean canEquipFromUse(class_1799 stack, SlotReference reference) {
        return AccessoryNestUtils.handleEntries(stack, reference, new AccessoryNestUtils.PathedAccessoryFunction<SlotReference, class_9851>(this){

            @Override
            public class_9851 handle(Accessory accessory, class_1799 innerStack, SlotReference innerRef) {
                return accessory.canEquipFromUse(innerStack, innerRef) ? class_9851.field_52396 : class_9851.field_52395;
            }

            @Override
            public boolean isDefaulted(class_9851 state) {
                return state != class_9851.field_52396;
            }
        }).method_61348(true);
    }

    @Override
    default public void onEquipFromUse(class_1799 stack, SlotReference reference) {
        AccessoryNestUtils.consumeEntries(stack, reference, Accessory::onEquipFromUse);
    }

    @Override
    default public void tick(class_1799 stack, SlotReference reference) {
        AccessoryNestUtils.consumeEntries(stack, reference, Accessory::tick);
    }

    @Override
    default public void onEquip(class_1799 stack, SlotReference reference) {
        AccessoryNestUtils.consumeEntries(stack, reference, Accessory::onEquip);
    }

    @Override
    default public void onUnequip(class_1799 stack, SlotReference reference) {
        AccessoryNestUtils.consumeEntries(stack, reference, Accessory::onUnequip);
    }

    @Override
    default public boolean canEquip(class_1799 stack, SlotReference reference) {
        return AccessoryNestUtils.handleEntries(stack, reference, (accessory, innerStack, innerRef) -> accessory.canEquip(innerStack, (SlotReference)innerRef) ? null : Boolean.valueOf(false));
    }

    @Override
    default public boolean canUnequip(class_1799 stack, SlotReference reference) {
        if (class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51656)) {
            class_1657 player;
            class_1309 class_13092 = reference.entity();
            return class_13092 instanceof class_1657 && (player = (class_1657)class_13092).method_68878();
        }
        return AccessoryNestUtils.handleEntries(stack, reference, (accessory, innerStack, innerRef) -> accessory.canUnequip(innerStack, (SlotReference)innerRef) ? null : Boolean.valueOf(false));
    }

    @Override
    default public void getDynamicModifiers(class_1799 stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        AccessoryNestUtils.consumeEntries(stack, reference, (accessory, innerStack, innerRef) -> accessory.getDynamicModifiers(innerStack, (SlotReference)innerRef, new AccessoryAttributeBuilder(innerRef, builder)));
    }

    @Override
    default public void getAttributesTooltip(class_1799 stack, SlotType type, List<class_2561> tooltips, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        AccessoryNestUtils.consumeEntries(stack, (accessory, innerStack) -> accessory.getAttributesTooltip(innerStack, type, tooltips, tooltipContext, tooltipType));
    }

    @Override
    default public void getExtraTooltip(class_1799 stack, List<class_2561> tooltips, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        AccessoryNestUtils.consumeEntries(stack, (accessory, innerStack) -> accessory.getExtraTooltip(innerStack, tooltips, tooltipContext, tooltipType));
    }

    @Deprecated(forRemoval=true)
    public static boolean checkIfChangesOccurred(class_1799 holderStack, @Nullable class_1309 livingEntity, AccessoryNestContainerContents data) {
        return AccessoryNestUtils.checkIfChangesOccurred(holderStack, livingEntity, data);
    }

    @Deprecated(forRemoval=true)
    public static <T> T attemptFunction(class_1799 holderStack, SlotReference slotReference, Function<Map<SlotEntryReference, Accessory>, T> func, T defaultValue) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return defaultValue;
        }
        T t = func.apply(data.getMap(slotReference));
        AccessoryNestUtils.checkIfChangesOccurred(holderStack, null, data);
        return t;
    }

    @Deprecated(forRemoval=true)
    public static <T> T attemptFunction(class_1799 holderStack, @Nullable class_1309 livingEntity, Function<Map<class_1799, Accessory>, T> func, T defaultValue) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return defaultValue;
        }
        T t = func.apply(data.getMap());
        AccessoryNestUtils.checkIfChangesOccurred(holderStack, livingEntity, data);
        return t;
    }

    @Deprecated(forRemoval=true)
    public static void attemptConsumer(class_1799 holderStack, SlotReference slotReference, Consumer<Map<SlotEntryReference, Accessory>> consumer) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return;
        }
        consumer.accept(data.getMap(slotReference));
        AccessoryNestUtils.checkIfChangesOccurred(holderStack, slotReference.entity(), data);
    }

    @Deprecated(forRemoval=true)
    public static void attemptConsumer(class_1799 holderStack, @Nullable class_1309 livingEntity, Consumer<Map<class_1799, Accessory>> consumer) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return;
        }
        consumer.accept(data.getMap());
        AccessoryNestUtils.checkIfChangesOccurred(holderStack, livingEntity, data);
    }

    @Deprecated(forRemoval=true)
    public static boolean isAccessoryNest(class_1799 holderStack) {
        return AccessoryNest.isNest(holderStack);
    }

    @Override
    @Deprecated(forRemoval=true)
    default public boolean canEquipFromUse(class_1799 stack) {
        return AccessoryNestUtils.handleEntries(stack, new AccessoryNestUtils.AccessoryFunction<class_9851>(this){

            @Override
            public class_9851 handle(Accessory accessory, class_1799 innerStack) {
                return accessory.canEquipFromUse(innerStack) ? class_9851.field_52396 : class_9851.field_52395;
            }

            @Override
            public boolean isDefaulted(class_9851 state) {
                return state != class_9851.field_52396;
            }
        }).method_61348(true);
    }
}

