/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.core;

import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNest;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.events.SlotStateChange;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.pond.stack.PatchedDataComponentMapExtension;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class AccessoryNestUtils {
    @Nullable
    public static AccessoryNestContainerContents getData(class_1799 stack) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        if (!(accessory instanceof AccessoryNest)) {
            return null;
        }
        return (AccessoryNestContainerContents)stack.method_58694(AccessoriesDataComponents.NESTED_ACCESSORIES);
    }

    public static boolean checkIfChangesOccurred(class_1799 holderStack, @Nullable class_1309 livingEntity, AccessoryNestContainerContents data) {
        boolean hasChangeOccurred = false;
        List<class_1799> accessories = data.accessories();
        boolean isNest = AccessoryNest.isNest(holderStack);
        for (int i = 0; i < accessories.size(); ++i) {
            AccessoryNestContainerContents innerData;
            PatchedDataComponentMapExtension extension;
            class_1799 stack = accessories.get(i);
            class_9323 class_93232 = stack.method_57353();
            if (class_93232 instanceof PatchedDataComponentMapExtension && (extension = (PatchedDataComponentMapExtension)class_93232).accessories$hasChanged()) {
                hasChangeOccurred = true;
            } else if (data.slotChanges().containsKey(i)) {
                hasChangeOccurred = true;
            } else if (isNest && (innerData = AccessoryNestUtils.getData(stack)) != null && (hasChangeOccurred = AccessoryNestUtils.checkIfChangesOccurred(stack, livingEntity, innerData))) break;
            if (!hasChangeOccurred) continue;
            data.slotChanges().putIfAbsent(i, SlotStateChange.MUTATION);
        }
        if (hasChangeOccurred && isNest) {
            AccessoryNest nest = (AccessoryNest)AccessoryRegistry.getAccessoryOrDefault(holderStack);
            holderStack.method_57379(AccessoriesDataComponents.NESTED_ACCESSORIES, (Object)data);
            nest.onStackChanges(holderStack, data, livingEntity);
        }
        return hasChangeOccurred;
    }

    @Nullable
    public static <T, S extends SlotPath> T recursivelyHandle(class_1799 stack, S reference, PathedStackFunction<S, T> function) {
        return AccessoryNestUtils.recursivelyHandle(stack, reference, function);
    }

    @Nullable
    public static <T, S extends SlotPath> T recursivelyHandle(class_1799 stack, S reference, PathedAccessoryFunction<S, T> function) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        Object value = function.handle(accessory, stack, reference);
        if (accessory instanceof AccessoryNest && value == null) {
            value = AccessoryNestUtils.handleEntries(stack, reference, (class_1799 innerStack, S innerRef) -> AccessoryNestUtils.recursivelyHandle(innerStack, innerRef, function));
        }
        return value;
    }

    @Nullable
    public static <T, S extends SlotPath> T handleEntries(class_1799 stack, S reference, PathedAccessoryFunction<S, T> function) {
        return (T)AccessoryNestUtils.handleEntries(stack, reference, (class_1799 innerStack, S innerRef) -> function.handle(AccessoryRegistry.getAccessoryOrDefault(innerStack), innerStack, innerRef));
    }

    @Nullable
    public static <T, S extends SlotPath> T handleEntries(class_1799 stack, S reference, PathedStackFunction<S, T> function) {
        Object value = null;
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(stack);
        if (data != null) {
            value = data.iterateStacks((i, innerStack) -> function.handle((class_1799)innerStack, (Object)SlotPath.cloneWithInnerIndex(reference, i)));
            if (reference instanceof SlotReference) {
                SlotReference ref = (SlotReference)reference;
                AccessoryNestUtils.checkIfChangesOccurred(stack, ref.entity(), data);
            }
        }
        return (T)value;
    }

    public static <S extends SlotPath> void recursivelyConsume(class_1799 stack, S reference, PathedStackConsumer<S> consumer) {
        AccessoryNestUtils.recursivelyConsume(stack, reference, consumer);
    }

    public static <S extends SlotPath> void recursivelyConsume(class_1799 stack, S reference, PathedAccessoryConsumer<S> consumer) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        consumer.handle(accessory, stack, reference);
        if (!(accessory instanceof AccessoryNest)) {
            return;
        }
        AccessoryNestUtils.consumeEntries(stack, reference, (class_1799 innerStack, S innerRef) -> AccessoryNestUtils.recursivelyConsume(innerStack, innerRef, consumer));
    }

    public static <S extends SlotPath> void consumeEntries(class_1799 stack, S reference, PathedAccessoryConsumer<S> consumer) {
        AccessoryNestUtils.consumeEntries(stack, reference, (class_1799 innerStack, S innerRef) -> consumer.handle(AccessoryRegistry.getAccessoryOrDefault(innerStack), innerStack, innerRef));
    }

    public static <S extends SlotPath> void consumeEntries(class_1799 stack, S reference, PathedStackConsumer<S> consumer) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(stack);
        if (data == null) {
            return;
        }
        data.iterateStacks((i, innerStack) -> consumer.handle((class_1799)innerStack, (Object)SlotPath.cloneWithInnerIndex(reference, i)));
        if (!(reference instanceof SlotReference)) {
            return;
        }
        SlotReference ref = (SlotReference)reference;
        AccessoryNestUtils.checkIfChangesOccurred(stack, ref.entity(), data);
    }

    @Nullable
    public static <T> T recursivelyHandle(class_1799 stack, StackFunction<T> function) {
        return (T)AccessoryNestUtils.recursivelyHandle(stack, (Accessory accessory, class_1799 innerStack) -> function.handle(innerStack));
    }

    @Nullable
    public static <T> T recursivelyHandle(class_1799 stack, AccessoryFunction<T> function) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        function.handle(accessory, stack);
        if (!(accessory instanceof AccessoryNest)) {
            return null;
        }
        return (T)AccessoryNestUtils.handleEntries(stack, (class_1799 innerStack) -> AccessoryNestUtils.recursivelyHandle(innerStack, function));
    }

    @Nullable
    public static <T> T handleEntries(class_1799 stack, AccessoryFunction<T> function) {
        return (T)AccessoryNestUtils.handleEntries(stack, (class_1799 innerStack) -> function.handle(AccessoryRegistry.getAccessoryOrDefault(innerStack), innerStack));
    }

    @Nullable
    public static <T> T handleEntries(class_1799 stack, StackFunction<T> function) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(stack);
        if (data == null) {
            return null;
        }
        T value = null;
        for (class_1799 innerStack : data.accessories()) {
            if (!innerStack.method_7960() && (value = (T)function.handle(innerStack)) != null) break;
        }
        return value;
    }

    public static void recursivelyConsume(class_1799 stack, StackConsumer consumer) {
        AccessoryNestUtils.recursivelyConsume(stack, (Accessory accessory, class_1799 innerStack) -> consumer.handle(innerStack));
    }

    public static void recursivelyConsume(class_1799 stack, AccessoryConsumer consumer) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        consumer.handle(accessory, stack);
        if (!(accessory instanceof AccessoryNest)) {
            return;
        }
        AccessoryNestUtils.consumeEntries(stack, (class_1799 innerStack) -> AccessoryNestUtils.recursivelyConsume(innerStack, consumer));
    }

    public static void consumeEntries(class_1799 stack, AccessoryConsumer consumer) {
        AccessoryNestUtils.consumeEntries(stack, (class_1799 innerStack) -> consumer.handle(AccessoryRegistry.getAccessoryOrDefault(innerStack), innerStack));
    }

    public static void consumeEntries(class_1799 stack, StackConsumer consumer) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(stack);
        if (data == null) {
            return;
        }
        data.accessories().forEach(innerStack -> {
            if (!innerStack.method_7960()) {
                consumer.handle((class_1799)innerStack);
            }
        });
    }

    public static interface PathedAccessoryFunction<S extends SlotPath, T>
    extends DefaultBehavior<T> {
        @Nullable
        public T handle(Accessory var1, class_1799 var2, S var3);
    }

    public static interface PathedStackFunction<S extends SlotPath, T>
    extends PathedAccessoryFunction<S, T> {
        @Override
        @Nullable
        default public T handle(Accessory accessory, class_1799 innerStack, S innerRef) {
            return this.handle(innerStack, innerRef);
        }

        @Nullable
        public T handle(class_1799 var1, S var2);
    }

    public static interface PathedAccessoryConsumer<S extends SlotPath> {
        public void handle(Accessory var1, class_1799 var2, S var3);
    }

    public static interface PathedStackConsumer<S extends SlotPath>
    extends PathedAccessoryConsumer<S> {
        @Override
        default public void handle(Accessory accessory, class_1799 innerStack, S innerRef) {
            this.handle(innerStack, innerRef);
        }

        public void handle(class_1799 var1, S var2);
    }

    public static interface StackFunction<T>
    extends AccessoryFunction<T> {
        @Override
        @Nullable
        default public T handle(Accessory accessory, class_1799 innerStack) {
            return this.handle(innerStack);
        }

        @Nullable
        public T handle(class_1799 var1);
    }

    public static interface AccessoryFunction<T>
    extends DefaultBehavior<T> {
        @Nullable
        public T handle(Accessory var1, class_1799 var2);
    }

    public static interface StackConsumer
    extends AccessoryConsumer {
        @Override
        default public void handle(Accessory accessory, class_1799 innerStack) {
            this.handle(innerStack);
        }

        public void handle(class_1799 var1);
    }

    public static interface AccessoryConsumer {
        public void handle(Accessory var1, class_1799 var2);
    }

    public static interface DefaultBehavior<T> {
        default public boolean isDefaulted(@Nullable T t) {
            return t == null;
        }
    }
}

