/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.core;

import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNest;
import io.wispforest.accessories.api.events.CanEquipCallback;
import io.wispforest.accessories.api.events.CanUnequipCallback;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class AccessoryRegistry {
    private static final Map<class_1792, Accessory> ACCESSORIES = new HashMap<class_1792, Accessory>();
    @ApiStatus.Internal
    private static final Accessory DEFAULT = new Accessory(){};
    @ApiStatus.Internal
    private static final AccessoryNest DEFAULT_NEST = new AccessoryNest(){};

    public static Map<class_1792, Accessory> getAllAccessories() {
        return Collections.unmodifiableMap(ACCESSORIES);
    }

    public static void register(class_1792 item, Accessory accessory) {
        ACCESSORIES.put(item, accessory);
    }

    public static Accessory getAccessoryOrDefault(class_1799 stack) {
        Accessory accessory = ACCESSORIES.get(stack.method_7909());
        if (accessory == null) {
            accessory = stack.method_57826(AccessoriesDataComponents.NESTED_ACCESSORIES) ? DEFAULT_NEST : DEFAULT;
        }
        return accessory;
    }

    public static Accessory getAccessoryOrDefault(class_1792 item) {
        return ACCESSORIES.getOrDefault(item, DEFAULT);
    }

    @Nullable
    public static Accessory getAccessory(class_1792 item) {
        return ACCESSORIES.get(item);
    }

    public static Accessory defaultAccessory() {
        return DEFAULT;
    }

    public static boolean isDefaultAccessory(class_1799 stack) {
        return AccessoryRegistry.isDefaultAccessory(AccessoryRegistry.getAccessoryOrDefault(stack));
    }

    public static boolean isDefaultAccessory(Accessory accessory) {
        return accessory == DEFAULT || accessory == DEFAULT_NEST;
    }

    public static boolean canEquip(class_1799 stack, SlotReference reference) {
        TriState result = ((CanEquipCallback)CanEquipCallback.EVENT.invoker()).canEquip(stack, reference);
        if (!result.equals((Object)TriState.DEFAULT)) {
            return result.orElse(true);
        }
        return AccessoryRegistry.getAccessoryOrDefault(stack).canEquip(stack, reference);
    }

    public static boolean canUnequip(class_1799 stack, SlotReference reference) {
        TriState result = ((CanUnequipCallback)CanUnequipCallback.EVENT.invoker()).canUnequip(stack, reference);
        if (!result.equals((Object)TriState.DEFAULT)) {
            return result.orElse(true);
        }
        return AccessoryRegistry.getAccessoryOrDefault(stack).canUnequip(stack, reference);
    }
}

