/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.slot;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.data.AccessoriesBaseData;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.slot.EntityBasedPredicate;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.AccessoryAttributeLogic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SlotPredicateRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<class_2960, SlotBasedPredicate> PREDICATES = new HashMap<class_2960, SlotBasedPredicate>();

    public static void register(class_2960 location, SlotBasedPredicate predicate) {
        if (PREDICATES.containsKey(location)) {
            LOGGER.warn("[AccessoriesAPI]: A SlotBasedPredicate attempted to be registered but a duplicate entry existed already! [Id: {}]", (Object)location);
            return;
        }
        PREDICATES.put(location, predicate);
    }

    @Nullable
    public static SlotBasedPredicate getPredicate(class_2960 location) {
        return PREDICATES.get(location);
    }

    public static boolean canInsertIntoSlot(class_1799 stack, SlotReference reference) {
        SlotType slotType = reference.type();
        if (slotType == null) {
            throw new IllegalStateException("Unable to get the needed SlotType from the SlotReference passed within `canInsertIntoSlot`! [Name: " + reference.slotName() + "]");
        }
        return SlotPredicateRegistry.getPredicateResults(slotType.validators(), reference.entity().method_73183(), reference.entity(), slotType, 0, stack) && AccessoryRegistry.canEquip(stack, reference);
    }

    public static Collection<SlotType> getValidSlotTypes(class_1309 entity, class_1799 stack) {
        Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots(entity);
        ArrayList<SlotType> validSlots = new ArrayList<SlotType>();
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            Map<String, AccessoriesContainer> containers = capability.getContainers();
            block0: for (SlotType value : slots.values()) {
                if (!containers.containsKey(value.name())) continue;
                AccessoriesContainer container = containers.get(value.name());
                int size = containers.get(value.name()).getSize();
                if (size == 0) {
                    size = 1;
                }
                for (int i = 0; i < size; ++i) {
                    SlotReference reference = SlotReference.of(entity, container.getSlotName(), i);
                    if (!SlotPredicateRegistry.canInsertIntoSlot(stack, reference)) continue;
                    validSlots.add(value);
                    continue block0;
                }
            }
        }
        return validSlots;
    }

    public static boolean isValidAccessory(class_1799 stack, class_1937 level) {
        return SlotPredicateRegistry.isValidAccessory(stack, level, null);
    }

    public static boolean isValidAccessory(class_1799 stack, class_1937 level, @Nullable class_1309 entity) {
        return !AccessoryRegistry.isDefaultAccessory(AccessoryRegistry.getAccessoryOrDefault(stack)) || !SlotPredicateRegistry.getStackSlotTypes(level, entity, stack).isEmpty();
    }

    public static Collection<SlotType> getStackSlotTypes(class_1937 level, class_1799 stack) {
        return SlotPredicateRegistry.getStackSlotTypes(level, null, stack);
    }

    public static Collection<SlotType> getStackSlotTypes(class_1309 entity, class_1799 stack) {
        return SlotPredicateRegistry.getStackSlotTypes(entity.method_73183(), entity, stack);
    }

    public static Collection<SlotType> getStackSlotTypes(class_1937 level, @Nullable class_1309 entity, class_1799 stack) {
        ArrayList<SlotType> validSlots = new ArrayList<SlotType>();
        for (SlotType value : SlotTypeLoader.INSTANCE.getEntries(level).values()) {
            if (!SlotPredicateRegistry.getPredicateResults(value.validators(), level, entity, value, 0, stack)) continue;
            validSlots.add(value);
        }
        return validSlots;
    }

    public static boolean getPredicateResults(Set<class_2960> predicateIds, class_1937 level, SlotType slotType, int index, class_1799 stack) {
        return SlotPredicateRegistry.getPredicateResults(predicateIds, level, null, slotType, index, stack);
    }

    public static boolean getPredicateResults(Set<class_2960> predicateIds, class_1937 level, @Nullable class_1309 entity, SlotType slotType, int index, class_1799 stack) {
        TriState result = TriState.DEFAULT;
        for (class_2960 predicateId : predicateIds) {
            SlotBasedPredicate predicate = SlotPredicateRegistry.getPredicate(predicateId);
            if (predicate == null) continue;
            if (predicate instanceof EntityBasedPredicate) {
                EntityBasedPredicate entityBasedPredicate = (EntityBasedPredicate)predicate;
                result = entityBasedPredicate.isValid(level, entity, slotType, index, stack);
            } else {
                result = predicate.isValid(level, slotType, index, stack);
            }
            if (result == TriState.DEFAULT) continue;
            break;
        }
        return result.orElse(false);
    }

    private static class_6862<class_1792> getSlotTag(SlotType slotType) {
        class_2960 location = UniqueSlotHandling.isUniqueSlot(slotType.name()) ? class_2960.method_60654((String)slotType.name()) : Accessories.of(slotType.name());
        return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)location);
    }

    static {
        SlotPredicateRegistry.register(AccessoriesBaseData.ALL_PREDICATE_ID, (level, slotType, i, stack) -> TriState.TRUE);
        SlotPredicateRegistry.register(AccessoriesBaseData.NONE_PREDICATE_ID, (level, slotType, i, stack) -> TriState.FALSE);
        SlotPredicateRegistry.register(AccessoriesBaseData.TAG_PREDICATE_ID, (level, slotType, i, stack) -> stack.method_31573(SlotPredicateRegistry.getSlotTag(slotType)) || stack.method_31573(AccessoriesTags.ANY_TAG) ? TriState.TRUE : TriState.DEFAULT);
        SlotPredicateRegistry.register(AccessoriesBaseData.ATTRIBUTE_PREDICATE_ID, SlotBasedPredicate.withEntity((level, entity, slotType, index, stack) -> {
            boolean bl = !AccessoryAttributeLogic.getAttributeModifiers(stack, entity, slotType.name(), index).getAttributeModifiers(false, true).isEmpty();
            return bl ? TriState.TRUE : TriState.DEFAULT;
        }));
        SlotPredicateRegistry.register(AccessoriesBaseData.COMPONENT_PREDICATE_ID, (level, slotType, index, stack) -> {
            if (stack.method_57826(AccessoriesDataComponents.SLOT_VALIDATION)) {
                AccessorySlotValidationComponent slotValidationData = (AccessorySlotValidationComponent)stack.method_58694(AccessoriesDataComponents.SLOT_VALIDATION);
                String name = slotType.name();
                Set<String> invalidSlots = slotValidationData.invalidSlotOverrides();
                for (String invalidSlot : invalidSlots) {
                    if (!name.equals(invalidSlot)) continue;
                    return TriState.FALSE;
                }
                Set<String> validSlots = slotValidationData.validSlotOverrides();
                for (String validSlot : validSlots) {
                    if (validSlot.equals("any")) {
                        return TriState.TRUE;
                    }
                    if (!name.equals(validSlot)) continue;
                    return TriState.TRUE;
                }
            }
            return TriState.DEFAULT;
        });
    }
}

