/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesClientInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.screen.AccessoriesScreenTransitionHelper;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.client.ClientLifecycleEvents;
import io.wispforest.accessories.client.DrawUtils;
import io.wispforest.accessories.client.EntityTarget;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.client.gui.components.AccessoriesScreenSettingsLayout;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.compat.config.MenuButtonInjection;
import io.wispforest.accessories.compat.config.client.ExtendedConfigScreen;
import io.wispforest.accessories.compat.config.client.Structured;
import io.wispforest.accessories.compat.config.client.components.StructListOptionContainer;
import io.wispforest.accessories.compat.config.client.components.StructOptionContainer;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.impl.option.PlayerOptionsAccess;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.mixin.owo.ConfigWrapperAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.holder.SyncOptionChange;
import io.wispforest.accessories.networking.server.ScreenOpen;
import io.wispforest.accessories.pond.TooltipFlagExtension;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.owo.config.ui.ConfigScreenProviders;
import io.wispforest.owo.config.ui.OptionComponentFactory;
import io.wispforest.owo.config.ui.OptionComponents;
import io.wispforest.owo.config.ui.component.OptionValueProvider;
import io.wispforest.owo.config.ui.component.SearchAnchorComponent;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.layers.Layers;
import io.wispforest.owo.util.NumberReflection;
import io.wispforest.owo.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1703;
import net.minecraft.class_1746;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public class AccessoriesClient {
    public static final class_304.class_11900 KEY_CATEGORY = class_304.class_11900.method_74698((class_2960)Accessories.of("main"));
    public static final class_304 OPEN_SCREEN = new class_304("accessories.key.open_accessories_screen", 72, KEY_CATEGORY);
    public static final Event<WindowResizeCallback> WINDOW_RESIZE_CALLBACK_EVENT = EventFactory.createArrayBacked(WindowResizeCallback.class, callbacks -> (client, window) -> {
        for (WindowResizeCallback callback : callbacks) {
            callback.onResized(client, window);
        }
    });
    public static boolean IS_PLAYER_INVISIBLE = false;
    private static final boolean IS_OSX = class_156.method_668() == class_156.class_158.field_1137;
    private static final int EDIT_SHORTCUT_KEY_MODIFIER = IS_OSX ? 8 : 2;
    private static boolean displayUnusedSlotWarning = false;

    public static void initConfigStuff() {
        ConfigScreenProviders.register((String)"accessories", ExtendedConfigScreen.buildFunc(Accessories.config(), (config, factoryRegister) -> {
            factoryRegister.registerTypedFactory(AccessoriesPlayerOptionsHolder.class, (model, option) -> {
                FlowLayout optionComponent = (FlowLayout)model.expandTemplate(FlowLayout.class, "boolean-toggle-config-option", OptionComponents.packParameters((String)option.translationKey(), (String)Objects.toString(option.value())));
                final MutableObject holderValue = new MutableObject((Object)AccessoriesPlayerOptionsHolder.createOrCopy((AccessoriesPlayerOptionsHolder)option.value()));
                ButtonComponent resetButton = ((ButtonComponent)optionComponent.childById(ButtonComponent.class, "reset-button")).onPress(button -> {
                    holderValue.setValue((Object)AccessoriesPlayerOptionsHolder.createOrCopy((AccessoriesPlayerOptionsHolder)option.defaultValue()));
                    button.field_22763 = false;
                });
                final Runnable checkResetButton = () -> {
                    resetButton.field_22763 = holderValue.getValue() != null && !((AccessoriesPlayerOptionsHolder)holderValue.getValue()).isDefaultedValues();
                };
                checkResetButton.run();
                FlowLayout btnLayout = (FlowLayout)optionComponent.childById(FlowLayout.class, "controls-flow");
                ButtonComponent tempBtn = (ButtonComponent)optionComponent.childById(ButtonComponent.class, "toggle-button");
                btnLayout.removeChild((Component)tempBtn);
                ButtonComponent toggleButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Edit"), btn -> {}).verticalSizing((Sizing)tempBtn.verticalSizing().get()).horizontalSizing((Sizing)tempBtn.horizontalSizing().get());
                btnLayout.child(0, (Component)toggleButton);
                toggleButton.onPress(btn -> {
                    final class_437 currentScreen = class_310.method_1551().field_1755;
                    BaseOwoScreen<FlowLayout> newScreen = new BaseOwoScreen<FlowLayout>(){

                        @NotNull
                        protected OwoUIAdapter<FlowLayout> createAdapter() {
                            return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
                        }

                        protected void build(FlowLayout rootComponent) {
                            rootComponent.child((Component)Containers.verticalFlow((Sizing)Sizing.fixed((int)178), (Sizing)Sizing.content()).child((Component)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)14)).child((Component)Containers.horizontalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content()).child((Component)Components.label((class_2561)class_2561.method_43470((String)"Default Screen Options"))).horizontalAlignment(HorizontalAlignment.LEFT)).child(Components.button((class_2561)class_2561.method_43470((String)"Back"), btn -> this.method_25419()).verticalSizing(Sizing.fixed((int)14))).verticalAlignment(VerticalAlignment.CENTER)).child((Component)Containers.verticalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.fixed((int)186)).child((Component)new AccessoriesScreenSettingsLayout((PlayerOptionsAccess)holderValue.getValue(), (x$0, x$1) -> this.component(x$0, x$1)).shouldNetworkSync(false).updateLive(true)).padding(Insets.of((int)1)).surface(ComponentUtils.getInsetPanelSurface())).gap(3).padding(Insets.of((int)7)).surface(ComponentUtils.getPanelSurface()));
                            rootComponent.surface(Surface.optionsBackground()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER);
                        }

                        public void method_25419() {
                            checkResetButton.run();
                            class_310.method_1551().method_1507(currentScreen);
                        }
                    };
                    class_310 client = class_310.method_1551();
                    client.field_1755 = newScreen;
                    client.field_1755.method_49589();
                    client.field_1729.method_1610();
                    class_304.method_1437();
                    newScreen.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
                    client.field_1743 = false;
                });
                optionComponent.child((Component)new SearchAnchorComponent((ParentComponent)optionComponent, option.key(), new Supplier[]{() -> ((LabelComponent)optionComponent.childById(LabelComponent.class, "option-name")).text().getString(), () -> toggleButton.method_25369().getString()}));
                return new OptionComponentFactory.Result((Component)optionComponent, new OptionValueProvider(){

                    public boolean isValid() {
                        return true;
                    }

                    public Object parsedValue() {
                        return holderValue.getValue();
                    }
                });
            });
            factoryRegister.registerFactory(option -> {
                Field field = option.backingField().field();
                if (field.getType() != List.class) {
                    return false;
                }
                Class listType = ReflectionUtils.getTypeArgument((Type)field.getGenericType(), (int)0);
                if (listType == null) {
                    return false;
                }
                return String.class != listType && !NumberReflection.isNumberType((Class)listType);
            }, (uiModel, option) -> {
                StructListOptionContainer layout = new StructListOptionContainer(uiModel, option);
                return new OptionComponentFactory.Result(layout, layout);
            });
            ReflectiveEndecBuilder builder = ((ConfigWrapperAccessor)config).accessories$builder();
            factoryRegister.registerFactory(option -> option.backingField().field().isAnnotationPresent(Structured.class), (model, option) -> {
                Structured annotationData = option.backingField().field().getAnnotation(Structured.class);
                class_5250 title = class_2561.method_43471((String)("text.config." + option.configName() + ".option." + option.key().asString()));
                FlowLayout titleLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                titleLayout.padding(Insets.of((int)5, (int)5, (int)5, (int)0));
                title = title.method_27661().method_27692(class_124.field_1073);
                titleLayout.child((Component)Components.label((class_2561)title));
                StructOptionContainer component = StructOptionContainer.of(model, option, builder, annotationData.sideBySide());
                titleLayout.child((Component)new SearchAnchorComponent((ParentComponent)titleLayout, option.key(), new Supplier[]{() -> class_1074.method_4662((String)("text.config." + option.configName() + ".option." + option.key().asString()), (Object[])new Object[0]), () -> component.parsedValue().toString()}));
                FlowLayout mainLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                mainLayout.child((Component)titleLayout).child((Component)component);
                return new OptionComponentFactory.Result((Component)mainLayout, (OptionValueProvider)component);
            });
        }));
        Accessories.config().clientOptions.subscribeToEquipControl(value -> AccessoriesClient.attemptAction(holder -> {
            if (holder.getDefaultedData(PlayerOptions.EQUIP_CONTROL) == value) {
                return;
            }
            AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.EQUIP_CONTROL, value));
        }));
        Accessories.config().screenOptions.subscribeToShowUnusedSlots(value -> AccessoriesClient.attemptAction(holder -> {
            if (holder.getDefaultedData(PlayerOptions.SHOW_UNUSED_SLOTS) == value) {
                return;
            }
            AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.SHOW_UNUSED_SLOTS, value));
        }));
        Accessories.config().screenOptions.subscribeToAlwaysShowCraftingGrid(value -> AccessoriesClient.attemptAction(holder -> {
            if (holder.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID) == value) {
                return;
            }
            AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.SHOW_CRAFTING_GRID, value));
        }));
    }

    public static void init() {
        AccessoriesClientInternals.setInstance(new AccessoriesClientInternals(){

            @Override
            public class_1836 createTooltipFlag(class_1836 flag) {
                class_310 client = class_310.method_1551();
                int modifiers = (client.method_74187() ? 1 : 0) | (client.method_74188() ? EDIT_SHORTCUT_KEY_MODIFIER : 0) | (client.method_74189() ? 4 : 0);
                return TooltipFlagExtension.createFlag(flag, modifiers);
            }
        });
        ClientLifecycleEvents.END_DATA_PACK_RELOAD.register((client, success) -> {
            if (!success) {
                return;
            }
            class_7923.field_41178.forEach(item -> {
                class_1799 defaultStack = item.method_7854();
                if ((item instanceof class_1746 || defaultStack.method_57826(class_9334.field_54197)) && !AccessoriesRendererRegistry.hasRenderer(item)) {
                    AccessoriesRendererRegistry.bindItemToEmptyRenderer(item);
                }
            });
            AccessoriesRendererRegistry.onReload();
        });
        AccessoriesClient.initLayer();
    }

    public static void openScreenFromKey() {
        class_310 minecraft = class_310.method_1551();
        class_437 currentScreen = minecraft.field_1755;
        if (currentScreen instanceof AccessoriesScreenBase) {
            minecraft.method_1507(null);
        } else if (currentScreen == null) {
            AccessoriesClient.attemptToOpenScreen(minecraft.field_1724.method_5715() ? EntityTarget.LOOKING_ENTITY : EntityTarget.PLAYER);
        } else {
            class_746 targetEntity = null;
            if (currentScreen instanceof class_465) {
                class_465 containerScreen = (class_465)currentScreen;
                targetEntity = AccessoriesScreenTransitionHelper.getTargetEntity((class_465<class_1703>)containerScreen);
            }
            if (targetEntity == null) {
                targetEntity = minecraft.field_1724;
            }
            AccessoriesClient.attemptToOpenScreenFromEntity(targetEntity);
        }
    }

    private static void attemptAction(Consumer<AccessoriesPlayerOptionsHolder> consumer) {
        class_746 currentPlayer = class_310.method_1551().field_1724;
        if (currentPlayer == null || class_310.method_1551().field_1687 == null) {
            return;
        }
        AccessoriesPlayerOptionsHolder options = AccessoriesPlayerOptionsHolder.getOptions((class_1657)currentPlayer);
        if (options != null) {
            consumer.accept(options);
        }
    }

    public static void initalConfigDataSync() {
        class_746 currentPlayer = class_310.method_1551().field_1724;
        if (currentPlayer == null || class_310.method_1551().field_1687 == null) {
            return;
        }
        AccessoriesPlayerOptionsHolder options = AccessoriesPlayerOptionsHolder.getOptions((class_1657)currentPlayer);
        if (options == null) {
            return;
        }
        PlayerEquipControl equipControl = Accessories.config().clientOptions.equipControl();
        if (options.getDefaultedData(PlayerOptions.EQUIP_CONTROL) != equipControl) {
            AccessoriesNetworking.sendToServer(PlayerOptions.EQUIP_CONTROL.toPacket(equipControl));
        }
        boolean showUnusedSlots = Accessories.config().screenOptions.showUnusedSlots();
        if (options.getDefaultedData(PlayerOptions.SHOW_UNUSED_SLOTS) != showUnusedSlots) {
            AccessoriesNetworking.sendToServer(PlayerOptions.SHOW_UNUSED_SLOTS.toPacket(showUnusedSlots));
        }
        boolean alwaysShowCraftingGrid = Accessories.config().screenOptions.alwaysShowCraftingGrid();
        if (options.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID) != alwaysShowCraftingGrid) {
            AccessoriesNetworking.sendToServer(PlayerOptions.SHOW_CRAFTING_GRID.toPacket(true));
        }
    }

    public static boolean attemptToOpenScreen(EntityTarget entityTarget) {
        class_1309 targetEntity;
        class_746 player = class_310.method_1551().field_1724;
        class_1309 class_13092 = targetEntity = Accessories.config().screenOptions.keybindIgnoresOtherTargets() ? null : AccessoriesScreenTransitionHelper.getTargetEntity(player);
        if (targetEntity == null) {
            class_3966 entitResult;
            class_1297 class_12972;
            class_239 result;
            if (entityTarget.equals((Object)EntityTarget.PLAYER)) {
                return AccessoriesClient.attemptToOpenScreenFromEntity((class_1309)player);
            }
            if (entityTarget.equals((Object)EntityTarget.LOOKING_ENTITY) && (result = class_1675.method_49998((class_1297)player, e -> e instanceof class_1309, (double)player.method_55755())) instanceof class_3966 && (class_12972 = (entitResult = (class_3966)result).method_17782()) instanceof class_1309) {
                class_1309 living;
                targetEntity = living = (class_1309)class_12972;
            }
        }
        if (targetEntity != null && !EntitySlotLoader.getEntitySlots(targetEntity).isEmpty()) {
            return AccessoriesClient.attemptToOpenScreenFromEntity(targetEntity);
        }
        return false;
    }

    public static boolean attemptToOpenScreenFromEntity(class_1309 targetingEntity) {
        class_1799 class_17992;
        class_746 player = class_310.method_1551().field_1724;
        if (targetingEntity.equals((Object)player)) {
            Collection<SlotType> slots = AccessoriesCapability.getUsedSlotsFor((class_1657)player);
            AccessoriesPlayerOptionsHolder options = AccessoriesPlayerOptionsHolder.getOptions((class_1657)player);
            if (slots.isEmpty() && !options.getDefaultedData(PlayerOptions.SHOW_UNUSED_SLOTS).booleanValue() && !displayUnusedSlotWarning && !Accessories.config().clientOptions.disableEmptySlotScreenError()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"[Accessories]: No Used Slots found by any mod directly, the screen will show empty unless a item is found to implement slots!"), false);
                displayUnusedSlotWarning = true;
            }
        }
        AccessoriesMenuVariant selectedVariant = AccessoriesMenuVariant.PRIMARY_V2;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof class_481) {
            class_481 screen = (class_481)class_4372;
            class_17992 = ((class_481.class_483)screen.method_17577()).method_34255();
        } else {
            class_17992 = null;
        }
        class_1799 creativeCarriedStack = class_17992;
        AccessoriesNetworking.sendToServer(ScreenOpen.of(targetingEntity, selectedVariant, creativeCarriedStack));
        return true;
    }

    public static void attemptToOpenSelectionScreen(int entityId, boolean targetLookEntity, class_1657 player) {
        class_1799 class_17992;
        AccessoriesMenuVariant selectedVariant = AccessoriesMenuVariant.PRIMARY_V2;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof class_481) {
            class_481 screen = (class_481)class_4372;
            class_17992 = ((class_481.class_483)screen.method_17577()).method_34255();
        } else {
            class_17992 = null;
        }
        class_1799 creativeCarriedStack = class_17992;
        Function<AccessoriesMenuVariant, ScreenOpen> packetBuilder = menuVariant -> new ScreenOpen(targetLookEntity ? -1 : entityId, targetLookEntity, (AccessoriesMenuVariant)((Object)menuVariant), creativeCarriedStack);
        AccessoriesNetworking.sendToServer(packetBuilder.apply(selectedVariant));
    }

    public static void initLayer() {
        AccessoriesScreenTransitionHelper.init();
        Layers.add(Containers::verticalFlow, instance -> {
            instance.aggressivePositioning = true;
            ((FlowLayout)instance.adapter.rootComponent).allowOverflow(true);
            MenuButtonInjection injectionData = AccessoriesScreenTransitionHelper.getInjection((class_465<class_1703>)((class_465)instance.screen));
            if (injectionData == null) {
                return;
            }
            ButtonComponent button = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)""), btn -> {
                class_1309 target = AccessoriesScreenTransitionHelper.getTargetEntity((class_465<class_1703>)((class_465)instance.screen));
                if (target == null) {
                    target = class_310.method_1551().field_1724;
                }
                AccessoriesClient.attemptToOpenScreenFromEntity(target);
            }).renderer((context, btn, delta) -> DrawUtils.blit((class_332)context, Accessories.of("textures/gui/accessories_open_icon" + (btn.method_49606() ? "_hovered" : "") + ".png"), btn.x(), btn.y(), 0.0f, 0.0f, 8, 8, 8, 8)).tooltip((class_2561)class_2561.method_43471((String)Accessories.translationKey("open.screen"))).margins(Insets.of((int)1, (int)0, (int)0, (int)1)).sizing(Sizing.fixed((int)8));
            if (instance.screen instanceof class_481) {
                ComponentUtils.CreativeScreenExtension extension = (ComponentUtils.CreativeScreenExtension)instance.screen;
                button.field_22764 = extension.getTab().method_47312().equals((Object)class_1761.class_7916.field_41053);
                extension.getEvent().register(tab -> {
                    button.field_22764 = tab.method_47312().equals((Object)class_1761.class_7916.field_41053);
                });
            }
            ((FlowLayout)instance.adapter.rootComponent).child((Component)button);
            instance.alignComponentToHandledScreenCoordinates((Component)button, injectionData.xOffset(), injectionData.yOffset());
        }, (Class[])AccessoriesScreenTransitionHelper.getScreenClasses());
    }

    public static interface WindowResizeCallback {
        public void onResized(class_310 var1, class_1041 var2);
    }
}

