/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import net.minecraft.class_310;

public class ClientDelayedCache<K> {
    private final Cache<K, Float> cache;

    public ClientDelayedCache() {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(30L)).build();
    }

    public ClientDelayedCache(int maxAmount) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(30L)).maximumSize((long)maxAmount).build();
    }

    public boolean hasAllottedTime(K key, float totalAmountSecs) {
        boolean bl;
        Float prevAmount = (Float)this.cache.getIfPresent(key);
        if (prevAmount == null) {
            prevAmount = Float.valueOf(0.0f);
            this.cache.put(key, (Object)prevAmount);
            return true;
        }
        float currentAmount = prevAmount.floatValue() + class_310.method_1551().method_61966().method_60636();
        boolean bl2 = bl = currentAmount >= totalAmountSecs * 20.0f;
        if (bl) {
            currentAmount = 0.0f;
        }
        this.cache.put(key, (Object)Float.valueOf(currentAmount));
        return bl;
    }

    public void runIfTimeHasAllotted(K key, float totalAmountSecs, Runnable runnable) {
        if (!this.hasAllottedTime(key, totalAmountSecs)) {
            return;
        }
        runnable.run();
    }
}

