/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.client.screen.AccessoriesScreenTransitionHelper;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.client.AccessoriesClient;
import io.wispforest.accessories.client.AccessoriesFunkyRenderingState;
import io.wispforest.accessories.client.DrawUtils;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.client.gui.components.AccessoriesContainingLayout;
import io.wispforest.accessories.client.gui.components.AccessoriesScreenSettingsLayout;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.client.gui.components.ExtendedScrollContainer;
import io.wispforest.accessories.client.gui.components.InventoryEntityComponent;
import io.wispforest.accessories.client.gui.components.PaginatedAccessoriesLayout;
import io.wispforest.accessories.client.gui.components.ScrollableAccessoriesLayout;
import io.wispforest.accessories.client.gui.utils.Line3d;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.impl.option.PlayerOption;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.impl.option.PlayerOptionsAccess;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.menu.SlotTypeAccessible;
import io.wispforest.accessories.menu.networking.ToggledSlots;
import io.wispforest.accessories.menu.variants.AccessoriesMenu;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.holder.SyncOptionChange;
import io.wispforest.accessories.pond.ContainerScreenExtension;
import io.wispforest.owo.mixin.ui.SlotAccessor;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.util.pond.OwoSlotExtension;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_421;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_9692;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.slf4j.Logger;

public class AccessoriesScreen
extends BaseOwoHandledScreen<FlowLayout, AccessoriesMenu>
implements AccessoriesScreenBase<AccessoriesMenu>,
ContainerScreenExtension,
PlayerOptionsAccess {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private final class_465<class_1703> prevScreen;
    private boolean rebuildComponentRectangles = true;
    private List<PositionedRectangle> componentRectangles = List.of();
    private final Map<Integer, Boolean> changedSlots = new HashMap<Integer, Boolean>();
    private final List<Vector3d> hoveredAccessoryPositons = new ArrayList<Vector3d>();
    private final List<Line3d> linesToAccessoryPositions = new ArrayList<Line3d>();
    @Nullable
    private AccessoriesContainingLayout<?> topComponent = null;
    @Nullable
    private ExtendedScrollContainer groupFilterScrollable = null;
    @Nullable
    private AccessoriesScreenSettingsLayout settingsLayout = null;

    public AccessoriesScreen(AccessoriesMenu handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        class_465 prevScreen;
        class_437 class_4372 = class_310.method_1551().field_1755;
        this.prevScreen = class_4372 instanceof class_465 ? (prevScreen = (class_465)class_4372) : null;
        this.field_25269 = 42069;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected FlowLayout rootComponent() {
        return (FlowLayout)this.uiAdapter.rootComponent;
    }

    public List<PositionedRectangle> getComponentRectangles() {
        if (this.rebuildComponentRectangles) {
            ArrayDeque unpackRules = new ArrayDeque();
            unpackRules.push(List.of());
            unpackRules.push(List.of(Pair.of((Object)false, (Object)"armor_entity_layout"), Pair.of((Object)true, (Object)"bottom_inventory_section")));
            unpackRules.push(List.of(Pair.of((Object)false, (Object)"outer_accessories_layout")));
            Stream<Object> stream = this.rootComponent().children().stream();
            while (!unpackRules.isEmpty()) {
                List ids = (List)unpackRules.pollLast();
                stream = stream.flatMap(component -> {
                    if (component instanceof ParentComponent) {
                        ParentComponent parent = (ParentComponent)component;
                        if (ids.isEmpty()) {
                            return parent.children().stream();
                        }
                        if (parent.id() != null) {
                            for (Pair pair : ids) {
                                if (!((String)pair.right()).equals(parent.id())) continue;
                                Stream<Object> componentStream = parent.children().stream();
                                if (((Boolean)pair.left()).booleanValue()) {
                                    componentStream = Stream.concat(componentStream, Stream.of(parent));
                                }
                                return componentStream;
                            }
                        }
                    }
                    return Stream.of(component);
                });
            }
            this.componentRectangles = stream.map(component -> component).toList();
            this.rebuildComponentRectangles = false;
        }
        return this.componentRectangles;
    }

    public <C extends Component> C component(Class<C> expectedClass, String id) {
        return (C)super.component(expectedClass, id);
    }

    protected void method_37432() {
        super.method_37432();
        if (this.changedSlots.isEmpty()) {
            return;
        }
        class_2371 slots = ((AccessoriesMenu)this.method_17577()).field_7761;
        Map<Integer, Boolean> changes = this.changedSlots.entrySet().stream().filter(entry -> (Integer)entry.getKey() < slots.size()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ((AccessoriesMenu)this.method_17577()).sendMessage(new ToggledSlots(changes));
        this.changedSlots.clear();
    }

    public void hideSlot(int index) {
        this.hideSlot((class_1735)((AccessoriesMenu)this.field_2797).field_7761.get(index));
    }

    public void hideSlot(class_1735 slot) {
        ((SlotAccessor)slot).owo$setX(-300);
        ((SlotAccessor)slot).owo$setY(-300);
    }

    public void disableSlot(class_1735 slot) {
        super.disableSlot(slot);
        int index = slot.field_7874;
        if (this.changedSlots.getOrDefault(index, false).booleanValue()) {
            return;
        }
        this.hideSlot(index);
        this.changedSlots.put(index, true);
    }

    public void enableSlot(class_1735 slot) {
        super.enableSlot(slot);
        int index = slot.field_7874;
        if (!this.changedSlots.getOrDefault(index, true).booleanValue()) {
            return;
        }
        this.changedSlots.put(index, false);
    }

    @Override
    @Nullable
    public SlotTypeAccessible getSelectedSlot() {
        SlotTypeAccessible slot;
        class_1735 class_17352 = this.field_2787;
        return class_17352 instanceof SlotTypeAccessible ? (slot = (SlotTypeAccessible)class_17352) : null;
    }

    @Override
    @Nullable
    public Boolean isHovering_Logical(class_1735 slot, double mouseX, double mouseY) {
        AccessoriesContainingLayout<?> accessories = this.topComponent;
        return accessories != null ? accessories.isHovering_Logical(slot, mouseX, mouseY) : null;
    }

    public void method_25419() {
        Set selectedGroups = ((AccessoriesMenu)this.method_17577()).selectedGroups().stream().map(SlotGroup::name).collect(Collectors.toSet());
        AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.FILTERED_GROUPS, selectedGroups));
        super.method_25419();
    }

    protected void method_25426() {
        if (!((AccessoriesMenu)this.field_2797).isValidMenu()) {
            class_310.method_1551().method_1507((class_437)new class_421((class_2561)class_2561.method_43470((String)"Accessories Screen Opening Error!"), (class_2561)class_2561.method_43470((String)"Unable to open Accessories Screen due to desync with the Server!")));
            return;
        }
        super.method_25426();
    }

    public boolean method_25422() {
        if (((Boolean)this.getDefaultedData(PlayerOptions.ADVANCED_SETTINGS)).booleanValue()) {
            this.toggleAdvancedOptions(this.component(ButtonComponent.class, "advanced_options_btn"));
            return false;
        }
        return super.method_25422();
    }

    public boolean method_25404(class_11908 input) {
        if (AccessoriesClient.OPEN_SCREEN.method_1417(input)) {
            this.method_25419();
            return true;
        }
        if (input.comp_4795() == 256 && ((Boolean)this.getDefaultedData(PlayerOptions.ADVANCED_SETTINGS)).booleanValue()) {
            this.toggleAdvancedOptions(this.component(ButtonComponent.class, "advanced_options_btn"));
            return false;
        }
        return super.method_25404(input);
    }

    protected boolean method_2381(double mouseX, double mouseY, int guiLeft, int guiTop) {
        for (PositionedRectangle rect : this.getComponentRectangles()) {
            if (!rect.isInBoundingBox(mouseX, mouseY)) continue;
            return false;
        }
        return true;
    }

    protected void method_2380(class_332 guiGraphics, int x, int y) {
        if (this.field_2787 != null) {
            class_1735 class_17352 = this.field_2787;
            if (class_17352 instanceof AccessoriesBasedSlot) {
                AccessoriesBasedSlot accessoriesInternalSlot = (AccessoriesBasedSlot)class_17352;
                if (!ArmorSlotTypes.isArmorType(accessoriesInternalSlot.slotName())) {
                    AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION));
                }
            } else if (this.field_2787 instanceof class_9692) {
                AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(true);
            } else if ((this.field_2787.field_7871 instanceof class_1715 || this.field_2787 instanceof class_1734) && !((Boolean)this.getDefaultedData(PlayerOptions.SHOW_GROUP_FILTER)).booleanValue()) {
                AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) == false);
            }
        }
        super.method_2380(guiGraphics, x, y);
        AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(false);
    }

    protected List<class_2561> method_51454(class_1799 itemStack) {
        class_1799 hoveredStack;
        AccessoriesBasedSlot slot;
        class_1735 class_17352;
        List tooltipData = AccessoriesScreen.method_25408((class_310)this.field_22787, (class_1799)itemStack);
        if (Accessories.config().screenOptions.showEquippedStackSlotType() && ((AccessoriesMenu)this.field_2797).method_34255().method_7960() && this.field_2787 != null && this.field_2787.method_7681() && (class_17352 = this.field_2787) instanceof AccessoriesBasedSlot && ExtraSlotTypeProperties.getProperty((slot = (AccessoriesBasedSlot)class_17352).slotName(), true).allowTooltipInfo() && itemStack == (hoveredStack = this.field_2787.method_7677())) {
            tooltipData.add(class_2561.method_43473());
            tooltipData.add(class_2561.method_43471((String)Accessories.translationKey("tooltip.currently_equipped_in")).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)slot.slotType().translation()).method_27692(class_124.field_1078)));
        }
        return tooltipData;
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        SlotPath positionKey;
        Map<SlotPath, Vector3d> positions;
        AccessoriesBasedSlot slot;
        class_1735 class_17352;
        super.method_2389(guiGraphics, partialTick, mouseX, mouseY);
        if (this.field_2787 != null && (class_17352 = this.field_2787) instanceof AccessoriesBasedSlot && (slot = (AccessoriesBasedSlot)class_17352).method_7682() && !slot.method_7677().method_7960() && (positions = AccessoriesFunkyRenderingState.INSTANCE.getNotVeryNicePositions()).containsKey(positionKey = slot.slotPath())) {
            this.hoveredAccessoryPositons.add(positions.get(positionKey));
            Vector3d vec = positions.get(positionKey);
            if (!slot.isCosmetic && vec != null && Accessories.config().screenOptions.hoveredOptions.line()) {
                Vector3d start = new Vector3d((double)(slot.field_7873 + this.field_2776 + 17), (double)(slot.field_7872 + this.field_2800 + 9), 5000.0);
                Vector3d vec3 = vec.add(0.0, 0.0, 5000.0);
                this.linesToAccessoryPositions.add(new Line3d(start, vec3));
            }
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_2389(guiGraphics, partialTick, mouseX, mouseY);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (Accessories.config().screenOptions.hoveredOptions.clickbait()) {
            this.hoveredAccessoryPositons.forEach(pos -> DrawUtils.blitSprite(guiGraphics, Accessories.of("highlight/clickbait"), (int)pos.x - 128, (int)pos.y - 128, 450, 256, 256));
            this.hoveredAccessoryPositons.clear();
        }
        if (!this.linesToAccessoryPositions.isEmpty() || Accessories.config().screenOptions.hoveredOptions.line()) {
            this.field_22787.method_22940().method_23000().method_22994((class_1921)class_1921.field_21695);
            this.linesToAccessoryPositions.clear();
        }
    }

    public void showCosmeticState(boolean value) {
        this.setData(PlayerOptions.SHOW_COSMETIC_SLOTS, value);
        AccessoriesNetworking.sendToServer(PlayerOptions.SHOW_COSMETIC_SLOTS.toPacket(value));
    }

    public boolean showCosmeticState() {
        return (Boolean)this.getDefaultedData(PlayerOptions.SHOW_COSMETIC_SLOTS);
    }

    protected void build(FlowLayout rootComponent) {
        Component sideBarHolder;
        this.changedSlots.clear();
        ((AccessoriesMenu)this.method_17577()).field_7761.forEach(this::disableSlot);
        rootComponent.allowOverflow(true).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER).surface(Surface.VANILLA_TRANSLUCENT);
        ArrayList<Object> baseChildren = new ArrayList<Object>();
        AccessoriesContainingLayout<?> accessoriesComponent = this.createAccessoriesComponent();
        AccessoriesMenu menu = (AccessoriesMenu)this.method_17577();
        SlotGroupLoader.getValidGroups(((AccessoriesMenu)this.method_17577()).targetEntityDefaulted()).keySet().stream().filter(group -> ((Set)this.getDefaultedData(PlayerOptions.FILTERED_GROUPS)).contains(group.name())).forEach(menu::addSelectedGroup);
        Component playerInv = ComponentUtils.createPlayerInv(5, menu.startingAccessoriesSlot(), this::slotAsComponent, x$0 -> this.enableSlot((int)x$0));
        this.setData(PlayerOptions.ADVANCED_SETTINGS, false);
        int offHandIndex = ((AccessoriesMenu)this.method_17577()).startingAccessoriesSlot() - 1;
        this.enableSlot(offHandIndex);
        final ParentComponent offhandComponent = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)this.slotAsComponent(offHandIndex).margins(Insets.of((int)1))).padding(Insets.of((int)7, (int)7, (int)7, (int)4)).allowOverflow(true);
        Component bottomInvComponent = new FlowLayout(this, Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL){

            public boolean isInBoundingBox(double x, double y) {
                return super.isInBoundingBox(x, y) || offhandComponent.isInBoundingBox(x, y);
            }
        }.child(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)offhandComponent).allowOverflow(true).positioning(Positioning.absolute((int)-29, (int)51))).child(Containers.verticalFlow((Sizing)Sizing.fixed((int)162), (Sizing)Sizing.fixed((int)76)).child(playerInv).id("bottom_component_holder")).child(((FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).positioning(Positioning.absolute((int)162, (int)-7)).configure(component -> {
            if (((Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID)).booleanValue()) {
                component.child(this.createCraftingGrid());
            }
        })).id("crafting_grid_layout")).padding(Insets.of((int)7)).surface((ctx, component) -> {
            Boolean showCraftingGrid = (Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID);
            int width = showCraftingGrid != false ? 238 : 198;
            DrawUtils.blit((class_332)ctx, Accessories.of("textures/gui/theme/" + ComponentUtils.checkMode("light", "dark") + "/player_inv/" + (showCraftingGrid != false ? "with" : "without") + "_crafting.png"), component.x() - 22, component.y(), width, 90);
        }).allowOverflow(true).id("bottom_inventory_section");
        baseChildren.add(bottomInvComponent);
        FlowLayout primaryLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)140)).gap(2).horizontalAlignment(HorizontalAlignment.CENTER).id("armor_entity_layout");
        FlowLayout armorSlotsLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(layout -> layout.allowOverflow(true));
        FlowLayout outerLeftArmorLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)armorSlotsLayout);
        FlowLayout cosmeticArmorSlotsLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(layout -> layout.allowOverflow(true));
        FlowLayout outerRightArmorLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)cosmeticArmorSlotsLayout);
        for (int i = 0; i < menu.addedArmorSlots() / 2; ++i) {
            int armor = menu.startingAccessoriesSlot() + i * 2;
            int cosmeticArmor = armor + 1;
            this.enableSlot(armor);
            this.enableSlot(cosmeticArmor);
            armorSlotsLayout.child((Component)this.slotAsComponent(armor).margins(Insets.of((int)1)));
            cosmeticArmorSlotsLayout.child((Component)ComponentUtils.createSlotWithToggle((AccessoriesBasedSlot)((AccessoriesMenu)this.field_2797).field_7761.get(cosmeticArmor), this::slotAsComponent).left());
        }
        StackLayout entityContainer = Containers.stack((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)140)).child(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(this.createEntityComponent()).surface((ctx, component) -> {
            Boolean sideBySideMode;
            DrawUtils.blit((class_332)ctx, Accessories.of("textures/gui/theme/" + ComponentUtils.checkMode("light", "dark") + "/entity_view/" + ((sideBySideMode = (Boolean)this.getDefaultedData(PlayerOptions.SIDE_BY_SIDE_ENTITY)) != false ? "double" : "single") + "/entity_background.png"), component.x(), component.y(), sideBySideMode != false ? 162 : 108, 126);
        }).id("entity_renderer_holder")).child((Component)Containers.verticalFlow((Sizing)Sizing.fixed((int)0), (Sizing)Sizing.fixed((int)0)).surface((ctx, component) -> {
            Boolean sideBySideMode;
            String surfaceType = Math.max(1, Math.min(((AccessoriesMenu)this.method_17577()).addedArmorSlots() / 2, 4)) + "_slots";
            DrawUtils.blit((class_332)ctx, Accessories.of("textures/gui/theme/" + ComponentUtils.checkMode("light", "dark") + "/entity_view/" + ((sideBySideMode = (Boolean)this.getDefaultedData(PlayerOptions.SIDE_BY_SIDE_ENTITY)) != false ? "double" : "single") + "/" + surfaceType + ".png"), component.x() - 7, component.y() - 7, sideBySideMode != false ? 176 : 122, 140);
        })).child(((FlowLayout)outerLeftArmorLayout.configure(component -> component.mouseScroll().subscribe((mouseX, mouseY, amount) -> true))).padding(Insets.of((int)7)).margins(Insets.left((int)-7)).positioning(Positioning.relative((int)0, (int)40))).child(((FlowLayout)outerRightArmorLayout.configure(component -> component.mouseScroll().subscribe((mouseX, mouseY, amount) -> true))).surface(ComponentUtils.SPECTRUM_SLOT_OUTLINE).padding(Insets.of((int)7)).margins(Insets.right((int)-7)).positioning(Positioning.relative((int)100, (int)40))).child(ComponentUtils.createIconButton(btn -> {
            this.showCosmeticState(!this.showCosmeticState());
            btn.tooltip(AccessoriesScreen.createToggleText("slot_cosmetics", false, this.showCosmeticState()));
            AccessoriesContainingLayout component = (AccessoriesContainingLayout)this.rootComponent().childById(AccessoriesContainingLayout.class, AccessoriesContainingLayout.defaultID());
            if (component != null) {
                component.onCosmeticToggle(this.showCosmeticState());
            }
        }, 14, btn -> btn.tooltip(AccessoriesScreen.createToggleText("slot_cosmetics", false, this.showCosmeticState())).margins(Insets.of((int)2, (int)0, (int)3, (int)0)), btn -> Accessories.of("textures/gui/" + (this.showCosmeticState() ? "charm" : "cosmetic") + "_toggle_icon" + (btn.method_49606() ? "_hovered" : "") + ".png")).positioning(Positioning.relative((int)0, (int)0))).child(ComponentUtils.createIconButton(btn -> AccessoriesScreenTransitionHelper.openPrevScreen((class_1657)class_310.method_1551().field_1724, ((AccessoriesMenu)this.field_2797).targetEntityDefaulted(), this.prevScreen), 10, btn -> btn.tooltip((class_2561)class_2561.method_43471((String)Accessories.translationKey("back.screen"))).margins(Insets.of((int)3, (int)0, (int)0, (int)3)), btn -> Accessories.of("textures/gui/accessories_back_icon" + (btn.method_49606() ? "_hovered" : "") + ".png")).positioning(Positioning.relative((int)100, (int)0))).child(ComponentUtils.createIconButton(btn -> this.toggleAdvancedOptions((ButtonComponent)btn), 14, "advanced_options_btn", btn -> btn.tooltip(AccessoriesScreen.createToggleText("advanced_options", true, (Boolean)this.getDefaultedData(PlayerOptions.ADVANCED_SETTINGS))).margins(Insets.of((int)0, (int)3, (int)0, (int)3)), (ctx, btn) -> Accessories.of("textures/gui/settings_icon" + (btn.method_49606() ? "_hovered" : "") + ".png")).positioning(Positioning.relative((int)100, (int)100)));
        if (!Accessories.config().screenOptions.alwaysShowCraftingGrid()) {
            entityContainer.child(this.createCraftingToggleButton());
        }
        primaryLayout.child(entityContainer.allowOverflow(true).padding(Insets.of((int)7)).id("entity_button_panel"));
        baseChildren.add(primaryLayout);
        if (accessoriesComponent != null) {
            primaryLayout.child((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) != false ? 0 : 1, accessoriesComponent);
        }
        boolean hasSideBar = false;
        if (!(accessoriesComponent == null && ((AccessoriesMenu)this.method_17577()).selectedGroups().isEmpty() || (sideBarHolder = this.createSideBarOptions()) == null)) {
            if (((Boolean)this.getDefaultedData(PlayerOptions.SIDE_WIDGET_POSITION)).booleanValue() == ((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION)).booleanValue()) {
                primaryLayout.child(0, sideBarHolder);
            } else {
                primaryLayout.child(sideBarHolder);
            }
            hasSideBar = true;
        }
        this.setupPadding(accessoriesComponent, hasSideBar, (ParentComponent)primaryLayout);
        ParentComponent baseLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(2).children((Collection)baseChildren.reversed()).allowOverflow(true);
        baseLayout.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER).positioning(Positioning.relative((int)50, (int)50));
        rootComponent.child((Component)baseLayout);
    }

    public void setupPadding() {
        if (this.topComponent == null) {
            return;
        }
        boolean hasSideBar = this.rootComponent().childById(Component.class, "side_bar_holder") != null;
        FlowLayout primaryLayout = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "armor_entity_layout");
        this.setupPadding(this.topComponent, hasSideBar, (ParentComponent)primaryLayout);
    }

    public void setupPadding(AccessoriesContainingLayout<?> accessoriesComponent, boolean hasSideBar, ParentComponent primaryLayout) {
        if (((Boolean)this.getDefaultedData(PlayerOptions.ENTITY_CENTERED)).booleanValue()) {
            int padding = 0;
            Boolean paddingOnTheRight = (Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION);
            if (accessoriesComponent != null) {
                int operationValue = (Boolean)this.getDefaultedData(PlayerOptions.SIDE_WIDGET_POSITION) != false ? 1 : -1;
                int roundingOffset = 0;
                if (((Boolean)this.getDefaultedData(PlayerOptions.SIDE_WIDGET_POSITION)).booleanValue()) {
                    roundingOffset = (Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) != false ? -1 : -3;
                } else if (this.component(Component.class, "group_filter_holder") == null && !((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION)).booleanValue()) {
                    roundingOffset = -2;
                }
                padding = accessoriesComponent.getMaxPossibleWidth() + 3 + (hasSideBar ? 35 : 0) * operationValue + roundingOffset;
                primaryLayout.padding(paddingOnTheRight != false ? Insets.right((int)padding) : Insets.left((int)padding));
            }
        } else {
            primaryLayout.padding(Insets.none());
        }
    }

    public void rebuildEntityComponent() {
        FlowLayout holder = this.component(FlowLayout.class, "entity_renderer_holder");
        holder.clearChildren();
        holder.child(this.createEntityComponent());
        this.rebuildComponentRectangles = true;
    }

    public Component createEntityComponent() {
        Boolean sideBySideView = (Boolean)this.getDefaultedData(PlayerOptions.SIDE_BY_SIDE_ENTITY);
        return InventoryEntityComponent.of(Sizing.fixed((int)(sideBySideView != false ? 162 : 108)), Sizing.fixed((int)126), ((AccessoriesMenu)this.method_17577()).targetEntityDefaulted()).renderWrapping((TriConsumer<OwoUIDrawContext, Component, List<Runnable>>)((TriConsumer)(ctx, component, renderCall) -> AccessoriesFunkyRenderingState.INSTANCE.wrapEntityRendering(component.x() + 24, component.y(), component.x() + component.width() - 24, component.y() + component.height(), primaryEntityWrapCall -> {
            primaryEntityWrapCall.accept(() -> ((Runnable)renderCall.getFirst()).run());
            if (renderCall.size() != 1) {
                ((Runnable)renderCall.get(1)).run();
            }
        }))).sideBySideMode(sideBySideView).additionalOffset(sideBySideView != false ? 12 : 0).startingRotation((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) != false ? -45.0f : 45.0f).scaleToFit(true).allowMouseRotation(true).lookAtCursor(Accessories.config().screenOptions.entityLooksAtMouseCursor()).id("entity_rendering_component");
    }

    public void rebuildAccessoriesComponent() {
        ((AccessoriesMenu)this.method_17577()).getAccessoriesSlots().forEach(this::disableSlot);
        FlowLayout primaryLayout = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "armor_entity_layout");
        AccessoriesContainingLayout accessoriesLayout = (AccessoriesContainingLayout)primaryLayout.childById(AccessoriesContainingLayout.class, AccessoriesContainingLayout.defaultID());
        ParentComponent accessoriesParent = accessoriesLayout.parent();
        if (accessoriesParent != null) {
            ComponentUtils.recursiveSearchSlots(accessoriesParent, slotComponent -> this.hideSlot(slotComponent.slot()));
            accessoriesParent.removeChild((Component)accessoriesLayout);
        }
        AccessoriesContainingLayout<?> accessoriesComponent = this.createAccessoriesComponent();
        boolean hasSideBar = false;
        if (accessoriesComponent != null) {
            if (((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION)).booleanValue()) {
                primaryLayout.child(0, accessoriesComponent);
            } else {
                primaryLayout.child(accessoriesComponent);
            }
            hasSideBar = this.swapOrCreateSideBarComponent();
        } else if (((AccessoriesMenu)this.method_17577()).selectedGroups().isEmpty()) {
            ParentComponent sideParParent;
            Component sideBarOptionsComponent = primaryLayout.childById(Component.class, "accessories_toggle_panel");
            if (sideBarOptionsComponent != null && (sideParParent = sideBarOptionsComponent.parent()) != null) {
                sideParParent.removeChild(sideBarOptionsComponent);
            }
        } else {
            hasSideBar = this.swapOrCreateSideBarComponent();
        }
        this.setupPadding(accessoriesComponent, hasSideBar, (ParentComponent)primaryLayout);
        this.toggleCraftingGrid();
        this.rebuildComponentRectangles = true;
    }

    public boolean swapOrCreateSideBarComponent() {
        if (this.topComponent == null && ((AccessoriesMenu)this.method_17577()).selectedGroups().isEmpty()) {
            return false;
        }
        FlowLayout armorAndEntityComp = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "armor_entity_layout");
        armorAndEntityComp.removeChild(armorAndEntityComp.childById(FlowLayout.class, "side_bar_holder"));
        Component sideBarResultWidget = this.createSideBarOptions();
        this.rebuildComponentRectangles = true;
        if (sideBarResultWidget != null) {
            if (((Boolean)this.getDefaultedData(PlayerOptions.SIDE_WIDGET_POSITION)).booleanValue() == ((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION)).booleanValue()) {
                armorAndEntityComp.child(0, sideBarResultWidget);
            } else {
                armorAndEntityComp.child(sideBarResultWidget);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private AccessoriesContainingLayout<?> createAccessoriesComponent() {
        this.topComponent = (Integer)this.getDefaultedData(PlayerOptions.WIDGET_TYPE) == 2 ? ScrollableAccessoriesLayout.createOrNull(this) : PaginatedAccessoriesLayout.createOrNull(this);
        return this.topComponent;
    }

    @Nullable
    private Component createSideBarOptions() {
        FlowLayout accessoriesTogglePanel = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).id("accessories_toggle_panel");
        Component groupFilterComponent = this.createGroupFilters();
        if (groupFilterComponent != null) {
            return Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)accessoriesTogglePanel.child(groupFilterComponent).padding(Insets.of((int)7)).surface((ctx, component) -> ComponentUtils.getPanelSurface().and(ComponentUtils.getPanelWithInset(6)).draw(ctx, component)).horizontalAlignment(HorizontalAlignment.CENTER)).horizontalAlignment((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) != false ? HorizontalAlignment.LEFT : HorizontalAlignment.RIGHT).id("side_bar_holder");
        }
        return null;
    }

    public void rebuildSideBarOptions() {
        if (((Boolean)this.getDefaultedData(PlayerOptions.SHOW_GROUP_FILTER)).booleanValue()) {
            Component groupFilter;
            FlowLayout panel = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "accessories_toggle_panel");
            if (panel != null && (groupFilter = this.createGroupFilters()) != null) {
                panel.child(groupFilter);
            }
        } else {
            ParentComponent component = (ParentComponent)this.rootComponent().childById(ParentComponent.class, "group_filter_holder");
            if (component != null) {
                component.remove();
            }
        }
        this.rebuildComponentRectangles = true;
        this.toggleCraftingGrid();
    }

    @Nullable
    private Component createGroupFilters() {
        if (!((Boolean)this.getDefaultedData(PlayerOptions.SHOW_GROUP_FILTER)).booleanValue()) {
            return null;
        }
        ArrayList<SlotGroup> groups = new ArrayList<SlotGroup>(SlotGroupLoader.getValidGroups(((AccessoriesMenu)this.method_17577()).targetEntityDefaulted()).keySet());
        if (groups.isEmpty()) {
            return null;
        }
        Set<SlotType> usedSlots = ((AccessoriesMenu)this.method_17577()).getUsedSlots();
        ArrayList<Component> groupButtons = new ArrayList<Component>();
        for (SlotGroup group : groups) {
            Set groupSlots = group.slots().stream().filter(slotName -> {
                if (UniqueSlotHandling.isUniqueSlot(slotName)) {
                    return false;
                }
                SlotType slotType = SlotTypeLoader.getSlotType(this.targetEntityDefaulted(), slotName);
                if (slotType == null) {
                    return false;
                }
                AccessoriesCapability capability = this.targetEntityDefaulted().accessoriesCapability();
                if (capability == null) {
                    return false;
                }
                AccessoriesContainer container = capability.getContainer(slotType);
                if (container == null) {
                    return false;
                }
                return container.getSize() > 0;
            }).map(slotName -> SlotTypeLoader.INSTANCE.getSlotType(false, (String)slotName)).collect(Collectors.toSet());
            if (groupSlots.isEmpty()) continue;
            if (usedSlots != null) {
                if (groupSlots.stream().noneMatch(usedSlots::contains)) continue;
            }
            groupButtons.add(ComponentUtils.createGroupToggle(this, group));
        }
        if (groupButtons.isEmpty()) {
            return null;
        }
        Object baseButtonLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).children(groupButtons).gap(1);
        if (groupButtons.size() > 7) {
            ExtendedScrollContainer scrollable = (ExtendedScrollContainer)new ExtendedScrollContainer<ParentComponent>(ScrollContainer.ScrollDirection.VERTICAL, Sizing.fixed((int)21), Sizing.fixed((int)108), baseButtonLayout.padding(Insets.of((int)1))).configure(scrollContainer -> scrollContainer.oppositeScrollbar(((Boolean)this.getDefaultedData(PlayerOptions.SIDE_WIDGET_POSITION)).booleanValue() == ((Boolean)this.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION)).booleanValue()).scrollToAfterLayout(this.groupFilterScrollable != null ? this.groupFilterScrollable.getProgress() : 0.0).scrollbarThiccness(2).scrollbar(ScrollContainer.Scrollbar.flat((Color)Color.ofArgb((int)-1610612736))).fixedScrollbarLength(16).padding(Insets.of((int)1, (int)2, (int)2, (int)1)).id("group_filters_scrollable"));
            baseButtonLayout = scrollable;
            this.groupFilterScrollable = scrollable;
        } else {
            baseButtonLayout.padding(Insets.of((int)1, (int)2, (int)2, (int)2));
            this.groupFilterScrollable = null;
        }
        return Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(ComponentUtils.createIconButton(btn -> {
            ((AccessoriesMenu)this.method_17577()).selectedGroups().clear();
            this.rebuildAccessoriesComponent();
        }, 14, btn -> btn.tooltip((class_2561)class_2561.method_43471((String)Accessories.translationKey("reset.group_filter"))), btn -> Accessories.of("textures/gui/reset_icon" + (btn.method_49606() ? "_hovered" : "") + ".png")).margins(Insets.of((int)3, (int)1, (int)0, (int)0))).child((Component)baseButtonLayout).horizontalAlignment(HorizontalAlignment.CENTER).id("group_filter_holder");
    }

    private void swapBottomComponentHolder() {
        FlowLayout holder = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "bottom_component_holder");
        holder.clearChildren();
        if (((Boolean)this.getDefaultedData(PlayerOptions.ADVANCED_SETTINGS)).booleanValue()) {
            for (int i = 0; i < ((AccessoriesMenu)this.field_2797).startingAccessoriesSlot() - 1; ++i) {
                this.disableSlot(i);
            }
            this.settingsLayout = new AccessoriesScreenSettingsLayout(this, this::component).onChange(type -> {
                switch (type) {
                    case ACCESSORIES: {
                        this.rebuildAccessoriesComponent();
                        break;
                    }
                    case ENTITY: {
                        this.rebuildEntityComponent();
                        break;
                    }
                    case SIDE_BAR: {
                        this.rebuildSideBarOptions();
                        break;
                    }
                    case SLOTS: {
                        ((AccessoriesMenu)this.method_17577()).updateUsedSlots();
                    }
                }
            });
            holder.child((Component)this.settingsLayout).surface(ComponentUtils.getInsetPanelSurface()).padding(Insets.of((int)1));
        } else {
            this.settingsLayout = null;
            holder.child(ComponentUtils.createPlayerInv(5, ((AccessoriesMenu)this.field_2797).startingAccessoriesSlot(), this::slotAsComponent, x$0 -> this.enableSlot((int)x$0))).surface(Surface.BLANK).padding(Insets.of((int)0));
        }
        this.rebuildComponentRectangles = true;
    }

    private void toggleCraftingGrid() {
        this.rebuildComponentRectangles = true;
        this.removeCraftingGrid();
        if (!((Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID)).booleanValue()) {
            return;
        }
        FlowLayout bottom_holder = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "crafting_grid_layout");
        bottom_holder.child(this.createCraftingGrid());
    }

    private void removeCraftingGrid() {
        FlowLayout bottom_holder = (FlowLayout)this.rootComponent().childById(FlowLayout.class, "crafting_grid_layout");
        if (bottom_holder != null) {
            bottom_holder.clearChildren();
        }
        if (!((Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID)).booleanValue()) {
            bottom_holder.margins(Insets.of((int)0));
            for (int i = 0; i < 5; ++i) {
                this.disableSlot(i);
            }
        }
    }

    private Component createCraftingGrid() {
        return ComponentUtils.createCraftingComponent(0, this::slotAsComponent, x$0 -> this.enableSlot((int)x$0), true).id("crafting_component");
    }

    private Component createCraftingToggleButton() {
        return ComponentUtils.createIconButton(btn -> {
            AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.SHOW_CRAFTING_GRID, ((AccessoriesMenu)this.field_2797).method_61631(), bl -> bl == false));
            this.setData(PlayerOptions.SHOW_CRAFTING_GRID, (Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID) == false);
            btn.tooltip(AccessoriesScreen.createToggleText("crafting_grid", true, (Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID)));
            this.toggleCraftingGrid();
        }, 14, "crafting_grid_btn", btn -> btn.tooltip(AccessoriesScreen.createToggleText("crafting_grid", true, (Boolean)this.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID))).margins(Insets.of((int)0, (int)3, (int)3, (int)0)), (ctx, btn) -> Accessories.of("textures/gui/crafting_toggle_icon" + (btn.method_49606() ? "_hovered" : "") + ".png")).positioning(Positioning.relative((int)0, (int)100));
    }

    @Override
    public void onHolderChange(PlayerOption<?> option) {
        if (this.settingsLayout == null) {
            return;
        }
        this.settingsLayout.onHolderChange(option);
        if (option.equals(PlayerOptions.SHOW_CRAFTING_GRID)) {
            StackLayout buttonPanel = this.component(StackLayout.class, "entity_button_panel");
            Component craftingBtn = buttonPanel.childById(Component.class, "crafting_grid_btn");
            if (craftingBtn != null && Accessories.config().screenOptions.alwaysShowCraftingGrid()) {
                buttonPanel.removeChild(craftingBtn);
            } else if (craftingBtn == null && Accessories.config().screenOptions.alwaysShowCraftingGrid()) {
                buttonPanel.child(buttonPanel.children().size() - 1, this.createCraftingToggleButton());
            }
        }
    }

    private void toggleAdvancedOptions(ButtonComponent btn) {
        boolean value = (Boolean)this.getDefaultedData(PlayerOptions.ADVANCED_SETTINGS) == false;
        this.setData(PlayerOptions.ADVANCED_SETTINGS, value);
        btn.tooltip(AccessoriesScreen.createToggleText("advanced_options", true, (Boolean)this.getDefaultedData(PlayerOptions.ADVANCED_SETTINGS)));
        this.swapBottomComponentHolder();
    }

    private static class_2561 createToggleText(String type, boolean isTooltip, boolean value) {
        return Accessories.translation(type + ".toggle." + (value ? "enabled" : "disabled") + (isTooltip ? ".tooltip" : ""));
    }

    public ExtendedSlotComponent slotAsComponent(int index) {
        return new ExtendedSlotComponent(this, index);
    }

    @Override
    public <T> Optional<T> getData(PlayerOption<T> option) {
        return option.getData(((AccessoriesMenu)this.field_2797).method_61631()).or(() -> {
            AccessoriesPlayerOptionsHolder defaults = Accessories.config().screenOptions.defaultValues();
            return defaults != null ? defaults.getData(option) : Optional.empty();
        });
    }

    @Override
    public <T> void setData(PlayerOption<T> option, T data) {
        option.setData(((AccessoriesMenu)this.field_2797).method_61631(), data);
    }

    public class ExtendedSlotComponent
    extends BaseOwoHandledScreen.SlotComponent {
        protected final AccessoriesScreen screen;
        protected int index;

        protected ExtendedSlotComponent(AccessoriesScreen this$0, int index) {
            super((BaseOwoHandledScreen)this$0, index);
            this.screen = this$0;
            this.index = index;
            this.didDraw = true;
            class_1735 class_17352 = this.slot();
            if (class_17352 instanceof AccessoriesBasedSlot) {
                AccessoriesBasedSlot accessoriesBasedSlot = (AccessoriesBasedSlot)class_17352;
                this.tooltip(accessoriesBasedSlot.getTooltipData());
            }
        }

        public final class_1735 slot() {
            return this.slot;
        }

        public void dismount(Component.DismountReason reason) {
            super.dismount(reason);
            if (reason == Component.DismountReason.REMOVED) {
                ((SlotAccessor)this.slot).owo$setX(-300);
                ((SlotAccessor)this.slot).owo$setY(-300);
            }
        }

        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            this.didDraw = true;
            ((OwoSlotExtension)this.slot).owo$setDisabledOverride(false);
        }

        public void drawTooltip(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            class_1735 slot = this.slot();
            if (slot != null) {
                if (slot instanceof AccessoriesBasedSlot) {
                    AccessoriesBasedSlot accessoriesInternalSlot = (AccessoriesBasedSlot)slot;
                    if (!ArmorSlotTypes.isArmorType(accessoriesInternalSlot.slotName())) {
                        AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue((Boolean)this.screen.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION));
                    }
                } else if (slot instanceof class_9692) {
                    AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(true);
                } else if ((slot.field_7871 instanceof class_1715 || slot instanceof class_1734) && !((Boolean)this.screen.getDefaultedData(PlayerOptions.SHOW_GROUP_FILTER)).booleanValue()) {
                    AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue((Boolean)this.screen.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) == false);
                }
            }
            super.drawTooltip(context, mouseX, mouseY, partialTicks, delta);
            AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(false);
        }
    }
}

