/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.client.gui.components.CollectedPositionedRectangle;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1735;
import org.jetbrains.annotations.Nullable;

public abstract class AccessoriesContainingLayout<D extends LayoutData>
extends FlowLayout {
    protected final AccessoriesScreen screen;
    protected final D layoutData;

    protected AccessoriesContainingLayout(AccessoriesScreen screen, D layoutData) {
        super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.VERTICAL);
        this.screen = screen;
        this.layoutData = layoutData;
        this.id(AccessoriesContainingLayout.defaultID());
        this.buildLayout(layoutData);
        this.updatePadding();
    }

    public int getCurrentWidth() {
        BaseLayoutGroup currentGroup = this.getCurrentGroup();
        int slotsWidth = currentGroup.totalColumnCount() * 18;
        if (this.layoutData.sideBySide() && this.screen.showCosmeticState()) {
            slotsWidth = slotsWidth * 2 + 3;
        }
        return slotsWidth + 14;
    }

    public int getMaxPossibleWidth() {
        int slotsWidth = this.layoutData.maxColumnCount() * 18;
        if (this.layoutData.sideBySide() && this.screen.showCosmeticState()) {
            slotsWidth = slotsWidth * 2 + 3;
        }
        return slotsWidth + 14;
    }

    public int getPaddingOffset() {
        return this.getMaxPossibleWidth() - this.getCurrentWidth();
    }

    public void updatePadding() {
        int padding = this.getPaddingOffset();
        this.padding((Boolean)this.screen.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) != false ? Insets.left((int)padding) : Insets.right((int)padding));
    }

    public static String defaultID() {
        return "outer_accessories_layout";
    }

    public abstract void onCosmeticToggle(boolean var1);

    @Nullable
    public Boolean isHovering_Logical(class_1735 slot, double mouseX, double mouseY) {
        for (PositionedRectangle child : this.getAlternativeChecks(this.screen.showCosmeticState())) {
            if (!child.isInBoundingBox(mouseX, mouseY)) continue;
            return false;
        }
        return null;
    }

    protected abstract Iterable<PositionedRectangle> getAlternativeChecks(boolean var1);

    protected abstract void buildLayout(D var1);

    protected abstract BaseLayoutGroup getCurrentGroup();

    protected static BaseLayoutGroup createBaseLayoutGroup(AccessoriesScreen screen, List<class_1735> slots, int totalRowCount, int maxColumnCount, int colStartingIndexOffset, boolean sideBySide) {
        FlowLayout accessoriesLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        FlowLayout cosmeticsLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        ArrayList<PositionedRectangle> accessoriesChecks = new ArrayList<PositionedRectangle>();
        ArrayList<PositionedRectangle> cosmeticChecks = new ArrayList<PositionedRectangle>();
        int totalColumnCount = maxColumnCount;
        for (int row = 0; row < totalRowCount; ++row) {
            int colStartingIndex = colStartingIndexOffset + row * (maxColumnCount * 2);
            FlowLayout accessoriesRowLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).id("row_" + row);
            FlowLayout cosmeticRowLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).id("row_" + row);
            ArrayList<PositionedRectangle> accessoriesRowButtons = new ArrayList<PositionedRectangle>();
            ArrayList<PositionedRectangle> cosmeticRowButtons = new ArrayList<PositionedRectangle>();
            boolean overMaxSlots = false;
            for (int col = 0; col < maxColumnCount; ++col) {
                int cosmetic = colStartingIndex + col * 2;
                int accessory = cosmetic + 1;
                if (accessory >= slots.size() || cosmetic >= slots.size()) {
                    overMaxSlots = true;
                    if (row != 0) break;
                    totalColumnCount = col;
                    break;
                }
                AccessoriesBasedSlot cosmeticSlot = (AccessoriesBasedSlot)slots.get(cosmetic);
                AccessoriesBasedSlot accessorySlot = (AccessoriesBasedSlot)slots.get(accessory);
                screen.hideSlot(cosmeticSlot);
                screen.hideSlot(accessorySlot);
                if (sideBySide && screen.showCosmeticState()) {
                    screen.enableSlot(cosmeticSlot);
                    screen.enableSlot(accessorySlot);
                } else {
                    screen.enableSlot(screen.showCosmeticState() ? cosmeticSlot : accessorySlot);
                    screen.disableSlot(screen.showCosmeticState() ? accessorySlot : cosmeticSlot);
                }
                Pair<Component, PositionedRectangle> accessoryComponentData = ComponentUtils.createSlotWithToggle(accessorySlot, screen::slotAsComponent);
                accessoriesRowLayout.child((Component)accessoryComponentData.first());
                accessoriesRowButtons.add((PositionedRectangle)accessoryComponentData.second());
                Pair<Component, PositionedRectangle> cosmeticComponentData = ComponentUtils.createSlotWithToggle(cosmeticSlot, screen::slotAsComponent, !sideBySide);
                cosmeticRowLayout.child((Component)cosmeticComponentData.first());
                if (cosmeticComponentData.second() == null) continue;
                cosmeticRowButtons.add((PositionedRectangle)cosmeticComponentData.second());
            }
            accessoriesLayout.child((Component)accessoriesRowLayout);
            cosmeticsLayout.child((Component)cosmeticRowLayout);
            accessoriesChecks.add(CollectedPositionedRectangle.of((PositionedRectangle)accessoriesRowLayout, accessoriesRowButtons));
            CollectedPositionedRectangle checks = CollectedPositionedRectangle.of((PositionedRectangle)cosmeticRowLayout, cosmeticRowButtons);
            if (!checks.isEmpty()) {
                cosmeticChecks.add(checks);
            }
            if (overMaxSlots) break;
        }
        return new BaseLayoutGroup(accessoriesLayout, cosmeticsLayout, accessoriesChecks, cosmeticChecks, totalColumnCount);
    }

    public static interface LayoutData {
        default public int width() {
            return this.maxColumnCount() * 18;
        }

        default public int height() {
            return this.maxRowCount() * 18;
        }

        public int maxColumnCount();

        public int maxRowCount();

        public boolean sideBySide();
    }

    protected record BaseLayoutGroup(FlowLayout accessoriesLayout, FlowLayout cosmeticLayout, List<PositionedRectangle> accessoriesBtnChecks, List<PositionedRectangle> cosmeticBtnChecks, int totalColumnCount) {
        public static final BaseLayoutGroup DEFAULT = new BaseLayoutGroup(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()), Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()), List.of(), List.of(), 0);

        public FlowLayout getLayout(boolean isCosmetic) {
            return isCosmetic ? this.cosmeticLayout : this.accessoriesLayout;
        }

        public List<PositionedRectangle> getAlternativeChecks(boolean isCosmetic) {
            return isCosmetic ? this.cosmeticBtnChecks : this.accessoriesBtnChecks;
        }

        public int width(boolean isCosmetic, boolean sideBySide) {
            int baseWidth = 0;
            if (sideBySide) {
                baseWidth += this.getComponentWidth(false);
                if (isCosmetic) {
                    baseWidth += this.getComponentWidth(true) + 3;
                }
            } else {
                baseWidth += this.getComponentWidth(isCosmetic);
            }
            return baseWidth;
        }

        private int getComponentWidth(boolean isCosmetic) {
            FlowLayout component = this.getLayout(isCosmetic);
            if (component.parent() == null) {
                component.inflate(Size.square((int)Integer.MAX_VALUE));
            }
            return component.width();
        }
    }
}

