/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.client.gui.components.InventoryEntityComponent;
import io.wispforest.accessories.impl.option.PlayerOption;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.impl.option.PlayerOptionsAccess;
import io.wispforest.accessories.mixin.client.AbstractSliderButtonAccessor;
import io.wispforest.accessories.mixin.client.owo.DiscreteSliderComponentAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DiscreteSliderComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class AccessoriesScreenSettingsLayout
extends FlowLayout
implements PlayerOptionsAccess {
    private final PlayerOptionsAccess optionAccess;
    private final ComponentAccess componentAccess;
    private Consumer<ChangeType> onChangeCallback = changeType -> {};
    private boolean shouldNetworkSync = true;
    private boolean updateLive = false;
    private int maxWidth = 162;
    private int columnAmount = 1;

    public AccessoriesScreenSettingsLayout(PlayerOptionsAccess optionAccess, ComponentAccess componentAccess) {
        super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.VERTICAL);
        this.optionAccess = optionAccess;
        this.componentAccess = componentAccess;
        this.buildLayout();
    }

    public AccessoriesScreenSettingsLayout onChange(Consumer<ChangeType> onChangeCallback) {
        this.onChangeCallback = onChangeCallback;
        return this;
    }

    public AccessoriesScreenSettingsLayout shouldNetworkSync(boolean value) {
        this.shouldNetworkSync = value;
        return this;
    }

    public AccessoriesScreenSettingsLayout updateLive(boolean value) {
        this.updateLive = value;
        return this;
    }

    @Override
    public <T> Optional<T> getData(PlayerOption<T> option) {
        return this.optionAccess.getData(option);
    }

    @Override
    public <T> void setData(PlayerOption<T> option, T data) {
        this.optionAccess.setData(option, data);
        if (this.updateLive) {
            this.onHolderChange(option);
        }
    }

    private <R extends Record> void syncToServer(R packet) {
        if (!this.shouldNetworkSync) {
            return;
        }
        AccessoriesNetworking.sendToServer(packet);
    }

    private void buildLayout() {
        ArrayList<Component> children = new ArrayList<Component>();
        children.add(this.wrapAsSettings(PlayerOptions.COLUMN_AMOUNT, Components.discreteSlider((Sizing)Sizing.fixed((int)45), (double)this.getMinimumColumnAmount(), (double)this.getMaximumColumnAmount()).configure(slider -> {
            slider.snap(true).setFromDiscreteValue((double)((Integer)this.getDefaultedData(PlayerOptions.COLUMN_AMOUNT)).intValue()).scrollStep((double)(1.0f / (float)(18 - this.getMinimumColumnAmount())));
            slider.onChanged().subscribe(value -> {
                this.syncToServer(PlayerOptions.COLUMN_AMOUNT.toPacket((int)value));
                this.setData(PlayerOptions.COLUMN_AMOUNT, (int)value);
                this.onChangeCallback.accept(ChangeType.ACCESSORIES);
            });
        })));
        children.add(this.wrapAsSettings(PlayerOptions.WIDGET_TYPE, Components.button((class_2561)AccessoriesScreenSettingsLayout.widgetTypeToggleMessage((Integer)this.getDefaultedData(PlayerOptions.WIDGET_TYPE), false), btn -> {
            int newWidget = (Integer)this.getDefaultedData(PlayerOptions.WIDGET_TYPE) + 1;
            if (newWidget > 2) {
                newWidget = 1;
            }
            this.syncToServer(PlayerOptions.WIDGET_TYPE.toPacket(newWidget));
            this.setData(PlayerOptions.WIDGET_TYPE, newWidget);
            this.onHolderChange(PlayerOptions.WIDGET_TYPE);
        }).renderer(ComponentUtils.getButtonRenderer()).tooltip(AccessoriesScreenSettingsLayout.widgetTypeToggleMessage((Integer)this.getDefaultedData(PlayerOptions.WIDGET_TYPE), true))));
        children.add(this.ofSettingsToggle(PlayerOptions.SHOW_UNUSED_SLOTS, (option, newValue) -> this.syncToServer(option.toPacket(newValue))));
        children.add(this.ofSettingsToggle(PlayerOptions.SIDE_BY_SIDE_SLOTS, (option, newValue) -> {
            this.syncToServer(option.toPacket(newValue));
            this.onChangeCallback.accept(ChangeType.ACCESSORIES);
        }));
        children.add(this.ofSettingsToggle(PlayerOptions.SIDE_BY_SIDE_ENTITY, (option, newValue) -> {
            this.syncToServer(option.toPacket(newValue));
            this.onChangeCallback.accept(ChangeType.ENTITY);
        }));
        children.add(this.ofSettingsToggle(PlayerOptions.MAIN_WIDGET_POSITION, (option, newValue) -> {
            this.syncToServer(option.toPacket(newValue));
            this.componentAccess.adjustIfPresent(InventoryEntityComponent.class, "entity_rendering_component", c -> c.startingRotation(newValue != false ? -45.0f : 45.0f));
        }));
        children.add(this.ofSettingsToggle(PlayerOptions.SHOW_GROUP_FILTER, (option, newValue) -> {
            this.syncToServer(option.toPacket(newValue));
            this.onChangeCallback.accept(ChangeType.SIDE_BAR);
        }));
        children.add(this.ofSettingsToggle(PlayerOptions.SIDE_WIDGET_POSITION, (option, newValue) -> {
            this.syncToServer(option.toPacket(newValue));
            this.onChangeCallback.accept(ChangeType.ACCESSORIES);
        }));
        children.add(this.ofSettingsToggle(PlayerOptions.ENTITY_CENTERED, (option, newValue) -> {
            this.syncToServer(option.toPacket(newValue));
            this.onChangeCallback.accept(ChangeType.ACCESSORIES);
        }));
        children.add(this.ofSettingsToggle("dark_mode_toggle", () -> Accessories.config().screenOptions.isDarkMode(), bl -> Accessories.config().screenOptions.isDarkMode((boolean)bl)));
        children.add(this.ofSettingsToggle("show_equipped_stack_slot_type", () -> Accessories.config().screenOptions.showEquippedStackSlotType(), bl -> Accessories.config().screenOptions.showEquippedStackSlotType((boolean)bl)));
        children.add(this.ofSettingsToggle("entity_look_at_cursor", () -> Accessories.config().screenOptions.entityLooksAtMouseCursor(), bl -> {
            Accessories.config().screenOptions.entityLooksAtMouseCursor((boolean)bl);
            this.componentAccess.adjustIfPresent(InventoryEntityComponent.class, "entity_rendering_component", c -> c.lookAtCursor(bl));
        }));
        GridLayout baseOptionPanel = (GridLayout)Containers.grid((Sizing)Sizing.fixed((int)this.maxWidth), (Sizing)Sizing.content(), (int)((int)Math.ceil((float)children.size() / (float)this.columnAmount)), (int)this.columnAmount).configure(component -> component.verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).padding(Insets.horizontal((int)3).withTop(1).withBottom(3)));
        for (int i = 0; i < children.size(); ++i) {
            int row = i / this.columnAmount;
            int column = i % this.columnAmount;
            Component child = (Component)children.get(i);
            baseOptionPanel.child(child, row, column);
            if (i + this.columnAmount < children.size()) {
                child.margins(Insets.bottom((int)2));
                continue;
            }
            if (this.columnAmount <= 1 || i + 1 < children.size() || column != 0) continue;
            baseOptionPanel.child((Component)this.createBaseParent(), row, 1);
        }
        this.child((Component)Containers.verticalScroll((Sizing)Sizing.expand(), (Sizing)Sizing.expand(), (Component)baseOptionPanel));
    }

    private int getEntryWidth() {
        return (this.maxWidth - 14) / this.columnAmount;
    }

    private Component ofSettingsToggle(PlayerOption<Boolean> playerOption, BiConsumer<PlayerOption<Boolean>, Boolean> onChange) {
        return this.ofSettingsToggle(playerOption.name(), () -> (Boolean)this.getDefaultedData(playerOption), newValue -> {
            this.setData(playerOption, newValue);
            onChange.accept(playerOption, (Boolean)newValue);
        });
    }

    private Component ofSettingsToggle(String name, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return this.wrapAsSettings(name, Components.button((class_2561)AccessoriesScreenSettingsLayout.createToggleText(name, false, getter.get()), btn -> {
            boolean newValue = (Boolean)getter.get() == false;
            btn.method_25355(AccessoriesScreenSettingsLayout.createToggleText(name, false, newValue));
            btn.tooltip(AccessoriesScreenSettingsLayout.createToggleText(name, true, newValue));
            setter.accept(newValue);
        }).renderer(ComponentUtils.getButtonRenderer()).tooltip(AccessoriesScreenSettingsLayout.createToggleText(name, true, getter.get())));
    }

    private Component wrapAsSettings(PlayerOption<?> playerOption, Component component) {
        return this.wrapAsSettings(playerOption.name(), component);
    }

    private Component wrapAsSettings(String name, Component component) {
        return this.createBaseParent().gap(0).child((Component)Components.label((class_2561)Accessories.translation(name + ".label")).margins(Insets.left((int)1))).child(component.id(name).horizontalSizing(Sizing.fixed((int)this.getEntryWidth())).verticalSizing(Sizing.fixed((int)14)));
    }

    private FlowLayout createBaseParent() {
        return Containers.verticalFlow((Sizing)Sizing.fixed((int)this.getEntryWidth()), (Sizing)Sizing.fixed((int)23));
    }

    private static class_2561 widgetTypeToggleMessage(int value, boolean isTooltip) {
        String type = value == 2 ? "scrollable" : "paginated";
        return Accessories.translation("widget_type." + type + (isTooltip ? ".tooltip" : ""));
    }

    private static class_2561 createToggleText(String type, boolean isTooltip, boolean value) {
        return Accessories.translation(type + ".toggle." + (value ? "enabled" : "disabled") + (isTooltip ? ".tooltip" : ""));
    }

    public void onHolderChange(PlayerOption<?> option) {
        boolean updateMaxValue;
        boolean hasChangeOccurred = false;
        if (option.equals(PlayerOptions.SHOW_UNUSED_SLOTS)) {
            hasChangeOccurred = true;
            this.updateToggleButton(PlayerOptions.SHOW_UNUSED_SLOTS, Accessories.config().screenOptions::showUnusedSlots);
            this.onChangeCallback.accept(ChangeType.SLOTS);
        }
        if (option.equals(PlayerOptions.SHOW_GROUP_FILTER)) {
            this.updateToggleButton(PlayerOptions.SHOW_GROUP_FILTER);
            hasChangeOccurred = true;
        }
        if (option.equals(PlayerOptions.MAIN_WIDGET_POSITION)) {
            this.updateToggleButton(PlayerOptions.MAIN_WIDGET_POSITION);
            hasChangeOccurred = true;
        }
        if (option.equals(PlayerOptions.SIDE_WIDGET_POSITION)) {
            this.updateToggleButton(PlayerOptions.SIDE_WIDGET_POSITION);
            hasChangeOccurred = true;
        }
        boolean bl = updateMaxValue = option.equals(PlayerOptions.SIDE_BY_SIDE_SLOTS) || (Boolean)this.getDefaultedData(PlayerOptions.SIDE_BY_SIDE_SLOTS) != false && option.equals(PlayerOptions.SIDE_BY_SIDE_ENTITY);
        if (updateMaxValue) {
            this.updateMaxValueColumnSlider(this.getMaximumColumnAmount());
            hasChangeOccurred = true;
        }
        if (option.equals(PlayerOptions.WIDGET_TYPE)) {
            this.updateMinValueColumnSlider(this.getMinimumColumnAmount());
            this.updateWidgetTypeToggleButton();
            hasChangeOccurred = true;
        }
        if (hasChangeOccurred) {
            this.onChangeCallback.accept(ChangeType.ACCESSORIES);
        }
    }

    public void updateMaxValueColumnSlider(int maxValue) {
        this.updateColumnSlider(null, maxValue);
    }

    public void updateMinValueColumnSlider(int minValue) {
        this.updateColumnSlider(minValue, null);
    }

    public void updateColumnSlider(@Nullable Integer minValue, @Nullable Integer maxValue) {
        DiscreteSliderComponent columnAmountSlider = (DiscreteSliderComponent)this.childById(DiscreteSliderComponent.class, PlayerOptions.COLUMN_AMOUNT.name());
        if (columnAmountSlider != null) {
            double previousValue = columnAmountSlider.discreteValue();
            DiscreteSliderComponentAccessor accessor = (DiscreteSliderComponentAccessor)columnAmountSlider;
            if (minValue != null) {
                accessor.accessories$setMin(minValue.intValue());
            } else {
                minValue = (int)Math.round(columnAmountSlider.min());
            }
            if (maxValue != null) {
                accessor.accessories$setMax(maxValue.intValue());
            } else {
                maxValue = (int)Math.round(columnAmountSlider.max());
            }
            ((AbstractSliderButtonAccessor)columnAmountSlider).accessories$setValue(-1.0);
            columnAmountSlider.setFromDiscreteValue((double)Math.min(Math.max((int)Math.round(previousValue), minValue), maxValue));
            double newValue = columnAmountSlider.discreteValue();
            if (newValue != previousValue) {
                this.setData(PlayerOptions.COLUMN_AMOUNT, (int)Math.round(newValue));
            }
        }
    }

    private boolean updateToggleButton(PlayerOption<Boolean> playerOption) {
        return this.updateToggleButton(playerOption, bl -> {});
    }

    private boolean updateToggleButton(PlayerOption<Boolean> playerOption, Consumer<Boolean> runnable) {
        return this.updateToggleButton(playerOption.name(), () -> (Boolean)this.getDefaultedData(playerOption), runnable);
    }

    private boolean updateToggleButton(String baseId, Supplier<Boolean> getter, Consumer<Boolean> runnable) {
        ButtonComponent btn = (ButtonComponent)this.childById(ButtonComponent.class, baseId);
        Boolean value = getter.get();
        btn.method_25355(AccessoriesScreenSettingsLayout.createToggleText(baseId, false, value));
        btn.tooltip(AccessoriesScreenSettingsLayout.createToggleText(baseId, true, value));
        runnable.accept(value);
        return true;
    }

    private void updateWidgetTypeToggleButton() {
        ButtonComponent btn = (ButtonComponent)this.childById(ButtonComponent.class, "widget_type");
        Integer value = (Integer)this.getDefaultedData(PlayerOptions.WIDGET_TYPE);
        btn.method_25355(AccessoriesScreenSettingsLayout.widgetTypeToggleMessage(value, false));
        btn.tooltip(AccessoriesScreenSettingsLayout.widgetTypeToggleMessage(value, true));
    }

    public int getMinimumColumnAmount() {
        return (Integer)this.getDefaultedData(PlayerOptions.WIDGET_TYPE) == 2 ? 1 : 3;
    }

    public int getMaximumColumnAmount() {
        return ((Boolean)this.getDefaultedData(PlayerOptions.SIDE_BY_SIDE_SLOTS)).booleanValue() ? (((Boolean)this.getDefaultedData(PlayerOptions.SIDE_BY_SIDE_ENTITY)).booleanValue() ? 4 : 6) : 9;
    }

    public static interface ComponentAccess {
        @Nullable
        public <T extends Component> T getComponent(Class<T> var1, String var2);

        default public <T extends Component> void adjustIfPresent(Class<T> clazz, String id, Consumer<T> callback) {
            T component = this.getComponent(clazz, id);
            if (component != null) {
                callback.accept(component);
            }
        }
    }

    public static enum ChangeType {
        ACCESSORIES,
        ENTITY,
        SIDE_BAR,
        SLOTS;

    }
}

