/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.renderstate.EntityElementRenderState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10017;
import net.minecraft.class_11256;
import net.minecraft.class_11908;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_7833;
import net.minecraft.class_8030;
import net.minecraft.class_897;
import net.minecraft.class_9064;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class InventoryEntityComponent<E extends class_1297>
extends EntityComponent<E> {
    private float startingRotation = -45.0f;
    private float lastBbWidth = 0.0f;
    private float lastBbHeight = 0.0f;
    private ScaleFitType type = ScaleFitType.NONE;
    private boolean sideBySideMode = false;
    private int additionalOffset = 0;
    public float xOffset = 0.0f;
    public float yOffset = 0.0f;
    private TriConsumer<OwoUIDrawContext, Component, List<Runnable>> renderWrapping = (ctx, component, runnables) -> runnables.forEach(Runnable::run);

    public InventoryEntityComponent(Sizing horizontalSizing, Sizing verticalSizing, E entity) {
        super(Sizing.fixed((int)0), entity);
        this.horizontalSizing(horizontalSizing).verticalSizing(verticalSizing);
        this.lastBbWidth = entity.method_17681();
        this.lastBbHeight = entity.method_17682();
    }

    public InventoryEntityComponent(Sizing horizontalSizing, Sizing verticalSizing, class_1299<E> type, @Nullable class_2487 nbt) {
        super(Sizing.fixed((int)0), type, nbt);
        this.horizontalSizing(horizontalSizing).verticalSizing(verticalSizing);
        this.lastBbWidth = this.entity.method_17681();
        this.lastBbHeight = this.entity.method_17682();
    }

    public static <E extends class_1297> InventoryEntityComponent<E> of(Sizing horizontalSizing, Sizing verticalSizing, E entity) {
        return new InventoryEntityComponent<E>(horizontalSizing, verticalSizing, entity);
    }

    public boolean sideBySideMode() {
        return this.sideBySideMode;
    }

    public InventoryEntityComponent<E> sideBySideMode(boolean sideBySideMode) {
        this.sideBySideMode = sideBySideMode;
        return this;
    }

    public int additionalOffset() {
        return this.additionalOffset;
    }

    public InventoryEntityComponent<E> additionalOffset(int value) {
        this.additionalOffset = value;
        return this;
    }

    private float getEntityScale() {
        float f;
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            f = living.method_55693();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public InventoryEntityComponent<E> renderWrapping(TriConsumer<OwoUIDrawContext, Component, List<Runnable>> renderWrapping) {
        this.renderWrapping = renderWrapping;
        return this;
    }

    public float getSingleInstanceWidth() {
        return (float)((Sizing)this.horizontalSizing().get()).value / (this.sideBySideMode ? 2.0f : 1.0f) - (float)(this.sideBySideMode ? 25 : 40);
    }

    public InventoryEntityComponent<E> scaleToFit(boolean scaleToFit) {
        if (scaleToFit) {
            float componentHeight = ((Sizing)this.verticalSizing().get()).value;
            float componentWidth = this.getSingleInstanceWidth();
            float entityHeight = this.entity.method_17682() * (Math.min(componentWidth, componentHeight) / Math.max(componentWidth, componentHeight));
            float entityWidth = this.entity.method_17681() * (Math.max(componentWidth, componentHeight) / Math.min(componentWidth, componentHeight));
            float length = Math.max(entityHeight, entityWidth);
            float baseScale = 0.35f / length;
            this.scale(baseScale);
            this.type = ScaleFitType.BOTH;
        } else {
            this.scale(1.0f);
            this.type = ScaleFitType.NONE;
        }
        return this;
    }

    public InventoryEntityComponent<E> startingRotation(float value) {
        this.startingRotation = value;
        return this;
    }

    public InventoryEntityComponent<E> scaleToFitVertically(boolean scaleToFit) {
        this.scale(scaleToFit ? 0.5f / this.entity.method_17682() : 1.0f);
        this.type = scaleToFit ? ScaleFitType.VERTICAL : ScaleFitType.NONE;
        return this;
    }

    public InventoryEntityComponent<E> scaleToFitHorizontally(boolean scaleToFit) {
        this.scale(scaleToFit ? 0.5f / this.entity.method_17681() : 1.0f);
        this.type = scaleToFit ? ScaleFitType.HORIZONTAL : ScaleFitType.NONE;
        return this;
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        class_1297 class_12972 = this.entity;
        if (!(class_12972 instanceof class_1309)) {
            super.draw(context, mouseX, mouseY, partialTicks, delta);
            return;
        }
        class_1309 living = (class_1309)class_12972;
        if (this.lastBbWidth != this.entity.method_17681() || this.lastBbHeight != this.entity.method_17682()) {
            switch (this.type.ordinal()) {
                case 0: {
                    this.scaleToFitVertically(true);
                    break;
                }
                case 1: {
                    this.scaleToFitHorizontally(true);
                    break;
                }
                case 2: {
                    this.scaleToFit(true);
                    break;
                }
            }
            this.lastBbWidth = this.entity.method_17681();
            this.lastBbHeight = this.entity.method_17682();
        }
        ArrayList<Runnable> renderQueue = new ArrayList<Runnable>();
        renderQueue.add(() -> {
            context.push();
            this.renderLiving(context, living, mouseX, mouseY, partialTicks, true);
            context.pop();
        });
        if (this.sideBySideMode) {
            renderQueue.add(() -> {
                context.push();
                this.renderLiving(context, living, mouseX, mouseY, partialTicks, false);
                context.pop();
            });
        }
        this.renderWrapping.accept((Object)context, (Object)this, renderQueue);
    }

    private void renderLiving(OwoUIDrawContext context, class_1309 living, int mouseX, int mouseY, float partialTicks, boolean isLeftSide) {
        Matrix4f matrix = new Matrix4f();
        this.transformMatrixStack(matrix, isLeftSide);
        this.transform.accept(matrix);
        float prevYBodyRot0 = living.field_6220;
        float prevYBodyRot = living.field_6283;
        float prevYRot = living.method_36454();
        float prevYRot0 = living.field_5982;
        float prevXRot = living.method_36455();
        float prevXRot0 = living.field_6004;
        float prevYHeadRot0 = living.field_6259;
        float prevYHeadRot = living.field_6241;
        this.rotateMatrixStack(matrix, living, mouseX, mouseY, isLeftSide);
        living.field_6220 = 0.0f;
        living.field_6283 = 0.0f;
        living.method_36456(0.0f);
        living.field_6241 = living.field_6283;
        living.field_6259 = living.field_6220;
        class_897 renderer = this.manager.method_3953(this.entity);
        class_10017 entityState = renderer.method_62425(this.entity, partialTicks);
        entityState.field_53325 = 0.0;
        entityState.field_53326 = 0.0;
        entityState.field_53327 = 0.0;
        if (this.showNametag) {
            entityState.field_53337 = this.entity.method_5476();
            entityState.field_53338 = this.entity.method_56072().method_55675(class_9064.field_47745, 0, this.entity.method_61415(partialTicks));
        } else {
            entityState.field_53337 = null;
            entityState.field_53338 = null;
        }
        entityState.field_61820 = 0xF000F0;
        entityState.field_58169 = null;
        entityState.field_61823.clear();
        entityState.field_61821 = 0;
        context.field_59826.method_70922((class_11256)new EntityElementRenderState(entityState, matrix, new class_8030(this.x, this.y, this.width, this.height), context.field_44659.method_70863()));
        living.field_6220 = prevYBodyRot0;
        living.field_6283 = prevYBodyRot;
        living.method_36456(prevYRot);
        living.field_5982 = prevYRot0;
        living.method_36457(prevXRot);
        living.field_6004 = prevXRot0;
        living.field_6259 = prevYHeadRot0;
        living.field_6241 = prevYHeadRot;
    }

    private void transformMatrixStack(Matrix4f matrix, boolean isLeftSide) {
        float trueWidth = (float)this.width / (this.sideBySideMode ? 2.0f : 1.0f);
        float maxLength = Math.max(trueWidth, (float)this.height);
        float baseScaleValue = 75.0f * this.scale;
        float xyScaleValue = baseScaleValue * maxLength / 64.0f;
        float yPos = (float)this.height / 2.0f;
        matrix.translate(this.centerOffSet(isLeftSide), -yPos, 60.0f);
        matrix.scale(xyScaleValue, -xyScaleValue, -baseScaleValue);
        matrix.translate(0.0f, this.entity.method_17682() / -2.0f, 0.0f);
        matrix.translate(this.xOffset * (float)(isLeftSide ? 1 : -1), this.yOffset, 0.0f);
    }

    private float centerOffSet(boolean isLeftSide) {
        return (float)this.additionalOffset * (isLeftSide ? -2.3f : 2.3f);
    }

    private void rotateMatrixStack(Matrix4f matrix, class_1309 living, int mouseX, int mouseY, boolean isLeftSide) {
        float rotationOffset;
        float trueWidth = (float)this.width / (this.sideBySideMode ? 2.0f : 1.0f);
        float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
        float f = rotationOffset = !isLeftSide ? 180.0f : 0.0f;
        if (this.lookAtCursor) {
            float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.x) - (trueWidth + this.centerOffSet(isLeftSide))) / 40.0f));
            living.field_6259 = -yRotation;
            this.entity.field_5982 = -yRotation;
            this.entity.field_6004 = xRotation * 0.65f;
            this.entity.method_36456(this.entity.field_5982);
            this.entity.method_36457(this.entity.field_6004);
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrix.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(xRotation * 0.35f));
            matrix.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(yRotation * 0.555f + rotationOffset));
        } else {
            this.entity.field_6004 = xRotation * 0.35f;
            this.entity.method_36457(this.entity.field_6004);
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrix.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(xRotation * 0.15f));
            matrix.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(15.0f));
            matrix.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(this.startingRotation + this.mouseRotation + rotationOffset));
        }
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        this.scale += (float)(amount * (double)this.scale * (double)0.1f);
        return true;
    }

    public boolean onKeyPress(class_11908 input) {
        int keycode = input.comp_4795();
        if (keycode == 263) {
            this.xOffset -= 0.05f;
        } else if (keycode == 262) {
            this.xOffset += 0.05f;
        }
        if (keycode == 265) {
            this.yOffset += 0.05f;
        } else if (keycode == 264) {
            this.yOffset -= 0.05f;
        }
        return super.onKeyPress(input);
    }

    public static enum ScaleFitType {
        VERTICAL,
        HORIZONTAL,
        BOTH,
        NONE;

    }
}

