/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.client.gui.components.AccessoriesContainingLayout;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.client.gui.components.ExtendedScrollContainer;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.menu.variants.AccessoriesMenu;
import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Sizing;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1735;
import org.apache.commons.lang3.IntegerRange;
import org.jetbrains.annotations.Nullable;

public class ScrollableAccessoriesLayout
extends AccessoriesContainingLayout<RawScrollData> {
    private IntegerRange alternativeCheckRange;

    protected ScrollableAccessoriesLayout(AccessoriesScreen screen, RawScrollData data) {
        super(screen, data);
        this.alternativeCheckRange = IntegerRange.of((int)0, (int)Math.min(data.maxRowCount, data.totalRowCount));
    }

    @Override
    public int getCurrentWidth() {
        return super.getCurrentWidth() + (((RawScrollData)this.layoutData).showScrollbar() ? 11 : 0);
    }

    @Override
    public int getMaxPossibleWidth() {
        return super.getMaxPossibleWidth() + 11;
    }

    @Nullable
    public static ScrollableAccessoriesLayout createOrNull(AccessoriesScreen screen) {
        RawScrollData data = ScrollableAccessoriesLayout.buildPages(screen);
        if (data == null) {
            return null;
        }
        return new ScrollableAccessoriesLayout(screen, data);
    }

    @Nullable
    private static RawScrollData buildPages(AccessoriesScreen screen) {
        AccessoriesMenu menu = (AccessoriesMenu)screen.method_17577();
        List<class_1735> slots = menu.getVisibleAccessoriesSlots();
        Boolean sideBySide = (Boolean)screen.getDefaultedData(PlayerOptions.SIDE_BY_SIDE_SLOTS);
        Integer maxColumnCount = (Integer)screen.getDefaultedData(PlayerOptions.COLUMN_AMOUNT);
        int maxRowCount = 7;
        int totalRowCount = (int)Math.ceil((float)slots.size() / 2.0f / (float)maxColumnCount.intValue());
        if (totalRowCount <= 0) {
            return null;
        }
        AccessoriesContainingLayout.BaseLayoutGroup baseLayoutGroup = ScrollableAccessoriesLayout.createBaseLayoutGroup(screen, slots, totalRowCount, maxColumnCount, 0, sideBySide);
        baseLayoutGroup.accessoriesLayout().surface(ComponentUtils.BACKGROUND_SLOT_RENDERING_SURFACE);
        baseLayoutGroup.cosmeticLayout().surface(ComponentUtils.BACKGROUND_SLOT_RENDERING_SURFACE);
        return new RawScrollData(baseLayoutGroup, totalRowCount, maxColumnCount, maxRowCount, (maxColumnCount - baseLayoutGroup.totalColumnCount()) * 18, sideBySide);
    }

    @Override
    protected AccessoriesContainingLayout.BaseLayoutGroup getCurrentGroup() {
        return ((RawScrollData)this.layoutData).baseLayoutGroup();
    }

    @Override
    protected void buildLayout(RawScrollData layoutData) {
        FlowLayout fullLayout;
        int minimumLayoutHeight = layoutData.height() + 12;
        AccessoriesContainingLayout.BaseLayoutGroup baseGroupData = layoutData.baseLayoutGroup();
        if (layoutData.sideBySide()) {
            fullLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(3);
            fullLayout.id("side_by_side_holder");
            if (this.screen.showCosmeticState()) {
                fullLayout.child((Component)baseGroupData.cosmeticLayout());
            }
            fullLayout.child((Component)baseGroupData.accessoriesLayout());
        } else {
            fullLayout = this.screen.showCosmeticState() ? baseGroupData.cosmeticLayout() : baseGroupData.accessoriesLayout();
        }
        int paddingValue = layoutData.showScrollbar() ? 3 : 0;
        fullLayout.padding((Boolean)this.screen.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) != false ? Insets.left((int)paddingValue) : Insets.right((int)paddingValue));
        int width = layoutData.width();
        if (this.screen.showCosmeticState() && layoutData.sideBySide()) {
            width = width * 2 + 3;
        }
        Object innerAccessoriesLayout = layoutData.showScrollbar() ? new ExtendedScrollContainer<FlowLayout>(ScrollContainer.ScrollDirection.VERTICAL, Sizing.fixed((int)(width + 8 + 3)), Sizing.fixed((int)layoutData.height()), fullLayout).strictMouseScrolling(!Accessories.config().screenOptions.allowSlotScrolling()).oppositeScrollbar((Boolean)this.screen.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION)).scrolledToCallback((container, prevOffset, scrollOffset) -> {
            if (Objects.equals(prevOffset, scrollOffset)) {
                return;
            }
            int rowIndex = prevOffset - scrollOffset < 0.0 ? (int)Math.floor(scrollOffset / 18.0) : (int)Math.ceil(scrollOffset / 18.0);
            int maximumRangeValue = Math.min(rowIndex + layoutData.maxRowCount(), layoutData.totalRowCount()) - 1;
            this.alternativeCheckRange = IntegerRange.of((int)rowIndex, (int)maximumRangeValue);
        }).scrollbarThiccness(8).scrollbar(ScrollContainer.Scrollbar.vanilla()).fixedScrollbarLength(16).scrollStep(18).scrollbar(ComponentUtils.getScrollbarRenderer()).id("accessories_scroll_container") : Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)fullLayout);
        innerAccessoriesLayout.id("inner_accessories_container");
        FlowLayout accessoriesMainLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(3).child((Component)innerAccessoriesLayout).horizontalAlignment(HorizontalAlignment.RIGHT).surface(ComponentUtils.getPanelSurface()).padding(Insets.of((int)7)).id("accessories_layout");
        if (layoutData.showScrollbar()) {
            this.child((Component)accessoriesMainLayout);
            return;
        }
        this.sizing(Sizing.content(), Sizing.fixed((int)minimumLayoutHeight));
        this.child((Component)accessoriesMainLayout);
        this.child((Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.expand()));
    }

    @Override
    public void onCosmeticToggle(boolean showCosmeticState) {
        AccessoriesContainingLayout.BaseLayoutGroup baseGroupData = ((RawScrollData)this.layoutData).baseLayoutGroup();
        if (((RawScrollData)this.layoutData).sideBySide) {
            if (showCosmeticState) {
                FlowLayout newLayout = baseGroupData.cosmeticLayout();
                for (i = 0; i < ((RawScrollData)this.layoutData).totalRowCount(); ++i) {
                    ParentComponent newRow = (ParentComponent)newLayout.childById(ParentComponent.class, "row_" + i);
                    ComponentUtils.recursiveSearchSlots(newRow, slotComponent -> this.screen.enableSlot(slotComponent.slot()));
                }
                this.screen.component(FlowLayout.class, "side_by_side_holder").child(0, (Component)newLayout);
            } else {
                FlowLayout prevLayout = baseGroupData.cosmeticLayout();
                for (i = 0; i < ((RawScrollData)this.layoutData).totalRowCount(); ++i) {
                    ParentComponent oldRow = (ParentComponent)prevLayout.childById(ParentComponent.class, "row_" + i);
                    ComponentUtils.recursiveSearchSlots(oldRow, slotComponent -> {
                        this.screen.disableSlot(slotComponent.slot());
                        this.screen.hideSlot(slotComponent.slot());
                    });
                }
                prevLayout.parent().removeChild((Component)prevLayout);
            }
            ParentComponent scrollContainer = (ParentComponent)this.childById(ParentComponent.class, "inner_accessories_container");
            if (scrollContainer instanceof ExtendedScrollContainer) {
                int width = ((RawScrollData)this.layoutData).width();
                if (showCosmeticState) {
                    width = width * 2 + 3;
                }
                scrollContainer.horizontalSizing(Sizing.fixed((int)(width + 8 + 3)));
            }
            this.screen.setupPadding();
        } else {
            Consumer<FlowLayout> childSetter;
            BaseParentComponent container = (BaseParentComponent)this.childById(BaseParentComponent.class, "inner_accessories_container");
            if (container instanceof ExtendedScrollContainer) {
                ExtendedScrollContainer scrollContainer = (ExtendedScrollContainer)container;
                childSetter = layout -> scrollContainer.child((Component)layout);
            } else if (container instanceof FlowLayout) {
                FlowLayout flowLayout = (FlowLayout)container;
                childSetter = component -> {
                    flowLayout.clearChildren();
                    flowLayout.child((Component)component);
                };
            } else {
                return;
            }
            FlowLayout prevLayout = showCosmeticState ? baseGroupData.accessoriesLayout() : baseGroupData.cosmeticLayout();
            for (int i = 0; i < ((RawScrollData)this.layoutData).totalRowCount(); ++i) {
                ParentComponent oldRow = (ParentComponent)prevLayout.childById(ParentComponent.class, "row_" + i);
                ComponentUtils.recursiveSearchSlots(oldRow, slotComponent -> this.screen.disableSlot(slotComponent.slot()));
            }
            FlowLayout newLayout = showCosmeticState ? baseGroupData.cosmeticLayout() : baseGroupData.accessoriesLayout();
            int paddingValue = ((RawScrollData)this.layoutData).showScrollbar() ? 3 : 0;
            newLayout.padding((Boolean)this.screen.getDefaultedData(PlayerOptions.MAIN_WIDGET_POSITION) != false ? Insets.left((int)paddingValue) : Insets.right((int)paddingValue));
            childSetter.accept(newLayout);
            for (int i = 0; i < ((RawScrollData)this.layoutData).totalRowCount(); ++i) {
                ParentComponent newRow = (ParentComponent)newLayout.childById(ParentComponent.class, "row_" + i);
                ComponentUtils.recursiveSearchSlots(newRow, slotComponent -> this.screen.enableSlot(slotComponent.slot()));
            }
        }
        this.updatePadding();
    }

    @Override
    protected Iterable<PositionedRectangle> getAlternativeChecks(boolean showingCosmetics) {
        AccessoriesContainingLayout.BaseLayoutGroup layoutGroup = ((RawScrollData)this.layoutData).baseLayoutGroup();
        Integer min = (Integer)this.alternativeCheckRange.getMinimum();
        Integer max = (Integer)this.alternativeCheckRange.getMaximum();
        return this.getSubList(layoutGroup.getAlternativeChecks(!((RawScrollData)this.layoutData).sideBySide && showingCosmetics), min, max);
    }

    private <T> List<T> getSubList(List<T> list, int fromIndex, int toIndex) {
        if (toIndex >= list.size() || fromIndex == toIndex) {
            return List.of();
        }
        return list.subList(fromIndex, toIndex);
    }

    public record RawScrollData(AccessoriesContainingLayout.BaseLayoutGroup baseLayoutGroup, int totalRowCount, int maxColumnCount, int maxRowCount, int basePadding, boolean sideBySide) implements AccessoriesContainingLayout.LayoutData
    {
        public boolean showScrollbar() {
            return this.totalRowCount > this.maxRowCount;
        }

        @Override
        public int width() {
            return AccessoriesContainingLayout.LayoutData.super.width();
        }
    }
}

