/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands.api.base;

import com.google.common.collect.Range;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import io.wispforest.accessories.commands.api.base.Argument;
import io.wispforest.accessories.commands.api.base.ArgumentBuilderHolder;
import io.wispforest.accessories.commands.api.base.BranchedCommandGenerator;
import io.wispforest.accessories.commands.api.base.CommandGenerator;
import io.wispforest.accessories.commands.api.base.CommandNodeHandler;
import io.wispforest.accessories.commands.api.base.CommandTreeBuilder;
import io.wispforest.accessories.commands.api.core.CommandAddition;
import io.wispforest.accessories.commands.api.core.Key;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public abstract sealed class BaseCommandGenerator<S, B extends CommandTreeBuilder<S, B>>
implements CommandTreeBuilder<S, B>,
CommandNodeHandler<S>
permits CommandGenerator, BranchedCommandGenerator {
    private final Map<String, ArgumentBuilderHolder<S>> baseCommandPart = new LinkedHashMap<String, ArgumentBuilderHolder<S>>();
    private final Map<Key, ArgumentBuilderHolder<S>> commandParts = new LinkedHashMap<Key, ArgumentBuilderHolder<S>>();

    public final void addToCommandsAndClear(BiConsumer<String, ArgumentBuilder<S, ?>> addCallback) {
        this.baseCommandPart.forEach((string, holder) -> addCallback.accept((String)string, holder.addToNode()));
        this.baseCommandPart.clear();
        this.commandParts.clear();
    }

    @Override
    public ArgumentBuilderHolder<S> getOrCreateHolder(List<Argument<?>> args) {
        LinkedHashMap unpackedArgs = new LinkedHashMap();
        Key runningKey = new Key(new String[0]);
        for (Argument<?> arg : args) {
            if (arg instanceof Argument.ArgumentBuilderConstructorList) {
                throw new IllegalStateException("Unable to handle Branch arguments here!");
            }
            Argument.ArgumentBuilderConstructor castedArg = (Argument.ArgumentBuilderConstructor)arg;
            runningKey = runningKey.child(castedArg.name());
            unpackedArgs.put(runningKey, castedArg);
        }
        return this.getNode((Key)unpackedArgs.lastEntry().getKey(), unpackedArgs);
    }

    private ArgumentBuilderHolder<S> getNode(Key key, SequencedMap<Key, Argument.ArgumentBuilderConstructor<?>> unpackedArgs) {
        Key parentKey;
        Argument.ArgumentWithType argumentWithType;
        if (this.commandParts.containsKey(key)) {
            return this.commandParts.get(key);
        }
        Argument.ArgumentBuilderConstructor arg = (Argument.ArgumentBuilderConstructor)unpackedArgs.get(key);
        ArgumentBuilderHolder helper = new ArgumentBuilderHolder(this, key, arg.createNodeBuilder());
        if (arg instanceof Argument.ArgumentWithType && (argumentWithType = (Argument.ArgumentWithType)arg).suggestions() != null) {
            helper.andWith(builder -> ((RequiredArgumentBuilder)builder).suggests(argumentWithType.suggestions()));
        }
        if ((parentKey = key.parent()) == null) {
            this.baseCommandPart.put(key.topPath(), helper);
        } else {
            this.getNode(parentKey, unpackedArgs).andWith(builder -> builder.then(helper.addToNode()));
        }
        this.commandParts.put(key, helper);
        return helper;
    }

    @Override
    public B leaves(List<Argument<?>> startingArgs, List<Argument<?>> commandArgs, CommandAddition<S> commandAddition) {
        ArgumentBuilderHolder<S> rootNodeHelper = this.getOrCreateHolder(startingArgs);
        if (commandArgs.isEmpty()) {
            rootNodeHelper.andWith(commandAddition);
            return (B)this.getThis();
        }
        commandArgs = new ArrayList<Argument<Object>>(commandArgs);
        SequencedMap<Key, ArgumentBuilderHolder<S>> baseBranchEnds = new LinkedHashMap<Key, ArgumentBuilderHolder<S>>(Map.of(rootNodeHelper.key(), rootNodeHelper));
        List<Argument.ArgumentBuilderConstructorList> branchArgs = commandArgs.stream().filter(argument -> argument instanceof Argument.ArgumentBuilderConstructorList).map(constructor -> (Argument.ArgumentBuilderConstructorList)((Object)constructor)).toList();
        if (!branchArgs.isEmpty()) {
            List allOptionalArgs = commandArgs.stream().filter(argumentGetter -> {
                if (argumentGetter instanceof Argument.ArgumentBuilderConstructor) {
                    Argument.ArgumentBuilderConstructor constructor = (Argument.ArgumentBuilderConstructor)argumentGetter;
                    return constructor.defaulted();
                }
                return false;
            }).map(constructor -> (Argument.ArgumentBuilderConstructor)constructor).collect(Collectors.toList());
            LinkedHashMap<Argument.ArgumentBuilderConstructorList, Range> branchToArgRange = new LinkedHashMap<Argument.ArgumentBuilderConstructorList, Range>();
            int lastBranchIndex = 0;
            for (Argument.ArgumentBuilderConstructorList argumentBuilderConstructorList : branchArgs) {
                int n = commandArgs.indexOf(argumentBuilderConstructorList);
                if (n == -1) {
                    throw new IllegalArgumentException("Unable to get branch arg in the command args list: " + String.valueOf(argumentBuilderConstructorList));
                }
                branchToArgRange.put(argumentBuilderConstructorList, Range.closedOpen((Comparable)Integer.valueOf(lastBranchIndex), (Comparable)Integer.valueOf(n)));
                lastBranchIndex = n + 1;
            }
            Range currentRange = null;
            for (Map.Entry entry : branchToArgRange.entrySet()) {
                Range range = (Range)entry.getValue();
                List<Argument.ArgumentBuilderConstructor<Object>> requiredArgs = ((Integer)range.lowerEndpoint()).equals(range.upperEndpoint()) ? List.of() : commandArgs.subList((Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint()).stream().map(argumentGetter -> (Argument.ArgumentBuilderConstructor)argumentGetter).toList();
                currentRange = range;
                baseBranchEnds = this.buildBranchEnds(baseBranchEnds, (Argument.ArgumentBuilderConstructorList)entry.getKey(), requiredArgs);
            }
            try {
                commandArgs = commandArgs.subList((Integer)currentRange.upperEndpoint() + 1, commandArgs.size());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                commandArgs = List.of();
            }
            List<Argument.ArgumentBuilderConstructor> list = commandArgs.stream().filter(argumentGetter -> {
                if (argumentGetter instanceof Argument.ArgumentBuilderConstructor) {
                    Argument.ArgumentBuilderConstructor constructor = (Argument.ArgumentBuilderConstructor)argumentGetter;
                    return constructor.defaulted();
                }
                return false;
            }).map(constructor -> (Argument.ArgumentBuilderConstructor)constructor).toList();
            allOptionalArgs.removeAll(list);
            commandArgs.addAll(0, allOptionalArgs);
        }
        if (commandArgs.isEmpty()) {
            baseBranchEnds.forEach((key1, baseBranchEnd) -> baseBranchEnd.andWith(commandAddition));
        } else {
            List<Argument.ArgumentBuilderConstructor> singleArgs = commandArgs.stream().filter(argumentGetter -> argumentGetter instanceof Argument.ArgumentBuilderConstructor).map(constructor -> (Argument.ArgumentBuilderConstructor)constructor).toList();
            List<Argument.ArgumentBuilderConstructor> requiredArgs = singleArgs.stream().filter(argument -> !argument.defaulted()).toList();
            List<Argument.ArgumentBuilderConstructor> optionalArgs = singleArgs.stream().filter(Argument.ArgumentBuilderConstructor::defaulted).toList();
            baseBranchEnds.forEach((key1, baseBranchEnd) -> {
                ArgumentBuilderHolder baseHelper = this.getOrCreateHolder((Key)key1, (List<Argument<?>>)requiredArgs);
                if (!optionalArgs.isEmpty()) {
                    ArrayList optionalArgStack = new ArrayList();
                    for (Argument.ArgumentBuilderConstructor optionalArg : optionalArgs) {
                        optionalArgStack.add(optionalArg);
                        baseHelper.getOrCreateChild(optionalArgStack).andWith(commandAddition);
                    }
                }
                baseHelper.andWith(commandAddition);
            });
        }
        return (B)this.getThis();
    }

    private SequencedMap<Key, ArgumentBuilderHolder<S>> buildBranchEnds(SequencedMap<Key, ArgumentBuilderHolder<S>> currentBranchEnds, Argument.ArgumentBuilderConstructorList argBuilderList, List<Argument.ArgumentBuilderConstructor<?>> args) {
        LinkedHashMap baseBranchEnds = new LinkedHashMap();
        for (ArgumentBuilderHolder baseBranchEnd : currentBranchEnds.values()) {
            ArgumentBuilderHolder newBaseBranchEnd = baseBranchEnd.getOrCreateChild(args.stream().filter(arg -> !arg.defaulted()).toList());
            baseBranchEnds.put(newBaseBranchEnd.key(), newBaseBranchEnd);
        }
        LinkedHashMap<Key, ArgumentBuilderHolder<S>> finalBranchEnds = new LinkedHashMap<Key, ArgumentBuilderHolder<S>>();
        if (argBuilderList.builders().isEmpty()) {
            finalBranchEnds.putAll(baseBranchEnds);
        } else {
            for (ArgumentBuilderHolder baseBranchEnd : baseBranchEnds.values()) {
                for (Argument.ArgumentBuilderConstructor argumentBuilderConstructor : argBuilderList.builders()) {
                    ArgumentBuilderHolder newBranchEnd = baseBranchEnd.getOrCreateChild(List.of(argumentBuilderConstructor));
                    finalBranchEnds.put(newBranchEnd.key(), newBranchEnd);
                }
            }
        }
        return finalBranchEnds;
    }
}

