/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands.api.core;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ContextAwareLiteralArgumentBuilder<S>
extends LiteralArgumentBuilder<S> {
    public static final String literalStackKey = "accessories:literal_stack";
    private static final DynamicCommandExceptionType INCORRECT_COMMAND_LITERAL_STACK = new DynamicCommandExceptionType(object -> () -> object != null ? "Invalid command literal stack argument as its currently: " + ((ParsedArgument)object).getResult().toString() : "Invalid command literal stack argument as its currently empty!");

    protected ContextAwareLiteralArgumentBuilder(String literal) {
        super(literal);
    }

    public static <S> ContextAwareLiteralArgumentBuilder<S> literal(String name) {
        return new ContextAwareLiteralArgumentBuilder<S>(name);
    }

    public static <S> String getBranch(CommandContext<S> ctx) throws CommandSyntaxException {
        try {
            ParsedArgument argument = (ParsedArgument)ctx.getArgument(literalStackKey, ParsedArgument.class);
            if (!(argument instanceof ParsedArgument)) {
                throw INCORRECT_COMMAND_LITERAL_STACK.create((Object)argument);
            }
            return (String)argument.getResult();
        }
        catch (Exception e) {
            throw INCORRECT_COMMAND_LITERAL_STACK.create(null);
        }
    }

    public static <S> Optional<LiteralArgumentBuilder<S>> builderFromNode(CommandNode<S> node) {
        if (node instanceof ContextedLiteralCommandNode) {
            ContextedLiteralCommandNode node1 = (ContextedLiteralCommandNode)node;
            return Optional.of(ContextAwareLiteralArgumentBuilder.literal(node1.getLiteral()));
        }
        return Optional.empty();
    }

    public LiteralCommandNode<S> build() {
        ContextedLiteralCommandNode result = new ContextedLiteralCommandNode(this.getLiteral(), this.getCommand(), this.getRequirement(), this.getRedirect(), this.getRedirectModifier(), this.isFork());
        for (CommandNode argument : this.getArguments()) {
            result.addChild(argument);
        }
        return result;
    }

    public String getLiteral() {
        return super.getLiteral();
    }

    static class ContextedLiteralCommandNode<S>
    extends LiteralCommandNode<S> {
        public ContextedLiteralCommandNode(String literal, Command<S> command, Predicate<S> requirement, CommandNode<S> redirect, RedirectModifier<S> modifier, boolean forks) {
            super(literal, command, requirement, redirect, modifier, forks);
        }

        public String getLiteral() {
            return super.getLiteral();
        }

        public void parse(StringReader reader, CommandContextBuilder<S> contextBuilder) throws CommandSyntaxException {
            super.parse(reader, contextBuilder);
            StringRange range = ((ParsedCommandNode)contextBuilder.getNodes().getLast()).getRange();
            ParsedArgumentStack parsedArg = (ParsedArgumentStack)((Object)contextBuilder.getArguments().get(ContextAwareLiteralArgumentBuilder.literalStackKey));
            if (parsedArg == null) {
                parsedArg = new ParsedArgumentStack();
            } else if (!(parsedArg instanceof ParsedArgumentStack)) {
                throw INCORRECT_COMMAND_LITERAL_STACK.create(parsedArg);
            }
            parsedArg.add(new ParsedArgument(range.getStart(), range.getEnd(), (Object)this.getLiteral()));
            contextBuilder.withArgument(ContextAwareLiteralArgumentBuilder.literalStackKey, parsedArg);
        }

        public LiteralArgumentBuilder<S> createBuilder() {
            ContextAwareLiteralArgumentBuilder builder = ContextAwareLiteralArgumentBuilder.literal(this.getLiteral());
            builder.requires(this.getRequirement());
            builder.forward(this.getRedirect(), this.getRedirectModifier(), this.isFork());
            if (this.getCommand() != null) {
                builder.executes(this.getCommand());
            }
            return builder;
        }
    }

    static class ParsedArgumentStack<S, T>
    extends ParsedArgument<S, ParsedArgument<S, T>> {
        public final Deque<ParsedArgument<S, T>> argumentStack = new ArrayDeque<ParsedArgument<S, T>>();

        public ParsedArgumentStack() {
            super(0, 0, null);
        }

        public StringRange getRange() {
            if (this.argumentStack.isEmpty()) {
                return new StringRange(0, 0);
            }
            return this.argumentStack.peek().getRange();
        }

        public ParsedArgument<S, T> getResult() {
            if (this.argumentStack.isEmpty()) {
                return null;
            }
            return this.pollFirst();
        }

        public void add(ParsedArgument<S, T> argument) {
            this.argumentStack.add(argument);
        }

        public ParsedArgument<S, T> pollFirst() {
            return this.argumentStack.pollFirst();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParsedArgumentStack)) {
                return false;
            }
            ParsedArgumentStack that = (ParsedArgumentStack)((Object)o);
            return Objects.equals(this.argumentStack, that.argumentStack);
        }

        public int hashCode() {
            return this.argumentStack.hashCode();
        }
    }
}

