/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.data.api.EndecDataLoader;
import io.wispforest.accessories.data.api.SyncedDataHelper;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.impl.slot.StrictMode;
import io.wispforest.accessories.pond.ReplaceableJsonResourceReloadListener;
import io.wispforest.accessories.utils.CollectionUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EntitySlotLoader
extends EndecDataLoader<RawEnityBinding>
implements SyncedDataHelper<SequencedMap<class_1299<?>, List<String>>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EntitySlotLoader INSTANCE = new EntitySlotLoader();
    private Map<class_6862<class_1299<?>>, Map<String, SlotType>> tagToBoundSlots = new HashMap();
    private Map<class_1299<?>, Map<String, SlotType>> entityToBoundSlots = new HashMap();
    private SequencedMap<class_1299<?>, SequencedMap<String, SlotType>> server = new LinkedHashMap();
    private SequencedMap<class_1299<?>, SequencedMap<String, SlotType>> client = new LinkedHashMap();

    protected EntitySlotLoader() {
        super(Accessories.of("entity_slot_loader"), "accessories/entity", RawEnityBinding.ENDEC, class_3264.field_14190, Set.of(SlotTypeLoader.INSTANCE.getId()));
        ReplaceableJsonResourceReloadListener.toggleValue(this);
    }

    public static Map<String, SlotType> getEntitySlots(class_1309 livingEntity) {
        return EntitySlotLoader.getEntitySlots(livingEntity.method_73183(), livingEntity.method_5864());
    }

    public static Map<String, SlotType> getEntitySlots(class_1937 level, class_1299<?> entityType) {
        Map<String, SlotType> map = INSTANCE.getSlotTypes(level.method_8608(), entityType);
        return map != null ? map : Map.of();
    }

    @Nullable
    public final Map<String, SlotType> getSlotTypes(boolean isClientSide, class_1299<?> entityType) {
        return this.getEntitySlotData(isClientSide).get(entityType);
    }

    @ApiStatus.Internal
    public final Map<class_1299<?>, Map<String, SlotType>> getEntitySlotData(boolean isClientSide) {
        return isClientSide ? this.client : this.server;
    }

    @Override
    public Endec<SequencedMap<class_1299<?>, List<String>>> syncDataEndec() {
        return Endec.map(LinkedHashMap::new, type -> class_7923.field_41177.method_10221(type).toString(), strType -> (class_1299)class_7923.field_41177.method_63535(class_2960.method_60654((String)strType)), (Endec)Endec.STRING.listOf());
    }

    @Override
    public void onReceivedData(SequencedMap<class_1299<?>, List<String>> data) {
        LinkedHashMap<class_1299, LinkedHashMap<String, SlotType>> entitySlotTypes = new LinkedHashMap<class_1299, LinkedHashMap<String, SlotType>>();
        for (Map.Entry entry : data.entrySet()) {
            LinkedHashMap<String, SlotType> map = ((List)entry.getValue()).stream().map(string -> SlotTypeLoader.INSTANCE.getSlotType(true, (String)string)).collect(CollectionUtils.toLinkedMap(SlotType::name));
            entitySlotTypes.put((class_1299)entry.getKey(), map);
        }
        this.client = Collections.unmodifiableSequencedMap(entitySlotTypes);
        AccessoriesHolderImpl.clearValidationCache(true);
    }

    @Override
    public SequencedMap<class_1299<?>, List<String>> getServerData() {
        LinkedHashMap entitySlots = new LinkedHashMap();
        for (Map.Entry entry : this.server.entrySet()) {
            entitySlots.put((class_1299)entry.getKey(), List.copyOf(((SequencedMap)entry.getValue()).keySet()));
        }
        return entitySlots;
    }

    public void buildEntryMap() {
        LinkedHashMap<class_1299, SequencedMap> tempMap = new LinkedHashMap<class_1299, SequencedMap>();
        this.tagToBoundSlots.forEach((entityTag, slots) -> {
            Set entityTypes = class_7923.field_41177.method_46733(entityTag).map(holders -> holders.method_40239().map(class_6880::comp_349).collect(Collectors.toSet())).orElseGet(() -> {
                LOGGER.warn("[EntitySlotLoader]: Unable to locate the given EntityType Tag used within a slot entry: [Location: {}]", (Object)entityTag.comp_327());
                return Set.of();
            });
            entityTypes.forEach(entityType -> tempMap.computeIfAbsent((class_1299)entityType, entityType1 -> new LinkedHashMap()).putAll(slots));
        });
        this.entityToBoundSlots.forEach((entityType, slots) -> tempMap.computeIfAbsent((class_1299)entityType, entityType1 -> new LinkedHashMap()).putAll(slots));
        LinkedHashMap finishMap = new LinkedHashMap();
        tempMap.forEach((entityType, slotsBuilder) -> finishMap.put((class_1299<?>)entityType, (SequencedMap<String, SlotType>)Collections.unmodifiableSequencedMap(slotsBuilder)));
        this.server = finishMap;
        AccessoriesHolderImpl.clearValidationCache(false);
        this.tagToBoundSlots.clear();
        this.entityToBoundSlots.clear();
    }

    protected void apply(Map<class_2960, RawEnityBinding> rawData, class_3300 resourceManager, class_3695 profiler) {
        Map allSlotTypes = SlotTypeLoader.INSTANCE.getEntries(false);
        this.tagToBoundSlots.clear();
        this.entityToBoundSlots.clear();
        for (Map.Entry<class_2960, RawEnityBinding> entry : rawData.entrySet()) {
            class_2960 location = entry.getKey();
            RawEnityBinding rawEnityBinding = entry.getValue();
            LinkedHashMap slots = new LinkedHashMap();
            rawEnityBinding.slotTypes().stream().map(slotName -> Pair.of((Object)slotName, (Object)((SlotType)allSlotTypes.get(Accessories.parseLocationOrDefault(slotName))))).forEach(slotInfo -> {
                SlotType slotType = (SlotType)slotInfo.right();
                if (slotType != null) {
                    if (!ExtraSlotTypeProperties.getProperty((String)slotInfo.left(), false).strictMode().equals((Object)StrictMode.FULL)) {
                        slots.put(slotType.name(), slotType);
                    } else {
                        LOGGER.warn("Unable to add the given slot [{}] to the given group due to it being in strict mode! [Location: {}]", slotInfo.left(), (Object)location);
                    }
                } else if (slotType == null) {
                    LOGGER.warn("Unable to locate a given slot [{}] to add to a given entity('s) as it was not registered: [Location: {}]", slotInfo.first(), (Object)location);
                }
            });
            rawEnityBinding.entityTargets().forEach(string -> {
                if (string.contains("#")) {
                    class_2960 entityTypeTagLocation = class_2960.method_12829((String)string.replace("#", ""));
                    class_6862 entityTypeTag = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)entityTypeTagLocation);
                    this.tagToBoundSlots.computeIfAbsent(entityTypeTag, entityTag -> new HashMap()).putAll(slots);
                } else {
                    Optional.ofNullable(class_2960.method_12829((String)string)).flatMap(arg_0 -> ((class_7922)class_7923.field_41177).method_17966(arg_0)).ifPresentOrElse(entityType -> this.entityToBoundSlots.computeIfAbsent((class_1299<?>)entityType, entityType1 -> new HashMap()).putAll(slots), () -> LOGGER.warn("[EntitySlotLoader]: Unable to locate the given EntityType [{}] within the registries for a slot entry: [Location: {}]", string, (Object)location));
                }
            });
        }
        for (Map.Entry<Object, Object> entry : UniqueSlotHandling.getSlotToEntities().entrySet()) {
            SlotType slotType = (SlotType)SlotTypeLoader.INSTANCE.getEntries(false).get(Accessories.parseLocationOrDefault((String)entry.getKey()));
            for (class_1299 entityType : (Set)entry.getValue()) {
                this.entityToBoundSlots.computeIfAbsent(entityType, entityType1 -> new LinkedHashMap()).put(slotType.name(), slotType);
            }
        }
    }

    public record RawEnityBinding(Set<String> entityTargets, Set<String> slotTypes) {
        public static final StructEndec<RawEnityBinding> ENDEC = StructEndecBuilder.of((StructField)Endec.STRING.setOf().fieldOf("entities", RawEnityBinding::entityTargets), (StructField)Endec.STRING.setOf().fieldOf("slots", RawEnityBinding::slotTypes), RawEnityBinding::new);
    }
}

