/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.events.DropRule;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.compat.config.SlotAmountModifier;
import io.wispforest.accessories.data.OperationType;
import io.wispforest.accessories.data.api.ManagedEndecDataLoader;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.impl.slot.SlotTypeImpl;
import io.wispforest.accessories.impl.slot.StrictMode;
import io.wispforest.accessories.pond.ReplaceableJsonResourceReloadListener;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7923;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SlotTypeLoader
extends ManagedEndecDataLoader<SlotType, RawSlotData> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final SlotTypeLoader INSTANCE = new SlotTypeLoader();
    private final Map<class_1299<?>, Collection<SlotType>> slotUsedByRegistryItemCache_server = new HashMap();
    private final Map<class_1299<?>, Collection<SlotType>> slotUsedByRegistryItemCache_client = new HashMap();

    protected SlotTypeLoader() {
        super(Accessories.of("slot_loader"), "accessories/slot", SlotTypeImpl.ENDEC, RawSlotData.ENDEC, class_3264.field_14190);
        ReplaceableJsonResourceReloadListener.toggleValue(this);
    }

    @Nullable
    public static SlotType getSlotType(class_1309 entity, String slotName) {
        return SlotTypeLoader.getSlotType(entity.method_73183(), slotName);
    }

    @Nullable
    public static SlotType getSlotType(class_1937 level, String slotName) {
        return INSTANCE.getSlotType(level.method_8608(), slotName);
    }

    @Nullable
    public SlotType getSlotType(boolean isClientSide, String slotName) {
        return (SlotType)this.getEntry(Accessories.parseLocationOrDefault(slotName), isClientSide);
    }

    private static Map<class_1299<?>, Collection<SlotType>> getUsedSlots(boolean isClientSide) {
        return isClientSide ? SlotTypeLoader.INSTANCE.slotUsedByRegistryItemCache_client : SlotTypeLoader.INSTANCE.slotUsedByRegistryItemCache_server;
    }

    public static Collection<SlotType> getUsedSlotsByRegistryItem(class_1309 living) {
        Map<class_1299<?>, Collection<SlotType>> map = SlotTypeLoader.getUsedSlots(living.method_73183().method_8608());
        if (map.containsKey(living.method_5864())) {
            return map.get(living.method_5864());
        }
        LinkedHashSet<SlotType> validSlotTypes = new LinkedHashSet<SlotType>();
        class_7923.field_41178.forEach(item -> {
            class_1799 stack = item.method_7854();
            Collection<SlotType> validSlots = SlotPredicateRegistry.getStackSlotTypes(living, stack);
            validSlotTypes.addAll(validSlots);
        });
        map.put(living.method_5864(), validSlotTypes);
        return validSlotTypes;
    }

    @Override
    protected void onSync() {
        this.slotUsedByRegistryItemCache_client.clear();
        UniqueSlotHandling.buildClientSlotReferences();
    }

    @Override
    public Map<class_2960, SlotType> mapFrom(Map<class_2960, RawSlotData> rawData) {
        LinkedHashMap uniqueSlots = new LinkedHashMap();
        try {
            UniqueSlotHandling.gatherUniqueSlots((TriFunction<class_2960, Integer, Collection<class_2960>, SlotTypeReference>)((TriFunction)(location, integer, slotPredicates) -> {
                String name = location.toString();
                if (uniqueSlots.containsKey(name)) {
                    throw new IllegalStateException("Unable to register the given unique slot as a existing slot has been registered before! [Name: " + name + "]");
                }
                SlotBuilder builder = new SlotBuilder(name);
                builder.amount((int)integer);
                uniqueSlots.put(name, builder);
                slotPredicates.forEach(builder::validator);
                return () -> name;
            }));
        }
        catch (Exception e) {
            LOGGER.error("[SlotTypeLoader]: Error occurred when trying to gather unique slots though code!", (Throwable)e);
        }
        LinkedHashMap<String, SlotBuilder> builders = new LinkedHashMap<String, SlotBuilder>(uniqueSlots);
        for (Map.Entry<class_2960, RawSlotData> resourceEntry : rawData.entrySet()) {
            Integer amount;
            class_2960 location2 = resourceEntry.getKey();
            RawSlotData rawSlotData = resourceEntry.getValue();
            String[] pathParts = location2.method_12832().split("/");
            String slotName = pathParts[pathParts.length - 1];
            String namespace = pathParts.length > 1 ? pathParts[0] + ":" : "";
            SlotBuilder slotBuilder2 = builders.computeIfAbsent(namespace + slotName, SlotBuilder::new);
            slotBuilder2.icon(rawSlotData.icon());
            slotBuilder2.order(rawSlotData.order());
            if (ExtraSlotTypeProperties.getProperty(slotBuilder2.name, false).allowResizing() && (amount = rawSlotData.amount) != null) {
                OperationType operation = rawSlotData.operationType;
                boolean operationOccured = true;
                if (operation != null) {
                    OperationType operationType = operation;
                    int n = 0;
                    switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"SET", "ADD", "SUB"}, (OperationType)operationType, n)) {
                        case 0: {
                            slotBuilder2.amount(amount);
                            break;
                        }
                        case 1: {
                            slotBuilder2.addAmount(amount);
                            break;
                        }
                        case 2: {
                            slotBuilder2.subtractAmount(amount);
                            break;
                        }
                        default: {
                            operationOccured = false;
                        }
                    }
                }
                if (!operationOccured) {
                    LOGGER.error("Unable to understand the passed operation for the given slot type file! [Location: {}, Operation: {}]", (Object)location2, (Object)operation);
                }
            }
            if (ExtraSlotTypeProperties.getProperty(slotBuilder2.name, false).strictMode().equals((Object)StrictMode.NONE) && rawSlotData.validators() != null) {
                for (class_2960 validator : rawSlotData.validators()) {
                    slotBuilder2.validator(validator);
                }
            }
            slotBuilder2.dropRule(rawSlotData.dropRule());
            builders.put(slotBuilder2.name, slotBuilder2);
        }
        HashMap<class_2960, SlotType> tempMap = new HashMap<class_2960, SlotType>();
        for (SlotAmountModifier modifier : Accessories.config().modifiers()) {
            SlotBuilder builder = builders.getOrDefault(modifier.slotType, null);
            if (builder == null) continue;
            builder.addAmount(modifier.amount);
        }
        builders.forEach((s, slotBuilder) -> {
            if (s.equals("any")) {
                return;
            }
            tempMap.put(Accessories.parseLocationOrDefault(s), slotBuilder.create());
        });
        this.slotUsedByRegistryItemCache_server.clear();
        return tempMap;
    }

    public record RawSlotData(@Nullable class_2960 icon, @Nullable Integer order, @Nullable Integer amount, @Nullable OperationType operationType, @Nullable Set<class_2960> validators, @Nullable DropRule dropRule) {
        public static final StructEndec<RawSlotData> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.optionalFieldOf("icon", RawSlotData::icon, () -> null), (StructField)Endec.INT.optionalFieldOf("order", RawSlotData::order, () -> null), (StructField)Endec.INT.optionalFieldOf("amount", RawSlotData::amount, () -> null), (StructField)EndecUtils.forEnum(OperationType.class).optionalFieldOf("operation", RawSlotData::operationType, () -> null), (StructField)MinecraftEndecs.IDENTIFIER.setOf().optionalFieldOf("validators", RawSlotData::validators, () -> null), (StructField)EndecUtils.forEnum(DropRule.class).optionalFieldOf("dropRule", RawSlotData::dropRule, () -> null), RawSlotData::new);
    }

    public static class SlotBuilder {
        private final String name;
        private class_2960 icon = null;
        private Integer order = null;
        public Integer baseAmount = null;
        private Integer offsetAmount = 0;
        private final Set<class_2960> validators = new HashSet<class_2960>();
        private DropRule dropRule = null;
        private Optional<String> alternativeTranslation = Optional.empty();

        public SlotBuilder(String name) {
            this.name = name;
        }

        public SlotBuilder alternativeTranslation(String value) {
            this.alternativeTranslation = Optional.of(value);
            return this;
        }

        public SlotBuilder icon(class_2960 value) {
            if (value != null) {
                this.icon = value;
            }
            return this;
        }

        public SlotBuilder order(Integer value) {
            if (value != null) {
                this.order = value;
            }
            return this;
        }

        public SlotBuilder amount(int value) {
            this.baseAmount = value;
            return this;
        }

        public SlotBuilder addAmount(int value) {
            this.offsetAmount = this.offsetAmount + value;
            return this;
        }

        public SlotBuilder subtractAmount(int value) {
            this.offsetAmount = this.offsetAmount - value;
            return this;
        }

        public SlotBuilder validator(class_2960 validator) {
            this.validators.add(validator);
            return this;
        }

        public SlotBuilder dropRule(DropRule value) {
            if (value != null) {
                this.dropRule = value;
            }
            return this;
        }

        public SlotType create() {
            if (this.validators.isEmpty()) {
                this.validators.add(Accessories.of("tag"));
                this.validators.add(Accessories.of("component"));
            }
            Integer defaultedBaseAmount = Optional.ofNullable(this.baseAmount).map(i -> Math.max(i, 0)).orElse(1);
            defaultedBaseAmount = this.offsetAmount + defaultedBaseAmount;
            return new SlotTypeImpl(this.name, this.alternativeTranslation, Optional.ofNullable(this.icon).orElse(SlotType.EMPTY_SLOT_ICON), Optional.ofNullable(this.order).orElse(1000), defaultedBaseAmount, this.validators, Optional.ofNullable(this.dropRule).orElse(DropRule.DEFAULT));
        }
    }
}

