/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.caching;

import com.google.common.cache.Cache;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.core.AccessoryNestUtils;
import io.wispforest.accessories.api.equip.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.caching.EquipmentLookupCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class AccessoriesContainerLookupCache
extends EquipmentLookupCache {
    private final AccessoriesContainer container;
    private boolean isEmpty = true;

    public AccessoriesContainerLookupCache(AccessoriesContainer container) {
        this.container = container;
    }

    @Override
    public boolean isEquipped(ItemStackBasedPredicate predicate) {
        Boolean value;
        if (this.isEmpty) {
            this.isEmpty = false;
        }
        if ((value = (Boolean)this.isEquipped.getIfPresent((Object)predicate)) == null) {
            value = this.getAllEquipped().stream().anyMatch(slotEntryReference -> predicate.test(slotEntryReference.stack()));
            this.isEquipped.put((Object)predicate, (Object)value);
        }
        return value;
    }

    @Override
    @Nullable
    public SlotEntryReference firstEquipped(ItemStackBasedPredicate predicate, EquipmentChecking check) {
        Cache cache;
        Optional value;
        if (this.isEmpty) {
            this.isEmpty = false;
        }
        if ((value = (Optional)(cache = check == EquipmentChecking.ACCESSORIES_ONLY ? this.firstEquipped_ACCESSORIES_ONLY : this.firstEquipped_COSMETICALLY_OVERRIDABLE).getIfPresent((Object)predicate)) == null) {
            value = this.container.getAccessories().foreach((i, stack) -> {
                SlotEntryReference entryReference;
                class_1799 cosmetic;
                SlotReference reference = this.container.createReference((int)i);
                if (check == EquipmentChecking.COSMETICALLY_OVERRIDABLE && !(cosmetic = this.container.getCosmeticAccessories().method_5438(reference.index())).method_7960() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                    stack = cosmetic;
                }
                return (entryReference = AccessoryNestUtils.recursivelyHandle(stack, reference, (innerStack, ref) -> !innerStack.method_7960() && predicate.test(innerStack) ? new SlotEntryReference(reference, innerStack) : null)) != null ? Optional.of(entryReference) : null;
            });
            if (value == null) {
                value = Optional.empty();
            }
            cache.put((Object)predicate, value);
        }
        return value.orElse(null);
    }

    @Override
    @Nullable
    public List<SlotEntryReference> getEquipped(ItemStackBasedPredicate predicate) {
        List<SlotEntryReference> value;
        if (this.isEmpty) {
            this.isEmpty = false;
        }
        if ((value = (List<SlotEntryReference>)this.equipped.getIfPresent((Object)predicate)) == null) {
            value = this.getAllEquipped().stream().filter(slotEntryReference -> predicate.test(slotEntryReference.stack())).toList();
            this.equipped.put((Object)predicate, value);
        }
        return value;
    }

    @Override
    public List<SlotEntryReference> getAllEquipped() {
        if (this.isEmpty) {
            this.isEmpty = false;
        }
        if (this.getAllEquipped != null) {
            return this.getAllEquipped;
        }
        ArrayList<SlotEntryReference> currentlyAllEquipped = new ArrayList<SlotEntryReference>();
        this.container.getAccessories().foreach((i, stack) -> {
            if (stack.method_7960()) {
                return;
            }
            SlotReference reference = this.container.createReference((int)i);
            AccessoryNestUtils.recursivelyConsume(stack, reference, (innerStack, ref) -> currentlyAllEquipped.add(new SlotEntryReference((SlotReference)ref, innerStack)));
        });
        this.getAllEquipped = currentlyAllEquipped;
        return currentlyAllEquipped;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.isEmpty = true;
    }
}

