/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesStorage;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.impl.core.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.impl.option.PlayerOption;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import io.wispforest.accessories.utils.BaseContainer;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.accessories.utils.InstanceEndec;
import io.wispforest.accessories.utils.ValidatingForwardingMap;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.util.MapCarrier;
import io.wispforest.endec.util.MapCarrierDecodable;
import io.wispforest.endec.util.MapCarrierEncodable;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5455;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class AccessoriesHolderImpl
implements InstanceEndec {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final MapCarrier EMPTY = new NbtMapCarrier(new class_2487());
    private final Map<String, AccessoriesContainer> slotContainers = new LinkedHashMap<String, AccessoriesContainer>();
    private final Map<String, AccessoriesContainer> slotContainersView = Collections.unmodifiableMap(this.getAllSlotContainers());
    public final List<class_1799> invalidStacks = new ArrayList<class_1799>();
    private final Map<AccessoriesContainer, Boolean> containersRequiringUpdates = new HashMap<AccessoriesContainer, Boolean>();
    private MapCarrierDecodable carrier;
    protected boolean loadedFromTag = false;
    private static final Cache<Integer, Boolean> validatedServerEntities = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(30L)).build();
    private static final Cache<Integer, Boolean> validatedClientEntities = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(30L)).build();
    @Nullable
    private Set<String> validSlotTypes = null;
    @Nullable
    private final Map<String, AccessoriesContainer> validSlotContainers = new ValidatingForwardingMap<String, AccessoriesContainer>(this.slotContainers, String.class, AccessoriesContainer.class, s -> this.validSlotTypes == null || this.validSlotTypes.contains(s), AccessoriesStorage::getSlotName);
    private final OwnerAccessibleReentrantLock currentlyInitializingHolder = new OwnerAccessibleReentrantLock();
    private static final KeyedEndec<Map<String, AccessoriesContainer>> CONTAINERS_KEY = NbtEndec.COMPOUND.xmapWithContext((ctx, containersMap) -> {
        class_1309 entity = ((EntityAttribute)ctx.requireAttributeValue(EntityAttribute.ENTITY)).livingEntity();
        Map<String, AccessoriesContainer> slotContainers = ((ContainersAttribute)ctx.requireAttributeValue(ContainersAttribute.CONTAINERS)).slotContainers();
        List<class_1799> invalidStacks = ((InvalidStacksAttribute)ctx.requireAttributeValue(InvalidStacksAttribute.INVALID_STACKS)).invalidStacks();
        Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots(entity);
        for (String key : containersMap.method_10541()) {
            int i;
            class_2487 containerElement = containersMap.method_68568(key);
            if (containerElement.method_33133()) continue;
            if (slots.containsKey(key)) {
                AccessoriesContainer container = slotContainers.get(key);
                BaseContainer prevAccessories = AccessoriesContainerImpl.copyContainerList(container.getAccessories());
                BaseContainer prevCosmetics = AccessoriesContainerImpl.copyContainerList(container.getCosmeticAccessories());
                ((AccessoriesContainerImpl)container).decode((MapCarrierDecodable)new NbtMapCarrier(containerElement), (SerializationContext)ctx);
                if (prevAccessories.method_5439() <= container.getSize()) continue;
                for (i = container.getSize() - 1; i < prevAccessories.method_5439(); ++i) {
                    class_1799 prevCosmetic;
                    class_1799 prevStack = prevAccessories.method_5438(i);
                    if (!prevStack.method_7960()) {
                        invalidStacks.add(prevStack);
                    }
                    if ((prevCosmetic = prevCosmetics.method_5438(i)).method_7960()) continue;
                    invalidStacks.add(prevCosmetic);
                }
                continue;
            }
            List<BaseContainer> containers = AccessoriesContainerImpl.readContainers(new NbtMapCarrier(containerElement), ctx, AccessoriesContainerImpl.COSMETICS_KEY, AccessoriesContainerImpl.ITEMS_KEY);
            for (BaseContainer simpleContainer : containers) {
                for (i = 0; i < simpleContainer.method_5439(); ++i) {
                    class_1799 stack = simpleContainer.method_5438(i);
                    if (stack.method_7960()) continue;
                    invalidStacks.add(stack);
                }
            }
        }
        return slotContainers;
    }, (ctx, containers) -> {
        class_2487 containerMap = new class_2487();
        containers.forEach((s, container) -> containerMap.method_10566(s, (class_2520)((NbtMapCarrier)class_156.method_654((Object)NbtMapCarrier.of(), innerCarrier -> ((AccessoriesContainerImpl)container).encode((MapCarrierEncodable)innerCarrier, (SerializationContext)ctx))).compoundTag()));
        return containerMap;
    }).keyed("accessories_containers", HashMap::new);

    public boolean loadedFromTag() {
        return this.loadedFromTag;
    }

    public Map<AccessoriesContainer, Boolean> containersRequiringUpdates() {
        return this.containersRequiringUpdates;
    }

    public static AccessoriesHolderImpl of() {
        AccessoriesHolderImpl holder = new AccessoriesHolderImpl();
        holder.loadedFromTag = true;
        holder.carrier = EMPTY;
        return holder;
    }

    @Nullable
    public static AccessoriesHolderImpl getHolder(class_1309 livingEntity) {
        AccessoriesCapability capability = ((AccessoriesLivingEntityExtension)livingEntity).getOrCreateAccessoriesCapability();
        if (capability == null) {
            return null;
        }
        return AccessoriesHolderImpl.getHolder(capability);
    }

    public static AccessoriesHolderImpl getHolder(AccessoriesCapability capability) {
        class_1309 entity = capability.entity();
        AccessoriesHolderImpl holder = AccessoriesInternals.INSTANCE.getHolder(entity);
        if (holder.loadedFromTag) {
            if (entity.method_73183().method_8608()) {
                holder.init(capability);
            } else {
                capability.reset(true);
            }
        } else if (!AccessoriesHolderImpl.isEntitySlotsValid(entity, holder)) {
            holder.init(capability);
        }
        return holder;
    }

    private static boolean isEntitySlotsValid(class_1309 entity, AccessoriesHolderImpl holder) {
        int hash;
        Cache<Integer, Boolean> validEntities = entity.method_73183().method_8608() ? validatedClientEntities : validatedServerEntities;
        Boolean result = (Boolean)validEntities.getIfPresent((Object)(hash = Objects.hash(entity.method_5667(), entity.hashCode())));
        if (result != null) {
            if (result.booleanValue()) {
                return true;
            }
            validEntities.invalidate((Object)hash);
        }
        Map<String, AccessoriesContainer> currentContainers = holder.getSlotContainers();
        Map<String, SlotType> requiredSlotTypes = EntitySlotLoader.getEntitySlots(entity);
        result = currentContainers.size() == requiredSlotTypes.size();
        if (result.booleanValue()) {
            validEntities.put((Object)hash, (Object)true);
        }
        return result;
    }

    public static void clearValidationCache(boolean isClientSide) {
        (isClientSide ? validatedClientEntities : validatedServerEntities).invalidateAll();
    }

    @ApiStatus.Internal
    public Map<String, AccessoriesContainer> getAllSlotContainers() {
        return Collections.unmodifiableMap(this.slotContainers);
    }

    public void setValidTypes(Set<String> validTypes) {
        if (this.currentlyInitializingHolder.isLockedNotByOwner(Thread.currentThread())) {
            return;
        }
        this.validSlotTypes = this.slotContainers.keySet().containsAll(validTypes) ? null : validTypes;
    }

    @ApiStatus.Internal
    public Map<String, AccessoriesContainer> getSlotContainers() {
        return this.validSlotTypes != null ? this.validSlotContainers : this.slotContainersView;
    }

    @Nullable
    public AccessoriesHolderLookupCache getLookupCache() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AccessoriesCapability capability) {
        class_1309 livingEntity = capability.entity();
        Map<String, SlotType> entitySlots = EntitySlotLoader.getEntitySlots(livingEntity);
        if (livingEntity instanceof class_1657 && entitySlots.isEmpty()) {
            LOGGER.warn("It seems the given player has no slots bound to it within a init call, is that desired?");
        }
        this.validSlotTypes = null;
        if (this.currentlyInitializingHolder.isLockedByOwner(Thread.currentThread())) {
            return;
        }
        try {
            this.currentlyInitializingHolder.lock();
            if (this.loadedFromTag) {
                entitySlots.forEach((s, slotType) -> this.slotContainers.putIfAbsent((String)s, new AccessoriesContainerImpl(capability, (SlotType)slotType)));
                SerializationContext ctx = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{new EntityAttribute(livingEntity), RegistriesAttribute.of((class_5455)livingEntity.method_56673())});
                this.read(capability, livingEntity, this.carrier, ctx);
            } else {
                entitySlots.forEach((s, slotType) -> this.slotContainers.put((String)s, new AccessoriesContainerImpl(capability, (SlotType)slotType)));
            }
        }
        finally {
            this.currentlyInitializingHolder.unlock();
        }
        this.setValidTypes(entitySlots.keySet());
    }

    @Override
    public void encode(MapCarrierEncodable carrier, SerializationContext ctx) {
        if (this.slotContainers.isEmpty()) {
            return;
        }
        carrier.put(ctx, CONTAINERS_KEY, this.slotContainers);
    }

    public void read(class_1309 entity, MapCarrier carrier, SerializationContext ctx) {
        this.read(entity.accessoriesCapability(), entity, (MapCarrierDecodable)carrier, ctx);
    }

    public void read(AccessoriesCapability capability, class_1309 entity, MapCarrierDecodable carrier, SerializationContext ctx) {
        this.loadedFromTag = false;
        EndecUtils.dfuKeysCarrier(carrier, Map.of("AccessoriesContainers", "accessories_containers", "CosmeticsShown", "cosmetics_shown", "LinesShown", "lines_shown", "EquipControl", "equip_control"));
        carrier.getWithErrors(ctx.withAttributes(new SerializationAttribute.Instance[]{new ContainersAttribute(this.slotContainers), new InvalidStacksAttribute(this.invalidStacks)}), CONTAINERS_KEY);
        this.setValidTypes(EntitySlotLoader.getEntitySlots(entity).keySet());
        capability.clearCachedSlotModifiers();
        this.carrier = EMPTY;
        AccessoriesHolderLookupCache cache = this.getLookupCache();
        if (cache != null) {
            cache.clearCache();
        }
    }

    private static <F> void setIfPresent(MapCarrierDecodable carrier, AccessoriesPlayerOptionsHolder options, KeyedEndec<F> keyedEndec, PlayerOption<F> option) {
        if (carrier.has(keyedEndec)) {
            options.setData(option, carrier.get(keyedEndec));
        }
    }

    @Override
    public void decode(MapCarrierDecodable carrier, SerializationContext context) {
        this.loadedFromTag = true;
        this.carrier = carrier;
    }

    private static class OwnerAccessibleReentrantLock
    extends ReentrantLock {
        private OwnerAccessibleReentrantLock() {
        }

        @Override
        @Nullable
        public Thread getOwner() {
            return super.getOwner();
        }

        public boolean isLockedNotByOwner(Thread thread) {
            if (!this.isLocked()) {
                return false;
            }
            Thread owner = this.getOwner();
            if (owner == null) {
                return false;
            }
            return owner != thread;
        }

        public boolean isLockedByOwner(Thread thread) {
            if (!this.isLocked()) {
                return false;
            }
            Thread owner = this.getOwner();
            if (owner == null) {
                return false;
            }
            return owner == thread;
        }
    }

    private record EntityAttribute(class_1309 livingEntity) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<EntityAttribute> ENTITY = SerializationAttribute.withValue((String)"entity");

        public SerializationAttribute attribute() {
            return ENTITY;
        }

        public Object value() {
            return this;
        }
    }

    private record ContainersAttribute(Map<String, AccessoriesContainer> slotContainers) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<ContainersAttribute> CONTAINERS = SerializationAttribute.withValue((String)Accessories.translationKey("containers"));

        public SerializationAttribute attribute() {
            return CONTAINERS;
        }

        public Object value() {
            return this;
        }
    }

    private record InvalidStacksAttribute(List<class_1799> invalidStacks) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<InvalidStacksAttribute> INVALID_STACKS = SerializationAttribute.withValue((String)Accessories.translationKey("invalidStacks"));

        public SerializationAttribute attribute() {
            return INVALID_STACKS;
        }

        public Object value() {
            return this;
        }
    }
}

