/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.core;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesLoaderInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.impl.core.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.utils.BaseContainer;
import io.wispforest.accessories.utils.ImmutableContainer;
import io.wispforest.accessories.utils.ItemStackMutation;
import io.wispforest.accessories.utils.ItemStackResize;
import io.wispforest.owo.util.EventSource;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_11343;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ExpandedContainer
extends BaseContainer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AccessoriesContainerImpl container;
    private final String name;
    private final class_2371<class_1799> previousItems;
    private final Int2BooleanMap setFlags = new Int2BooleanArrayMap();
    private boolean canFlagSetCalls = true;
    private boolean newlyConstructed;
    private final Int2ObjectMap<EventSource.Subscription> currentMutationSubscriptions = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<EventSource.Subscription> currentResizeSubscriptions = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<EventSource.Subscription> currentPrevResizeSubscriptions = new Int2ObjectOpenHashMap();

    public ExpandedContainer(AccessoriesContainerImpl container, int size, String name) {
        this(container, size, name, true);
    }

    public ExpandedContainer(AccessoriesContainerImpl container, int size, String name, boolean toggleNewlyConstructed) {
        super(size);
        this.container = container;
        this.addListener(container);
        if (toggleNewlyConstructed) {
            this.newlyConstructed = true;
        }
        this.name = name;
        this.previousItems = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public String name() {
        return this.name;
    }

    public class_1263 toImmutable() {
        return new ImmutableContainer(this.getItems());
    }

    public boolean wasNewlyConstructed() {
        boolean bl = this.newlyConstructed;
        this.newlyConstructed = false;
        return bl;
    }

    public boolean isSlotFlagged(int slot) {
        boolean bl = this.setFlags.getOrDefault(slot, false);
        if (bl) {
            this.setFlags.put(slot, false);
        }
        return bl;
    }

    void toggleFlagablity() {
        this.canFlagSetCalls = !this.canFlagSetCalls;
    }

    private void removeAllSlotSubscription(int slot) {
        this.removeMutationSubscription(slot);
        this.removeResizeSubscription(slot);
        this.removePrevResizeSubscription(slot);
    }

    private void removePrevResizeSubscription(int slot) {
        EventSource.Subscription subscription = (EventSource.Subscription)this.currentPrevResizeSubscriptions.remove(slot);
        if (subscription != null) {
            subscription.cancel();
        }
    }

    private void removeResizeSubscription(int slot) {
        EventSource.Subscription subscription = (EventSource.Subscription)this.currentResizeSubscriptions.remove(slot);
        if (subscription != null) {
            subscription.cancel();
        }
    }

    private void removeMutationSubscription(int slot) {
        EventSource.Subscription subscription = (EventSource.Subscription)this.currentMutationSubscriptions.remove(slot);
        if (subscription != null) {
            subscription.cancel();
        }
    }

    public void setPreviousItem(int slot, class_1799 stack) {
        if (slot >= 0 && slot < this.previousItems.size()) {
            this.previousItems.set(slot, (Object)stack);
            this.removePrevResizeSubscription(slot);
            if (!stack.method_7960()) {
                class_1799 stackCopy = stack.method_7972();
                this.currentPrevResizeSubscriptions.put(slot, (Object)ItemStackResize.getEvent(stack).source().subscribe((stack1, prevSize) -> {
                    boolean isEmpty;
                    boolean bl = isEmpty = stack1.method_7947() <= 0;
                    if (isEmpty) {
                        this.previousItems.set(slot, (Object)stackCopy);
                        this.removePrevResizeSubscription(slot);
                    }
                }));
            }
        }
    }

    public class_1799 getPreviousItem(int slot) {
        return slot >= 0 && slot < this.previousItems.size() ? (class_1799)this.previousItems.get(slot) : class_1799.field_8037;
    }

    public int method_58350(class_1799 itemStack) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(itemStack);
        return Math.min(super.method_58350(itemStack), accessory.maxStackSize(itemStack));
    }

    @Override
    public class_1799 method_5438(int slot) {
        if (!this.validIndex(slot)) {
            return class_1799.field_8037;
        }
        return super.method_5438(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        if (!this.validIndex(slot)) {
            return class_1799.field_8037;
        }
        class_1799 stack = super.method_5434(slot, amount);
        if (!stack.method_7960()) {
            class_1799 prevStack;
            if (this.canFlagSetCalls) {
                this.setFlags.put(slot, true);
            }
            if ((prevStack = this.method_5438(slot)).method_7960()) {
                this.removeMutationSubscription(slot);
                this.removeResizeSubscription(slot);
            }
            this.setPreviousItem(slot, stack);
        }
        return stack;
    }

    @Override
    public class_1799 method_5441(int slot) {
        if (!this.validIndex(slot)) {
            return class_1799.field_8037;
        }
        class_1799 stack = super.method_5441(slot);
        this.removeMutationSubscription(slot);
        this.removeResizeSubscription(slot);
        return stack;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        if (!this.validIndex(slot)) {
            return;
        }
        this.removeMutationSubscription(slot);
        this.removeResizeSubscription(slot);
        super.method_5447(slot, stack);
        if (!stack.method_7960()) {
            this.currentMutationSubscriptions.put(slot, (Object)ItemStackMutation.getEvent(stack).source().subscribe((stack1, types) -> {
                AccessoriesHolderLookupCache cache;
                if (types.contains(AccessoriesDataComponents.ATTRIBUTES) || types.contains(AccessoriesDataComponents.NESTED_ACCESSORIES)) {
                    this.method_5431();
                }
                if (!this.container.capability().entity().method_73183().method_8608() && (cache = AccessoriesHolderImpl.getHolder(this.container.capability()).getLookupCache()) != null) {
                    cache.invalidateLookupData(this.container.getSlotName(), stack1, types);
                }
            }));
            this.currentResizeSubscriptions.put(slot, (Object)ItemStackResize.getEvent(stack).source().subscribe((stack1, prevSize) -> {
                if (stack1.method_7960()) {
                    this.method_5447(slot, class_1799.field_8037);
                }
            }));
        }
        if (this.canFlagSetCalls) {
            this.setFlags.put(slot, true);
        }
    }

    public boolean validIndex(int slot) {
        boolean isValid;
        boolean bl = isValid = slot >= 0 && slot < this.method_5439();
        if (!isValid && AccessoriesLoaderInternals.INSTANCE.isDevelopmentEnv()) {
            String nameInfo = this.name != null ? "Container: " + this.name + ", " : "";
            try {
                throw new IllegalStateException("Access to a given Inventory was found to be out of the range valid for the container! [Name: " + nameInfo + " Index: " + slot + "]");
            }
            catch (Exception e) {
                LOGGER.debug("Full Exception: ", (Throwable)e);
            }
        }
        return isValid;
    }

    @Override
    public void loadItemsFromList(Collection<class_11343> slottedStacks) {
        this.container.containerListenerLock = true;
        AccessoriesCapability capability = this.container.capability();
        ArrayList<class_1799> prevStacks = new ArrayList<class_1799>();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 currentStack = this.method_5438(i);
            prevStacks.add(currentStack);
            this.method_5447(i, class_1799.field_8037);
        }
        ArrayList<class_1799> invalidStacks = new ArrayList<class_1799>();
        ArrayList<class_1799> decodedStacks = new ArrayList<class_1799>();
        for (class_11343 slottedStack : slottedStacks) {
            class_1799 stack = slottedStack.comp_4212();
            decodedStacks.add(stack);
            if (slottedStack.method_71368(this.method_5439())) {
                this.method_5447(slottedStack.comp_4211(), stack);
                continue;
            }
            invalidStacks.add(stack);
        }
        this.container.containerListenerLock = false;
        if (!capability.entity().method_73183().method_8608()) {
            if (!prevStacks.equals(decodedStacks)) {
                this.method_5431();
            }
            AccessoriesHolderImpl.getHolder((AccessoriesCapability)capability).invalidStacks.addAll(invalidStacks);
        }
    }

    public Iterator<class_1799> iterator() {
        return new Iterator<class_1799>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ExpandedContainer.this.method_5439();
            }

            @Override
            public class_1799 next() {
                class_1799 stack = ExpandedContainer.this.method_5438(this.index);
                ++this.index;
                return stack;
            }
        };
    }

    public void foreach(BiConsumer<Integer, class_1799> consumer) {
        int i = 0;
        Iterator<class_1799> iterator = this.iterator();
        while (iterator.hasNext()) {
            class_1799 itemStack = iterator.next();
            consumer.accept(i, itemStack);
            ++i;
        }
    }

    public <T> T foreach(BiFunction<Integer, class_1799, @Nullable T> consumer) {
        int i = 0;
        Iterator<class_1799> iterator = this.iterator();
        while (iterator.hasNext()) {
            class_1799 itemStack = iterator.next();
            T result = consumer.apply(i, itemStack);
            if (result != null) {
                return null;
            }
            ++i;
        }
        return null;
    }

    public void setFromPrev(ExpandedContainer prevContainer) {
        int i = 0;
        Iterator<class_1799> iterator = prevContainer.iterator();
        while (iterator.hasNext()) {
            class_1799 itemStack = iterator.next();
            prevContainer.removeMutationSubscription(i);
            this.setPreviousItem(i, itemStack);
            ++i;
        }
    }

    public void copyPrev(ExpandedContainer prevContainer) {
        for (int i = 0; i < prevContainer.method_5439(); ++i) {
            if (i >= this.method_5439()) continue;
            class_1799 prevItem = prevContainer.getPreviousItem(i);
            prevContainer.removeAllSlotSubscription(i);
            if (prevItem.method_7960()) continue;
            this.setPreviousItem(i, prevItem);
        }
    }
}

