/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.event;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesClientInternals;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryMobEffectsComponent;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNest;
import io.wispforest.accessories.api.core.AccessoryNestUtils;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.equip.EquipAction;
import io.wispforest.accessories.api.events.AccessoryChangeCallback;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.api.events.ContainersChangeCallback;
import io.wispforest.accessories.api.events.DropRule;
import io.wispforest.accessories.api.events.OnDeathCallback;
import io.wispforest.accessories.api.events.OnDropCallback;
import io.wispforest.accessories.api.events.SlotStateChange;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoryAttributeLogic;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.impl.core.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.core.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import io.wispforest.accessories.misc.AccessoriesGameRules;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.SyncContainerData;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.accessories.networking.client.SyncPlayerOptions;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.util.MapCarrierEncodable;
import io.wispforest.owo.serialization.RegistriesAttribute;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AccessoriesEventHandler {
    public static boolean dataReloadOccurred = false;

    public static void onWorldTick(class_1937 level) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        AccessoriesEventHandler.revalidatePlayersOnReload(serverLevel.method_8503().method_3760());
    }

    public static void revalidatePlayersOnReload(class_3324 playerList) {
        if (!dataReloadOccurred) {
            return;
        }
        for (class_3222 player : playerList.method_14571()) {
            AccessoriesEventHandler.revalidatePlayer(player);
        }
        dataReloadOccurred = false;
    }

    public static void revalidatePlayer(class_3222 player) {
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
        if (capability == null) {
            return;
        }
        Collection<SlotType> validSlotTypes = EntitySlotLoader.getEntitySlots((class_1309)player).values();
        AccessoriesHolderImpl holderImpl = AccessoriesHolderImpl.getHolder(capability);
        holderImpl.setValidTypes(validSlotTypes.stream().map(SlotType::name).collect(Collectors.toSet()));
        for (AccessoriesContainer container : holderImpl.getAllSlotContainers().values()) {
            SlotType slotType = container.slotType();
            if (slotType != null && validSlotTypes.contains(slotType)) {
                Integer baseSize = ((AccessoriesContainerImpl)container).getBaseSize();
                if (baseSize == null || baseSize.intValue() != slotType.amount()) {
                    container.markChanged();
                    container.update();
                }
                ExpandedContainer stacks = container.getAccessories();
                ExpandedContainer cosmeticStacks = container.getCosmeticAccessories();
                for (int i = 0; i < container.getSize(); ++i) {
                    SlotReference reference = container.createReference(i);
                    AccessoriesEventHandler.handleInvalidStacks(stacks, reference, player);
                    AccessoriesEventHandler.handleInvalidStacks(cosmeticStacks, reference, player);
                }
                continue;
            }
            ExpandedContainer stacks = container.getAccessories();
            ExpandedContainer cosmeticStacks = container.getCosmeticAccessories();
            for (int i = 0; i < container.getSize(); ++i) {
                SlotReference reference = container.createReference(i);
                AccessoriesEventHandler.dropAndRemoveStack(stacks, reference, player);
                AccessoriesEventHandler.dropAndRemoveStack(cosmeticStacks, reference, player);
            }
        }
    }

    private static void handleInvalidStacks(class_1263 container, SlotReference reference, class_3222 player) {
        boolean bl;
        class_1799 stack = container.method_5438(reference.index());
        if (stack.method_7960()) {
            return;
        }
        boolean bl2 = bl = !SlotPredicateRegistry.canInsertIntoSlot(stack, reference);
        if (bl) {
            AccessoriesEventHandler.dropAndRemoveStack(container, reference, player);
        }
    }

    private static void dropAndRemoveStack(class_1263 container, SlotReference reference, class_3222 player) {
        class_1799 stack = container.method_5438(reference.index());
        container.method_5447(reference.index(), class_1799.field_8037);
        AccessoriesInternals.INSTANCE.giveItemToPlayer(player, stack);
    }

    public static void entityLoad(class_1309 entity, class_1937 level) {
        if (!level.method_8608() || !(entity instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)entity;
        SyncEntireContainer.syncToAllTrackingAndSelf(serverPlayer);
    }

    public static void onTracking(class_1309 entity, class_3222 serverPlayer) {
        SyncEntireContainer.syncTo(entity, packet -> AccessoriesNetworking.sendToPlayer(serverPlayer, packet));
    }

    public static void dataSync(@Nullable class_3324 list, @Nullable class_3222 player) {
        if (list != null && !list.method_14571().isEmpty()) {
            AccessoriesEventHandler.revalidatePlayersOnReload(list);
            for (class_3222 playerEntry : list.method_14571()) {
                AccessoriesCapability capability = AccessoriesCapability.get((class_1309)playerEntry);
                if (capability == null) {
                    return;
                }
                NbtMapCarrier carrier = NbtMapCarrier.of();
                AccessoriesHolderImpl.getHolder(capability).encode((MapCarrierEncodable)carrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)playerEntry.method_51469().method_30349())}));
                AccessoriesNetworking.sendToTrackingAndSelf((class_1297)playerEntry, new SyncEntireContainer(capability.entity().method_5628(), carrier));
                class_1703 class_17032 = playerEntry.field_7512;
                if (!(class_17032 instanceof AccessoriesMenuBase)) continue;
                AccessoriesMenuBase base = (AccessoriesMenuBase)class_17032;
                Accessories.openAccessoriesMenu((class_1657)playerEntry, base.menuVariant(), base.targetEntity());
            }
        } else if (player != null) {
            AccessoriesEventHandler.revalidatePlayer(player);
            AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
            if (capability == null) {
                return;
            }
            NbtMapCarrier carrier = NbtMapCarrier.of();
            AccessoriesHolderImpl.getHolder(capability).encode((MapCarrierEncodable)carrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)player.method_51469().method_30349())}));
            AccessoriesNetworking.sendToPlayer(player, new SyncEntireContainer(capability.entity().method_5628(), carrier));
            AccessoriesNetworking.sendToPlayer(player, new SyncPlayerOptions(AccessoriesPlayerOptionsHolder.getOptions((class_1657)player)));
            class_1703 class_17033 = player.field_7512;
            if (class_17033 instanceof AccessoriesMenuBase) {
                AccessoriesMenuBase base = (AccessoriesMenuBase)class_17033;
                Accessories.openAccessoriesMenu((class_1657)player, base.menuVariant(), base.targetEntity());
            }
        }
        AccessoriesHolderImpl.clearValidationCache(false);
    }

    public static void onLivingEntityTick(class_1309 entity) {
        Object object;
        List<class_1799> invalidStacks;
        AccessoriesHolderImpl holder;
        Object dirtyCosmeticStacks;
        if (entity.method_31481()) {
            return;
        }
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            HashMap<String, class_1799> dirtyStacks = new HashMap<String, class_1799>();
            dirtyCosmeticStacks = new HashMap();
            AccessoryAttributeBuilder removedAttributesBuilder = new AccessoryAttributeBuilder();
            AccessoryAttributeBuilder addedAttributesBuilder = new AccessoryAttributeBuilder();
            for (Map.Entry<String, AccessoriesContainer> containerEntry : AccessoriesHolderImpl.getHolder(capability).getAllSlotContainers().entrySet()) {
                AccessoriesContainer container = containerEntry.getValue();
                ExpandedContainer accessories = container.getAccessories();
                ExpandedContainer cosmetics = container.getCosmeticAccessories();
                for (int i = 0; i < accessories.method_5439(); ++i) {
                    class_1799 lastCosmeticStack;
                    class_1799 currentCosmeticStack;
                    SlotReference slotReference = container.createReference(i);
                    String slotId = container.getSlotName() + "/" + i;
                    class_1799 currentStack = accessories.method_5438(i);
                    if (!currentStack.method_7960()) {
                        currentStack.method_7917(entity.method_73183(), (class_1297)entity, null);
                        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(currentStack);
                        if (accessory != null) {
                            accessory.tick(currentStack, slotReference);
                            AccessoryNestUtils.recursivelyConsume(currentStack, stack -> {
                                AccessoryMobEffectsComponent effects = (AccessoryMobEffectsComponent)stack.method_58694(AccessoriesDataComponents.MOB_EFFECTS);
                                if (effects != null) {
                                    effects.handleReapplyingEffects(entity, entity.method_73183().method_8510());
                                }
                            });
                        }
                    }
                    class_1799 lastStack = accessories.getPreviousItem(i);
                    boolean flagged = accessories.isSlotFlagged(i);
                    if (entity.method_73183().method_8608() || entity.method_29504()) continue;
                    if (!class_1799.method_7973((class_1799)currentStack, (class_1799)lastStack) || flagged) {
                        if (!lastStack.method_7960()) {
                            AccessoryAttributeBuilder removedEnchantmentBuilder = new AccessoryAttributeBuilder(slotReference);
                            class_1890.method_60140((class_1799)lastStack, (class_1304)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot(), (attributeHolder, modifier) -> {
                                String namespace = modifier.comp_2447().method_12836();
                                ArrayList<String> splitPath = new ArrayList<String>(List.of(modifier.comp_2447().method_12832().split("/")));
                                splitPath.removeLast();
                                removedEnchantmentBuilder.addStackable((class_6880<class_1320>)attributeHolder, new class_1322(class_2960.method_60655((String)namespace, (String)String.join((CharSequence)"/", splitPath)), modifier.comp_2449(), modifier.comp_2450()));
                            });
                            removedAttributesBuilder.addFrom(removedEnchantmentBuilder);
                            removedAttributesBuilder.addFrom(AccessoryAttributeLogic.getAttributeModifiers(lastStack, slotReference));
                            ((AccessoriesLivingEntityExtension)entity).pushEnchantmentContext(lastStack, slotReference);
                            class_1890.method_60141((class_1799)lastStack, (class_1309)entity, (class_1304)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot());
                        }
                        if (!currentStack.method_7960()) {
                            AccessoryAttributeBuilder addedEnchantmentBuilder = new AccessoryAttributeBuilder(slotReference);
                            class_1890.method_60140((class_1799)currentStack, (class_1304)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot(), (attributeHolder, modifier) -> {
                                String namespace = modifier.comp_2447().method_12836();
                                ArrayList<String> splitPath = new ArrayList<String>(List.of(modifier.comp_2447().method_12832().split("/")));
                                splitPath.removeLast();
                                addedEnchantmentBuilder.addStackable((class_6880<class_1320>)attributeHolder, new class_1322(class_2960.method_60655((String)namespace, (String)String.join((CharSequence)"/", splitPath)), modifier.comp_2449(), modifier.comp_2450()));
                            });
                            addedAttributesBuilder.addFrom(addedEnchantmentBuilder);
                            addedAttributesBuilder.addFrom(AccessoryAttributeLogic.getAttributeModifiers(currentStack, slotReference));
                            ((AccessoriesLivingEntityExtension)entity).pushEnchantmentContext(currentStack, slotReference);
                            class_1890.method_60125((class_3218)((class_3218)entity.method_73183()), (class_1799)currentStack, (class_1309)entity, (class_1304)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot());
                        }
                        AccessoryNestUtils.recursivelyConsume(lastStack, stack -> {
                            if (stack.method_57826(AccessoriesDataComponents.MOB_EFFECTS)) {
                                ((AccessoryMobEffectsComponent)stack.method_58694(AccessoriesDataComponents.MOB_EFFECTS)).handleRemovingEffects(entity);
                            }
                        });
                        AccessoryNestUtils.recursivelyConsume(currentStack, stack -> {
                            if (stack.method_57826(AccessoriesDataComponents.MOB_EFFECTS)) {
                                ((AccessoryMobEffectsComponent)stack.method_58694(AccessoriesDataComponents.MOB_EFFECTS)).handleApplyingConstantEffects(entity);
                            }
                        });
                        boolean equipmentChange = false;
                        if (!class_1799.method_7984((class_1799)currentStack, (class_1799)lastStack) || flagged) {
                            AccessoryRegistry.getAccessoryOrDefault(lastStack).onUnequip(lastStack, slotReference);
                            AccessoryRegistry.getAccessoryOrDefault(currentStack).onEquip(currentStack, slotReference);
                            if (entity instanceof class_3222) {
                                class_3222 serverPlayer = (class_3222)entity;
                                if (!currentStack.method_7960()) {
                                    Accessories.ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, false);
                                }
                                if (!lastStack.method_7960()) {
                                    Accessories.ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, false);
                                }
                            }
                            equipmentChange = true;
                        }
                        ((AccessoryChangeCallback)AccessoryChangeCallback.EVENT.invoker()).onChange(lastStack, currentStack, slotReference, equipmentChange ? SlotStateChange.REPLACEMENT : SlotStateChange.MUTATION);
                        container.getAccessories().setPreviousItem(i, currentStack);
                        dirtyStacks.put(slotId, currentStack.method_7972());
                        AccessoriesEventHandler.recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastStack), AccessoryNestUtils.getData(currentStack));
                    }
                    if (class_1799.method_7973((class_1799)(currentCosmeticStack = cosmetics.method_5438(i)), (class_1799)(lastCosmeticStack = container.getCosmeticAccessories().getPreviousItem(i)))) continue;
                    cosmetics.setPreviousItem(i, currentCosmeticStack);
                    ((HashMap)dirtyCosmeticStacks).put(slotId, currentCosmeticStack.method_7972());
                    if (!(entity instanceof class_3222)) continue;
                    class_3222 serverPlayer = (class_3222)entity;
                    if (!currentStack.method_7960()) {
                        Accessories.ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, true);
                    }
                    if (lastStack.method_7960()) continue;
                    Accessories.ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, true);
                }
            }
            if (entity.method_73183().method_8608()) {
                return;
            }
            AttributeUtils.removeTransientAttributeModifiers(entity, removedAttributesBuilder);
            AttributeUtils.addTransientAttributeModifiers(entity, addedAttributesBuilder);
            Map<AccessoriesContainer, Boolean> updatedContainers = AccessoriesHolderImpl.getHolder(capability).containersRequiringUpdates();
            capability.updateContainers();
            ((ContainersChangeCallback)ContainersChangeCallback.EVENT.invoker()).onChange(entity, capability, (Map<AccessoriesContainer, Boolean>)ImmutableMap.copyOf(updatedContainers));
            if (!(dirtyStacks.isEmpty() && ((HashMap)dirtyCosmeticStacks).isEmpty() && updatedContainers.isEmpty())) {
                SyncContainerData packet = SyncContainerData.of(entity, updatedContainers.keySet(), dirtyStacks, (Map<String, class_1799>)dirtyCosmeticStacks);
                AccessoriesNetworking.sendToTrackingAndSelf((class_1297)entity, packet);
            }
            updatedContainers.clear();
        }
        if ((holder = AccessoriesInternals.INSTANCE.getHolder(entity)).loadedFromTag() && capability == null) {
            dirtyCosmeticStacks = new AccessoriesCapabilityImpl(entity);
        }
        if (!(invalidStacks = holder.invalidStacks).isEmpty() && (object = entity.method_73183()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)object;
            for (class_1799 invalidStack : invalidStacks) {
                if (entity instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)entity;
                    AccessoriesInternals.INSTANCE.giveItemToPlayer(serverPlayer, invalidStack);
                    continue;
                }
                entity.method_5775(serverLevel, invalidStack);
            }
            invalidStacks.clear();
        }
    }

    private static void recursiveStackChange(SlotReference slotReference, @Nullable AccessoryNestContainerContents lastNestData, @Nullable AccessoryNestContainerContents currentNestData) {
        HashMap currentNestChanges = currentNestData != null ? currentNestData.slotChanges() : new HashMap();
        List lastInnerStacks = lastNestData != null ? List.copyOf(lastNestData.getMap(slotReference).entrySet()) : List.of();
        List currentInnerStacks = currentNestData != null ? List.copyOf(currentNestData.getMap(slotReference).entrySet()) : List.of();
        int maxIterationLength = Math.max(lastInnerStacks.size(), currentInnerStacks.size());
        for (int i = 0; i < maxIterationLength; ++i) {
            SlotEntryReference currentRef;
            Map.Entry lastInnerEntry = i < lastInnerStacks.size() ? (Map.Entry)lastInnerStacks.get(i) : null;
            Map.Entry currentInnerEntry = i < currentInnerStacks.size() ? (Map.Entry)currentInnerStacks.get(i) : null;
            SlotStateChange changeType = currentNestChanges.getOrDefault(i, SlotStateChange.REPLACEMENT);
            if (lastInnerEntry == null && currentInnerEntry != null) {
                currentRef = (SlotEntryReference)currentInnerEntry.getKey();
                class_1799 currentInnerStack = currentRef.stack();
                AccessoriesEventHandler.onStackChange(currentRef.reference(), class_1799.field_8037, currentRef.stack(), changeType);
                AccessoriesEventHandler.recursiveStackChange(slotReference, null, AccessoryNestUtils.getData(currentInnerStack));
                continue;
            }
            if (currentInnerEntry == null && lastInnerEntry != null) {
                SlotEntryReference lastRef = (SlotEntryReference)lastInnerEntry.getKey();
                class_1799 lastInnerStack = lastRef.stack();
                AccessoriesEventHandler.onStackChange(lastRef.reference(), lastRef.stack(), class_1799.field_8037, changeType);
                AccessoriesEventHandler.recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastInnerStack), null);
                continue;
            }
            if (lastInnerEntry == null || currentInnerEntry == null) continue;
            currentRef = (SlotEntryReference)currentInnerEntry.getKey();
            SlotEntryReference lastRef = (SlotEntryReference)lastInnerEntry.getKey();
            SlotReference innerRef = lastRef.reference();
            class_1799 currentInnerStack = currentRef.stack();
            class_1799 lastInnerStack = lastRef.stack();
            AccessoriesEventHandler.onStackChange(innerRef, lastInnerStack, currentInnerStack, changeType);
            AccessoriesEventHandler.recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastInnerStack), AccessoryNestUtils.getData(currentInnerStack));
        }
        currentNestChanges.clear();
    }

    private static void onStackChange(SlotReference slotReference, class_1799 lastStack, class_1799 currentStack, SlotStateChange stateChange) {
        class_1309 class_13092 = slotReference.entity();
        if (class_13092 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            if (!currentStack.method_7960()) {
                Accessories.ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, false);
            }
            if (!lastStack.method_7960()) {
                Accessories.ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, false);
            }
        }
        ((AccessoryChangeCallback)AccessoryChangeCallback.EVENT.invoker()).onChange(lastStack, currentStack, slotReference, stateChange);
    }

    public static void getTooltipData(@Nullable class_1309 entity, class_1799 stack, List<class_2561> tooltip, class_10712 display, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        if (accessory != null) {
            tooltipType = AccessoriesClientInternals.getInstance().createTooltipFlag(tooltipType);
            if (entity != null && AccessoriesCapability.get(entity) != null) {
                AccessoriesEventHandler.addEntityBasedTooltipData(entity, accessory, stack, tooltip, display, tooltipContext, tooltipType);
            }
            accessory.getExtraTooltip(stack, tooltip, tooltipContext, tooltipType);
        }
    }

    private static void addEntityBasedTooltipData(class_1309 entity, Accessory accessory, class_1799 stack, List<class_2561> tooltip, class_10712 display, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        HashSet<SlotType> validSlotTypes = new HashSet<SlotType>(SlotPredicateRegistry.getValidSlotTypes(entity, stack));
        if (validSlotTypes.isEmpty()) {
            return;
        }
        HashSet validUniqueSlots = new HashSet();
        validSlotTypes.removeIf(slotType -> {
            boolean isUnique = UniqueSlotHandling.isUniqueSlot(slotType.name());
            if (isUnique) {
                validUniqueSlots.add(slotType);
            }
            return isUnique;
        });
        Set sharedSlotTypes = SlotTypeLoader.INSTANCE.getEntries(entity.method_73183()).values().stream().filter(slotType -> !UniqueSlotHandling.isUniqueSlot(slotType.name())).collect(Collectors.toSet());
        class_5250 slotInfoComponent = class_2561.method_43470((String)"");
        class_5250 slotsComponent = class_2561.method_43470((String)"");
        boolean allSlots = false;
        if (validSlotTypes.containsAll(sharedSlotTypes)) {
            slotsComponent.method_10852((class_2561)class_2561.method_43471((String)Accessories.translationKey("slot.any")));
            allSlots = true;
        } else {
            Set<SlotType> entitySlotTypes = Set.copyOf(EntitySlotLoader.getEntitySlots(entity).values());
            Sets.SetView invalidSlotsTypes = Sets.difference(entitySlotTypes, validSlotTypes);
            if (invalidSlotsTypes.size() < validSlotTypes.size()) {
                slotsComponent.method_10852((class_2561)class_2561.method_43471((String)Accessories.translationKey("slot.any")));
                slotsComponent.method_10852((class_2561)class_2561.method_43471((String)Accessories.translationKey("slot.except")).method_27692(class_124.field_1080));
                UnmodifiableIterator invalidSlotsItr = invalidSlotsTypes.iterator();
                while (invalidSlotsItr.hasNext()) {
                    type = (SlotType)invalidSlotsItr.next();
                    if (!ExtraSlotTypeProperties.getProperty(type.name(), entity.method_73183().method_8608()).allowTooltipInfo()) continue;
                    slotsComponent.method_10852((class_2561)class_2561.method_43471((String)type.translation()).method_27692(class_124.field_1061));
                    if (!invalidSlotsItr.hasNext()) continue;
                    slotsComponent.method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080));
                }
            } else {
                Iterator<SlotType> validSlotsItr = validSlotTypes.iterator();
                while (validSlotsItr.hasNext()) {
                    type = validSlotsItr.next();
                    if (!ExtraSlotTypeProperties.getProperty(type.name(), entity.method_73183().method_8608()).allowTooltipInfo()) continue;
                    slotsComponent.method_10852((class_2561)class_2561.method_43471((String)type.translation()));
                    if (!validSlotsItr.hasNext()) continue;
                    slotsComponent.method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080));
                }
            }
        }
        validSlotTypes.addAll(validUniqueSlots);
        List<SlotType> filteredValidUniqueSlots = validUniqueSlots.stream().filter(slotType -> ExtraSlotTypeProperties.getProperty(slotType.name(), true).allowTooltipInfo()).toList();
        if (!filteredValidUniqueSlots.isEmpty()) {
            Iterator<SlotType> uniqueItr = filteredValidUniqueSlots.iterator();
            while (uniqueItr.hasNext()) {
                SlotType type = uniqueItr.next();
                slotsComponent.method_10852((class_2561)class_2561.method_43471((String)type.translation()));
                if (!uniqueItr.hasNext()) continue;
                slotsComponent.method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080));
            }
        }
        if (!slotsComponent.method_10855().isEmpty()) {
            String slotTranslationKey = "slot.tooltip." + (validSlotTypes.size() > 1 && !allSlots ? "plural" : "singular");
            slotInfoComponent.method_10852((class_2561)class_2561.method_43471((String)Accessories.translationKey(slotTranslationKey)).method_27692(class_124.field_1080).method_10852((class_2561)slotsComponent.method_27692(class_124.field_1078)));
            tooltip.add((class_2561)slotInfoComponent);
        }
        HashMap<SlotType, AccessoryAttributeBuilder> slotSpecificModifiers = new HashMap<SlotType, AccessoryAttributeBuilder>();
        AccessoryAttributeBuilder defaultModifiers = null;
        boolean allDuplicates = true;
        for (SlotType slotType2 : validSlotTypes) {
            SlotReference reference = SlotReference.of(entity, slotType2.name(), 0);
            AccessoryAttributeBuilder builder = AccessoryAttributeLogic.getAttributeModifiers(stack, reference, true);
            if (builder.isEmpty()) continue;
            slotSpecificModifiers.put(slotType2, builder);
            if (defaultModifiers == null) {
                defaultModifiers = builder;
                continue;
            }
            if (!allDuplicates) continue;
            allDuplicates = defaultModifiers.equalWithoutPaths(builder);
        }
        HashMap<SlotType, List> slotTypeToTooltipInfo = new HashMap<SlotType, List>();
        if (allDuplicates) {
            if (defaultModifiers != null && !defaultModifiers.isEmpty()) {
                ArrayList<class_2561> attributeTooltip = new ArrayList<class_2561>();
                AccessoriesEventHandler.addAttributeTooltip(entity, stack, defaultModifiers.getAttributeModifiers(false), attributeTooltip, display, tooltipContext, tooltipType);
                slotTypeToTooltipInfo.put(null, attributeTooltip);
            }
        } else {
            for (Map.Entry slotModifiers : slotSpecificModifiers.entrySet()) {
                SlotType slotType3 = (SlotType)slotModifiers.getKey();
                AccessoryAttributeBuilder modifiers = (AccessoryAttributeBuilder)slotModifiers.getValue();
                ArrayList<class_2561> attributeTooltip = new ArrayList<class_2561>();
                AccessoriesEventHandler.addAttributeTooltip(entity, stack, modifiers.getAttributeModifiers(false), attributeTooltip, display, tooltipContext, tooltipType);
                slotTypeToTooltipInfo.put(slotType3, attributeTooltip);
            }
        }
        HashMap<SlotType, List> extraAttributeTooltips = new HashMap<SlotType, List>();
        ArrayList<class_2561> defaultExtraAttributeTooltip = null;
        boolean allDuplicatesExtras = true;
        for (SlotType slotType4 : validSlotTypes) {
            ArrayList<class_2561> extraAttributeTooltip = new ArrayList<class_2561>();
            accessory.getAttributesTooltip(stack, slotType4, extraAttributeTooltip, tooltipContext, tooltipType);
            extraAttributeTooltips.put(slotType4, extraAttributeTooltip);
            if (defaultExtraAttributeTooltip == null) {
                defaultExtraAttributeTooltip = extraAttributeTooltip;
                continue;
            }
            if (!allDuplicatesExtras) continue;
            allDuplicatesExtras = extraAttributeTooltip.equals(defaultExtraAttributeTooltip);
        }
        if (allDuplicatesExtras) {
            if (defaultExtraAttributeTooltip != null) {
                slotTypeToTooltipInfo.computeIfAbsent(null, s -> new ArrayList()).addAll(defaultExtraAttributeTooltip);
            }
        } else {
            extraAttributeTooltips.forEach((slotType, components) -> slotTypeToTooltipInfo.computeIfAbsent((SlotType)slotType, s -> new ArrayList()).addAll(components));
        }
        if (slotTypeToTooltipInfo.containsKey(null)) {
            List anyTooltipInfo = (List)slotTypeToTooltipInfo.get(null);
            if (!anyTooltipInfo.isEmpty()) {
                tooltip.add(class_5244.field_39003);
                tooltip.add((class_2561)class_2561.method_43471((String)Accessories.translationKey("tooltip.attributes.any")).method_27692(class_124.field_1080));
                tooltip.addAll(anyTooltipInfo);
            }
            slotTypeToTooltipInfo.remove(null);
        }
        if (!slotTypeToTooltipInfo.isEmpty()) {
            for (Map.Entry entry : slotTypeToTooltipInfo.entrySet()) {
                List tooltipData = (List)entry.getValue();
                if (tooltipData.isEmpty()) continue;
                tooltip.add(class_5244.field_39003);
                tooltip.add((class_2561)class_2561.method_43469((String)Accessories.translationKey("tooltip.attributes.slot"), (Object[])new Object[]{class_2561.method_43471((String)((SlotType)entry.getKey()).translation()).method_27692(class_124.field_1078)}).method_27692(class_124.field_1080));
                tooltip.addAll((Collection)entry.getValue());
            }
        }
    }

    private static void addAttributeTooltip(class_1309 entity, class_1799 stack, Multimap<class_6880<class_1320>, class_1322> multimap, List<class_2561> tooltip, class_10712 display, class_1792.class_9635 context, class_1836 flag) {
        class_1657 player;
        if (multimap.isEmpty()) {
            return;
        }
        AccessoriesInternals.INSTANCE.addAttributeTooltips(entity instanceof class_1657 ? (player = (class_1657)entity) : null, stack, multimap, tooltip::add, display, context, flag);
    }

    @Nullable
    public static Collection<class_1799> onDeath(class_1309 entity, class_1282 source) {
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability == null) {
            return List.of();
        }
        ArrayList<class_1799> droppedStacks = new ArrayList<class_1799>();
        class_1928 gamerules = ((class_3218)entity.method_73183()).method_64395();
        boolean keepInv = ((class_1928.class_4310)gamerules.method_20746(class_1928.field_19389)).method_20753() || ((class_1928.class_4310)gamerules.method_20746(AccessoriesGameRules.RULE_KEEP_ACCESSORY_INVENTORY)).method_20753();
        for (Map.Entry<String, AccessoriesContainer> containerEntry : AccessoriesHolderImpl.getHolder(capability).getAllSlotContainers().entrySet()) {
            SlotType slotType = containerEntry.getValue().slotType();
            DropRule slotDropRule = slotType != null ? slotType.dropRule() : DropRule.DEFAULT;
            AccessoriesContainer container = containerEntry.getValue();
            ExpandedContainer stacks = container.getAccessories();
            ExpandedContainer cosmeticStacks = container.getCosmeticAccessories();
            for (int i = 0; i < container.getSize(); ++i) {
                class_1799 cosmeticStack;
                SlotReference reference = SlotReference.of(entity, container.getSlotName(), i);
                class_1799 stack = AccessoriesEventHandler.dropStack(slotDropRule, entity, stacks, reference, source, keepInv);
                if (stack != null) {
                    droppedStacks.add(stack);
                }
                if ((cosmeticStack = AccessoriesEventHandler.dropStack(slotDropRule, entity, cosmeticStacks, reference, source, keepInv)) == null) continue;
                droppedStacks.add(cosmeticStack);
            }
        }
        TriState result = ((OnDeathCallback)OnDeathCallback.EVENT.invoker()).shouldDrop(TriState.DEFAULT, entity, capability, source, droppedStacks);
        if (!result.orElse(true)) {
            return null;
        }
        return droppedStacks;
    }

    @Nullable
    private static class_1799 dropStack(DropRule dropRule, class_1309 entity, ExpandedContainer container, SlotReference reference, class_1282 source, boolean keepInvEnabled) {
        class_1799 stack = container.method_5438(reference.index());
        if (stack.method_7960()) {
            return null;
        }
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        if (accessory != null && dropRule == DropRule.DEFAULT) {
            dropRule = accessory.getDropRule(stack, reference, source);
        }
        if (accessory instanceof AccessoryNest) {
            AccessoryNest holdable = (AccessoryNest)accessory;
            List<Pair<DropRule, class_1799>> dropRuleToStacks = holdable.getDropRules(stack, reference, source);
            for (int i = 0; i < dropRuleToStacks.size(); ++i) {
                boolean breakInnerStack;
                Pair<DropRule, class_1799> rulePair = dropRuleToStacks.get(i);
                class_1799 innerStack = (class_1799)rulePair.right();
                DropRule result = OnDropCallback.getAlternativeRule((DropRule)((Object)rulePair.left()), innerStack, reference, source);
                boolean bl = breakInnerStack = result == DropRule.DEFAULT && class_1890.method_60142((class_1799)innerStack, (class_9331)class_9701.field_51655) || result == DropRule.DESTROY;
                if (!breakInnerStack) continue;
                holdable.setInnerStack(stack, i, class_1799.field_8037);
                container.method_5447(reference.index(), stack);
            }
        }
        DropRule result = OnDropCallback.getAlternativeRule(dropRule, stack, reference, source);
        boolean dropStack = true;
        boolean keepingStack = false;
        if (result == DropRule.DESTROY) {
            container.method_5447(reference.index(), class_1799.field_8037);
            dropStack = false;
        } else if (result == DropRule.KEEP) {
            dropStack = false;
            keepingStack = true;
        } else if (result == DropRule.DEFAULT) {
            if (keepInvEnabled) {
                dropStack = false;
                keepingStack = true;
            } else if (class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51655)) {
                container.method_5447(reference.index(), class_1799.field_8037);
                dropStack = false;
            }
        }
        if (keepingStack) {
            container.setPreviousItem(reference.index(), class_1799.field_8037);
        }
        if (!dropStack) {
            return null;
        }
        container.method_5447(reference.index(), class_1799.field_8037);
        return stack;
    }

    public static class_1269 attemptEquipFromUse(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
        if (capability != null && !player.method_7325() && !stack.method_7960()) {
            PlayerEquipControl equipControl = AccessoriesPlayerOptionsHolder.getOptions(player).getDefaultedData(PlayerOptions.EQUIP_CONTROL);
            boolean shouldAttemptEquip = false;
            if (equipControl == PlayerEquipControl.MUST_CROUCH && player.method_5715()) {
                shouldAttemptEquip = true;
            } else if (equipControl == PlayerEquipControl.MUST_NOT_CROUCH && !player.method_5715()) {
                shouldAttemptEquip = true;
            }
            if (shouldAttemptEquip) {
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                Pair<SlotReference, EquipAction> equipReference = capability.canEquipAccessory(stack, true);
                if (equipReference != null && accessory.canEquipFromUse(stack, (SlotReference)equipReference.left())) {
                    accessory.onEquipFromUse(stack, (SlotReference)equipReference.left());
                    class_1799 newHandStack = stack.method_7972();
                    Optional<class_1799> possibleSwappedStack = ((EquipAction)equipReference.second()).equipStack(newHandStack);
                    if (possibleSwappedStack.isPresent()) {
                        class_1799 swappedStack = possibleSwappedStack.get();
                        if (newHandStack.method_7960()) {
                            newHandStack = swappedStack;
                        } else if (class_1799.method_31577((class_1799)newHandStack, (class_1799)swappedStack) && newHandStack.method_7947() + swappedStack.method_7947() <= newHandStack.method_7914()) {
                            newHandStack.method_7933(swappedStack.method_7947());
                        } else {
                            player.method_7270(swappedStack);
                        }
                    }
                    return class_1269.field_5812.method_61393(newHandStack);
                }
            }
        }
        return class_1269.field_5811;
    }

    public static class_1269 attemptEquipOnEntity(class_1657 player, class_1268 hand, class_1297 entity) {
        class_1309 targetEntity;
        class_1799 stack;
        block12: {
            block11: {
                stack = player.method_5998(hand);
                if (!(entity instanceof class_1309)) break block11;
                targetEntity = (class_1309)entity;
                if (entity.method_5864().method_20210(AccessoriesTags.EQUIPMENT_MANAGEABLE)) break block12;
            }
            return class_1269.field_5811;
        }
        AccessoriesCapability targetCapability = AccessoriesCapability.get(targetEntity);
        boolean canModify = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(targetEntity, player, null).orElse(false);
        if (canModify && targetCapability != null && !player.method_7325() && player.method_5715()) {
            Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
            Pair<SlotReference, EquipAction> equipReference = targetCapability.canEquipAccessory(stack, true);
            if (equipReference != null && accessory.canEquipFromUse(stack, (SlotReference)equipReference.left())) {
                if (!stack.method_7960()) {
                    accessory.onEquipFromUse(stack, (SlotReference)equipReference.left());
                }
                class_1799 newHandStack = stack.method_7972();
                Optional<class_1799> possibleSwappedStack = ((EquipAction)equipReference.second()).equipStack(newHandStack);
                if (possibleSwappedStack.isPresent()) {
                    class_1799 swappedStack = possibleSwappedStack.get();
                    if (newHandStack.method_7960()) {
                        newHandStack = swappedStack;
                    } else if (class_1799.method_31577((class_1799)newHandStack, (class_1799)swappedStack) && newHandStack.method_7947() + swappedStack.method_7947() <= newHandStack.method_7914()) {
                        newHandStack.method_7933(swappedStack.method_7947());
                    } else {
                        player.method_7270(swappedStack);
                    }
                }
                return class_1269.field_5812.method_61393(newHandStack);
            }
        }
        return class_1269.field_5811;
    }

    public static void setupItems(AddDataComponentCallback callback) {
        AccessoryRegistry.getAllAccessories().forEach((item, accessory) -> {
            AccessoryItemAttributeModifiers.Builder builder = AccessoryItemAttributeModifiers.builder();
            accessory.getStaticModifiers((class_1792)item, builder);
            if (!builder.isEmpty()) {
                callback.addTo((class_1792)item, AccessoriesDataComponents.ATTRIBUTES, builder.build());
            }
        });
    }

    public static interface AddDataComponentCallback {
        public <T> void addTo(class_1792 var1, class_9331<T> var2, T var3);
    }
}

