/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.slot;

import com.google.common.collect.Lists;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNest;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import java.util.ArrayList;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record SlotReferenceImpl(class_1309 entity, SlotPath slotPath) implements SlotReference
{
    public SlotReferenceImpl {
        if (slotPath.index() < -1) {
            throw new IndexOutOfBoundsException("A given Slot Reference was attempted to be created with a negative index!");
        }
    }

    @Override
    public boolean isValid() {
        AccessoriesCapability capability = this.capability();
        if (capability == null) {
            return false;
        }
        AccessoriesContainer container = capability.getContainers().get(this.slotName());
        if (container == null) {
            return false;
        }
        ExpandedContainer invContainer = container.getAccessories();
        boolean validIndex = invContainer.validIndex(this.index());
        if (!this.slotPath.isNested() || !validIndex) {
            return validIndex;
        }
        class_1799 selectedStack = container.getAccessories().method_5438(this.index());
        for (Integer innerSlotIndex : this.slotPath.innerIndices()) {
            NestLayer nestLayer = SlotReferenceImpl.tryAndGet(selectedStack, innerSlotIndex);
            if (nestLayer == null) {
                return false;
            }
            selectedStack = nestLayer.getInnerStack();
        }
        return true;
    }

    @Override
    @Nullable
    public class_1799 getStack() {
        AccessoriesContainer container = this.slotContainer();
        if (container == null) {
            return null;
        }
        ExpandedContainer invContainer = container.getAccessories();
        if (!invContainer.validIndex(this.index())) {
            return null;
        }
        class_1799 selectedStack = invContainer.method_5438(this.index());
        if (!this.slotPath.isNested()) {
            return selectedStack;
        }
        for (Integer innerSlotIndex : this.slotPath.innerIndices()) {
            NestLayer nestLayer = SlotReferenceImpl.tryAndGet(selectedStack, innerSlotIndex);
            if (nestLayer == null) {
                return null;
            }
            selectedStack = nestLayer.getInnerStack();
        }
        return selectedStack;
    }

    @Nullable
    private static NestLayer tryAndGet(class_1799 holderStack, int innerIndex) {
        NestLayer nestLayer;
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(holderStack);
        if (accessory instanceof AccessoryNest) {
            AccessoryNest accessoryNest = (AccessoryNest)accessory;
            nestLayer = new NestLayer(accessoryNest, holderStack, innerIndex);
        } else {
            nestLayer = null;
        }
        return nestLayer;
    }

    @Override
    public boolean setStack(class_1799 stack) {
        AccessoriesContainer container = this.slotContainer();
        if (container == null) {
            return false;
        }
        ExpandedContainer invContainer = container.getAccessories();
        if (!invContainer.validIndex(this.index())) {
            return false;
        }
        if (!this.slotPath.isNested()) {
            invContainer.method_5447(this.index(), stack);
            return true;
        }
        class_1799 baseStack = invContainer.method_5438(this.index());
        ArrayList<NestLayer> layerStack = new ArrayList<NestLayer>();
        for (Integer innerSlotIndex : this.slotPath.innerIndices()) {
            NestLayer layer = SlotReferenceImpl.tryAndGet(baseStack, innerSlotIndex);
            if (layer == null) {
                return false;
            }
            layerStack.add(layer);
            baseStack = layer.getInnerStack();
        }
        class_1799 innerStack = stack;
        for (NestLayer layer : Lists.reverse(layerStack)) {
            if (!layer.setInnerStack(innerStack)) {
                return false;
            }
            innerStack = layer.holderStack();
        }
        invContainer.method_5447(this.index(), innerStack);
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SlotPath)) {
            return false;
        }
        SlotPath otherPath = (SlotPath)obj;
        return SlotPath.areEqual(this, otherPath);
    }

    private record NestLayer(AccessoryNest accessoryNest, class_1799 holderStack, int index) {
        private boolean setInnerStack(class_1799 innerStack) {
            return this.accessoryNest.setInnerStack(this.holderStack, this.index, innerStack);
        }

        private class_1799 getInnerStack() {
            return this.accessoryNest.getInnerStacks(this.holderStack).get(this.index);
        }
    }
}

