/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu.variants;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.menu.AccessoriesArmorSlot;
import io.wispforest.accessories.menu.AccessoriesMenuData;
import io.wispforest.accessories.menu.AccessoriesMenuTypes;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.menu.SlotAccessContainer;
import io.wispforest.accessories.menu.SlotTypeAccessible;
import io.wispforest.accessories.menu.networking.ToggledSlots;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import io.wispforest.owo.client.screens.SlotGenerator;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_8181;
import org.jetbrains.annotations.Nullable;

public class AccessoriesMenu
extends AccessoriesMenuBase {
    private final Set<SlotType> usedSlots = new HashSet<SlotType>();
    private final Set<SlotGroup> selectedGroups = new HashSet<SlotGroup>();
    private final List<AccessoriesBasedSlot> accessoriesSpecificSlots = new ArrayList<AccessoriesBasedSlot>();
    private int addedArmorSlots = 0;
    private int startArmorSlots = 0;
    private int startingAccessoriesSlot = 0;
    private int stackIndex = -1;

    public static AccessoriesMenu of(int containerId, class_1661 inventory, AccessoriesMenuData data) {
        class_1309 targetEntity = data.targetEntityId().map(i -> {
            class_1309 livingEntity;
            class_1297 patt0$temp = inventory.field_7546.method_73183().method_8469(i.intValue());
            return patt0$temp instanceof class_1309 ? (livingEntity = (class_1309)patt0$temp) : null;
        }).orElse(null);
        AccessoriesMenuBase menu = new AccessoriesMenu(containerId, inventory, targetEntity, data.carriedStack()).isSyncedWithServer(data.slotAmountAdded());
        return (AccessoriesMenu)menu;
    }

    public AccessoriesMenu(int containerId, final class_1661 inventory, @Nullable class_1309 targetEntity, @Nullable class_1799 carriedStack) {
        super(AccessoriesMenuTypes.PRIAMRY_MENU, containerId, inventory, 2, 2, targetEntity);
        class_1309 accessoryTarget;
        AccessoriesCapability capability;
        if (carriedStack != null) {
            this.method_34254(carriedStack);
        }
        if ((capability = AccessoriesCapability.get(accessoryTarget = targetEntity != null ? targetEntity : this.owner)) == null) {
            return;
        }
        this.updateUsedSlots();
        SlotGenerator.begin(x$0 -> this.method_7621((class_1735)x$0), (int)-300, (int)-300).playerInventory(inventory);
        this.method_7621(new class_1735(this, (class_1263)inventory, 40, -300, -300){

            public void method_48931(class_1799 itemStack, class_1799 itemStack2) {
                inventory.field_7546.method_6116(class_1304.field_6171, itemStack2, itemStack);
                super.method_48931(itemStack, itemStack2);
            }

            public class_2960 method_7679() {
                return class_1723.field_21673;
            }
        });
        this.startArmorSlots = this.field_7761.size();
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        ArrayList<Pair> validEquipmentSlots = new ArrayList<Pair>();
        for (class_1304 value : class_1304.values()) {
            SlotTypeReference armorRef;
            if (!accessoryTarget.method_56991(value) || (armorRef = ArmorSlotTypes.getReferenceFromSlot(value)) == null || containers.get(armorRef.slotName()) == null) continue;
            validEquipmentSlots.add(Pair.of((Object)value, (Object)armorRef));
        }
        for (Pair pair : validEquipmentSlots.reversed()) {
            if (!this.addArmorSlot((class_1304)pair.left(), accessoryTarget, (SlotTypeReference)pair.right(), containers)) continue;
            this.addedArmorSlots += 2;
        }
        this.startingAccessoriesSlot = this.field_7761.size();
        Map<SlotGroup, List<SlotType>> validGroupData = SlotGroupLoader.getValidGroups(accessoryTarget);
        List slotTypes = validGroupData.values().stream().flatMap(Collection::stream).toList();
        for (SlotType slot : slotTypes) {
            AccessoriesContainer container = containers.get(slot.name());
            if (container == null || container.slotType() == null) continue;
            for (int i = 0; i < container.getSize(); ++i) {
                AccessoriesBasedSlot cosmeticSlot = new AccessoriesBasedSlot(container, container.getCosmeticAccessories(), i, -300, -300);
                this.method_7621(cosmeticSlot);
                this.accessoriesSpecificSlots.add(cosmeticSlot);
                AccessoriesBasedSlot baseSlot = new AccessoriesBasedSlot(container, container.getAccessories(), i, -300, -300);
                this.method_7621(baseSlot);
                this.accessoriesSpecificSlots.add(baseSlot);
            }
        }
        ToggledSlots.initMenu((class_1703)this);
        this.slotAmountAdded = this.field_7761.size() - this.startArmorSlots;
    }

    private static class_1263 createEquipmentSlotContainer(final class_1309 living, final class_1304 equipmentSlot) {
        return new class_8181(){

            public class_1799 method_54079() {
                return living.method_6118(equipmentSlot);
            }

            public void method_54077(class_1799 item) {
                living.method_5673(equipmentSlot, item);
                if (!item.method_7960() && living instanceof class_1308) {
                    class_1308 mob = (class_1308)living;
                    mob.method_25939(equipmentSlot);
                    mob.method_5971();
                }
            }

            public boolean method_5443(class_1657 player) {
                return player.method_5854() == living || player.method_56094((class_1297)living, 4.0);
            }

            public void method_5431() {
            }
        };
    }

    private boolean addArmorSlot(class_1304 equipmentSlot, class_1309 targetEntity, SlotTypeReference armorReference, Map<String, AccessoriesContainer> containers) {
        final class_2960 location = ArmorSlotTypes.getEmptyTexture(equipmentSlot, targetEntity);
        AccessoriesContainer container = containers.get(armorReference.slotName());
        if (container == null) {
            return false;
        }
        AccessoriesArmorSlot armorSlot = new AccessoriesArmorSlot(container, SlotAccessContainer.ofArmor(equipmentSlot, targetEntity), targetEntity, equipmentSlot, 0, -300, -300, location);
        this.method_7621((class_1735)armorSlot);
        AccessoriesBasedSlot cosmeticSlot = new AccessoriesBasedSlot(this, container, container.getCosmeticAccessories(), 0, -300, -300){

            @Override
            @Nullable
            public class_2960 method_7679() {
                return location;
            }
        };
        this.method_7621(cosmeticSlot);
        return true;
    }

    public final class_1309 targetEntityDefaulted() {
        class_1309 targetEntity = this.targetEntity();
        return targetEntity != null ? targetEntity : this.method_61631();
    }

    public int startingAccessoriesSlot() {
        return this.startArmorSlots;
    }

    public List<AccessoriesBasedSlot> getAccessoriesSlots() {
        return this.accessoriesSpecificSlots;
    }

    public List<class_1735> getVisibleAccessoriesSlots() {
        ArrayList<class_1735> filteredList = new ArrayList<class_1735>();
        Map<SlotGroup, List<SlotType>> groups = SlotGroupLoader.getValidGroups(this.targetEntityDefaulted());
        Set<SlotType> usedSlots = this.getUsedSlots();
        if (usedSlots != null) {
            groups.forEach((group, groupSlots) -> {
                if (groupSlots.stream().noneMatch(usedSlots::contains)) {
                    this.removeSelectedGroup((SlotGroup)group);
                }
            });
        }
        List selectedGroupedSlots = SlotGroupLoader.getValidGroups(this.targetEntityDefaulted()).entrySet().stream().filter(entry -> this.selectedGroups.isEmpty() || this.selectedGroups.contains(entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream()).toList();
        for (int i = 0; i < this.accessoriesSpecificSlots.size() / 2; ++i) {
            boolean isVisible;
            int cosmetic = i * 2;
            int accessory = cosmetic + 1;
            AccessoriesBasedSlot cosmeticSlot = this.accessoriesSpecificSlots.get(cosmetic);
            AccessoriesBasedSlot accessorySlot = this.accessoriesSpecificSlots.get(accessory);
            SlotType slotType = accessorySlot.slotType();
            boolean bl = isVisible = !(!this.usedSlots.isEmpty() && !this.usedSlots.contains(slotType) || !selectedGroupedSlots.isEmpty() && !selectedGroupedSlots.contains(slotType));
            if (!isVisible) continue;
            filteredList.add(cosmeticSlot);
            filteredList.add(accessorySlot);
        }
        return filteredList;
    }

    @Nullable
    public Set<SlotType> getUsedSlots() {
        return this.areUnusedSlotsShown() ? null : this.usedSlots;
    }

    public void updateUsedSlots() {
        this.usedSlots.clear();
        if (!this.areUnusedSlotsShown()) {
            class_1309 entity = this.targetEntity != null ? this.targetEntity : this.owner;
            Collection<SlotType> currentlyUsedSlots = AccessoriesCapability.getUsedSlotsFor(entity, (class_1263)this.owner.method_31548());
            currentlyUsedSlots.addAll(SlotPredicateRegistry.getValidSlotTypes(entity, this.method_34255()));
            if (!currentlyUsedSlots.isEmpty()) {
                this.usedSlots.addAll(currentlyUsedSlots);
            } else {
                this.usedSlots.add(null);
            }
        }
    }

    private static Set<SlotGroup> usedGroups(class_1309 targetEntity, Set<SlotType> usedSlots) {
        Stream<Object> groups = SlotGroupLoader.getValidGroups(targetEntity).entrySet().stream();
        groups = groups.filter(entry -> {
            Set groupSlots = ((List)entry.getValue()).stream().filter(slotType -> {
                if (UniqueSlotHandling.isUniqueSlot(slotType.name())) {
                    return false;
                }
                AccessoriesCapability capability = targetEntity.accessoriesCapability();
                if (capability == null) {
                    return false;
                }
                AccessoriesContainer container = capability.getContainer((SlotType)slotType);
                if (container == null) {
                    return false;
                }
                return container.getSize() > 0;
            }).collect(Collectors.toSet());
            if (groupSlots.isEmpty()) return false;
            if (usedSlots == null) return true;
            if (!groupSlots.stream().anyMatch(usedSlots::contains)) return false;
            return true;
        });
        return groups.map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<SlotGroup> selectedGroups() {
        return this.selectedGroups;
    }

    public boolean isGroupSelected(SlotGroup group) {
        return this.selectedGroups.contains(group);
    }

    public void toggleSelectedGroup(SlotGroup group) {
        if (this.isGroupSelected(group)) {
            this.removeSelectedGroup(group);
        } else {
            this.addSelectedGroup(group);
        }
    }

    public void addSelectedGroup(SlotGroup group) {
        this.selectedGroups.add(group);
        if (this.selectedGroups.containsAll(AccessoriesMenu.usedGroups(this.targetEntityDefaulted(), this.getUsedSlots()))) {
            this.selectedGroups.clear();
        }
    }

    public void removeSelectedGroup(SlotGroup group) {
        this.selectedGroups.remove(group);
    }

    public int addedArmorSlots() {
        return this.addedArmorSlots;
    }

    public boolean areUnusedSlotsShown() {
        return AccessoriesPlayerOptionsHolder.getOptions(this.owner).getDefaultedData(PlayerOptions.SHOW_UNUSED_SLOTS);
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        this.stackIndex = index;
        class_1799 stack = this.quickMoveStackInternal(player, index);
        this.stackIndex = -1;
        return stack;
    }

    private class_1799 quickMoveStackInternal(class_1657 player, int index) {
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (!slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack2 = slot.method_7677();
        class_1799 itemStack = itemStack2.method_7972();
        class_1304 equipmentSlot = this.targetEntity.method_32326(itemStack);
        int bottomArmorIndex = 42 + (this.addedArmorSlots - (equipmentSlot.method_5927() + 1) * 2);
        int topArmorIndex = bottomArmorIndex + 1;
        int upperInventorySize = this.startingAccessoriesSlot;
        if (index == 0) {
            if (!this.method_7616(itemStack2, 5, 41, true)) {
                return class_1799.field_8037;
            }
            slot.method_7670(itemStack2, itemStack);
        } else if (index >= 1 && index < 5 || index >= upperInventorySize || Objects.equals(41, index) || index >= 42) {
            if (!this.method_7616(itemStack2, 5, 41, false)) {
                return class_1799.field_8037;
            }
        } else if (equipmentSlot.method_46643() && !((class_1735)this.field_7761.get(bottomArmorIndex)).method_7681()) {
            if (!this.method_7616(itemStack2, bottomArmorIndex, topArmorIndex, false)) {
                return class_1799.field_8037;
            }
        } else if (equipmentSlot == class_1304.field_6171 && !((class_1735)this.field_7761.get(41)).method_7681()) {
            if (!this.method_7616(itemStack2, 41, 42, false)) {
                return class_1799.field_8037;
            }
        } else {
            boolean changeOccured = false;
            if (this.canMoveToAccessorySlot(itemStack2, this.targetEntityDefaulted())) {
                this.method_7616(itemStack2, upperInventorySize, this.field_7761.size(), false);
                if (itemStack2.method_7947() != itemStack.method_7947() || itemStack2.method_7960()) {
                    changeOccured = true;
                }
            }
            if (!changeOccured && (index >= 5 && index < 32 ? !this.method_7616(itemStack2, 32, 41, false) : index >= 32 && index < 41 && !this.method_7616(itemStack2, 5, 32, false))) {
                return class_1799.field_8037;
            }
        }
        if (itemStack2.method_7947() == itemStack.method_7947()) {
            return class_1799.field_8037;
        }
        if (itemStack2.method_7960()) {
            slot.method_48931(class_1799.field_8037, itemStack);
        } else {
            slot.method_7668();
        }
        if (itemStack2.method_7947() == itemStack.method_7947()) {
            return class_1799.field_8037;
        }
        slot.method_7667(player, itemStack2);
        if (index == 0) {
            player.method_7328(itemStack2, false);
        }
        return itemStack;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    protected boolean canMoveToAccessorySlot(class_1799 stack, class_1309 living) {
        AccessoriesCapability capability = living.accessoriesCapability();
        if (capability == null) {
            return false;
        }
        Collection<SlotType> validSlotTypes = SlotPredicateRegistry.getStackSlotTypes(living, stack);
        for (class_1735 slot : this.field_7761.subList(this.startingAccessoriesSlot, this.field_7761.size())) {
            SlotTypeAccessible accessible;
            if (!(slot instanceof SlotTypeAccessible) || !validSlotTypes.contains((accessible = (SlotTypeAccessible)slot).slotType())) continue;
            return true;
        }
        return false;
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean reverseDirection) {
        ExpandedContainer simpleContainer;
        class_1263 class_12632;
        class_1735 prevSlot;
        int j;
        class_1799 itemStack;
        class_1735 slot;
        int i;
        boolean bl = false;
        int n = i = reverseDirection ? endIndex - 1 : startIndex;
        if (stack.method_7946()) {
            while (!stack.method_7960() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                slot = (class_1735)this.field_7761.get(i);
                if (slot.method_7682() && !(itemStack = slot.method_7677()).method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)itemStack)) {
                    int k;
                    j = itemStack.method_7947() + stack.method_7947();
                    if (j <= (k = slot.method_7676(itemStack))) {
                        stack.method_7939(0);
                        itemStack.method_7939(j);
                        slot.method_7668();
                        bl = true;
                        if (stack.method_7960() && this.stackIndex != -1) {
                            prevSlot = (class_1735)this.field_7761.get(this.stackIndex);
                            class_12632 = prevSlot.field_7871;
                            if (class_12632 instanceof ExpandedContainer) {
                                simpleContainer = (ExpandedContainer)class_12632;
                                simpleContainer.setPreviousItem(prevSlot.field_7874, itemStack);
                            }
                        }
                    } else if (itemStack.method_7947() < k) {
                        stack.method_7934(k - itemStack.method_7947());
                        itemStack.method_7939(k);
                        slot.method_7668();
                        bl = true;
                    }
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        if (!stack.method_7960()) {
            int n2 = i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                slot = (class_1735)this.field_7761.get(i);
                if (slot.method_7682() && (itemStack = slot.method_7677()).method_7960() && slot.method_7680(stack)) {
                    j = slot.method_7676(stack);
                    class_1799 newStack = stack.method_7971(Math.min(stack.method_7947(), j));
                    slot.method_53512(newStack);
                    slot.method_7668();
                    if (stack.method_7960() && this.stackIndex != -1) {
                        prevSlot = (class_1735)this.field_7761.get(this.stackIndex);
                        class_12632 = prevSlot.field_7871;
                        if (class_12632 instanceof ExpandedContainer) {
                            simpleContainer = (ExpandedContainer)class_12632;
                            simpleContainer.setPreviousItem(prevSlot.method_34266(), newStack);
                        }
                    }
                    bl = true;
                    break;
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        return bl;
    }

    public void method_7610(int stateId, List<class_1799> items, class_1799 carried) {
        if (!this.isValidMenu()) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            class_1735 slot = this.method_7611(i);
            if (slot instanceof SlotTypeAccessible) continue;
            slot.method_7673(items.get(i));
        }
        super.method_7610(stateId, List.of(), carried);
    }
}

