/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.core.AccessoryNestUtils;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import io.wispforest.accessories.pond.EnchantedItemInUseExtension;
import io.wispforest.accessories.utils.ServerInstanceHolder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9699;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1890.class})
public abstract class EnchantmentHelperMixin {
    @Shadow
    protected static void runIterationOnItem(class_1799 itemStack, class_1304 equipmentSlot, class_1309 livingEntity, class_1890.class_9702 enchantmentInSlotVisitor) {
    }

    @WrapOperation(method={"getEnchantmentLevel"}, at={@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;")})
    private static Collection<class_1799> addAccessoriesStacks(Map instance, Operation<Collection<class_1799>> original, @Local(argsOnly=true) class_6880<class_1887> enchantment, @Local(argsOnly=true) class_1309 entity) {
        ArrayList<class_1799> returnValue = new ArrayList<class_1799>((Collection)original.call(new Object[]{instance}));
        AccessoriesCapability capability = entity.accessoriesCapability();
        if (capability != null) {
            returnValue.addAll(capability.getAllEquipped().stream().map(SlotEntryReference::stack).toList());
        }
        return returnValue;
    }

    @Inject(method={"getRandomItemWith"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getRandom()Lnet/minecraft/util/RandomSource;")})
    private static void adjustListForAccessories(class_9331<?> dataComponentType, class_1309 livingEntity, Predicate<class_1799> predicate, CallbackInfoReturnable<Optional<class_9699>> cir, @Local(ordinal=0) List<class_9699> list) {
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability != null) {
            List<class_9699> allEquippedAccessories = capability.getAllEquipped().stream().filter(entryReference -> {
                class_1799 itemStack = entryReference.stack();
                if (predicate.test(entryReference.stack())) {
                    class_9304 itemEnchantments = (class_9304)itemStack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
                    for (Object2IntMap.Entry entry : itemEnchantments.method_57539()) {
                        Boolean valid;
                        class_6880 holder = (class_6880)entry.getKey();
                        if (!((class_1887)holder.comp_349()).comp_2689().method_57832(dataComponentType) || (valid = EnchantmentHelperMixin.enchantmentValidForRedirect(livingEntity.method_56673(), (class_1887)holder.comp_349())) == null) continue;
                        return valid;
                    }
                }
                return false;
            }).map(entryReference -> ((EnchantedItemInUseExtension)new class_9699(entryReference.stack(), AccessoriesInternals.INSTANCE.getInternalEquipmentSlot(), livingEntity, item -> entryReference.reference().breakStack())).setSlotReference(entryReference.reference())).toList();
            list.addAll(allEquippedAccessories);
        }
    }

    @Inject(method={"runIterationOnEquipment"}, at={@At(value="TAIL")})
    private static void adjustIterationWithAccessories(class_1309 livingEntity, class_1890.class_9702 enchantmentInSlotVisitor, CallbackInfo ci) {
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability != null) {
            capability.getAllEquipped().forEach(entryReference -> {
                class_1799 itemStack = entryReference.stack();
                ((AccessoriesLivingEntityExtension)livingEntity).pushEnchantmentContext(itemStack, entryReference.reference());
                EnchantmentHelperMixin.runIterationOnItem(itemStack, AccessoriesInternals.INSTANCE.getInternalEquipmentSlot(), livingEntity, enchantmentInSlotVisitor);
            });
        }
    }

    @WrapMethod(method={"runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentVisitor;)V"})
    private static void unpackAccessoryNest1(class_1799 stack, class_1890.class_1891 visitor, Operation<Void> original) {
        AccessoryNestUtils.recursivelyConsume(stack, innerStack -> original.call(new Object[]{innerStack, visitor}));
    }

    @WrapMethod(method={"runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V"})
    private static void unpackAccessoryNest2(class_1799 stack, class_1304 slot, class_1309 entity, class_1890.class_9702 visitor, Operation<Void> original) {
        AccessoryNestUtils.recursivelyConsume(stack, innerStack -> original.call(new Object[]{stack, slot, entity, visitor}));
    }

    @ModifyExpressionValue(method={"runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/Enchantment;matchingSlot(Lnet/minecraft/world/entity/EquipmentSlot;)Z")})
    private static boolean adjustIfIterationOccurs(boolean original, @Local(argsOnly=true) class_1304 equipmentSlot, @Local(argsOnly=true) class_1309 livingEntity, @Local(ordinal=0) class_6880<class_1887> holder) {
        Boolean valid;
        if (equipmentSlot.equals((Object)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot()) && (valid = EnchantmentHelperMixin.enchantmentValidForRedirect(livingEntity.method_56673(), (class_1887)holder.comp_349())) != null) {
            return valid;
        }
        return original;
    }

    @WrapOperation(method={"runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V"}, at={@At(value="NEW", target="(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/enchantment/EnchantedItemInUse;")})
    private static class_9699 addSlotReferenceToEnchantRecord(class_1799 itemStack, class_1304 inSlot, class_1309 owner, Operation<class_9699> original) {
        SlotReference ref;
        class_9699 record = null;
        if (inSlot.equals((Object)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot()) && (ref = ((AccessoriesLivingEntityExtension)owner).popEnchantmentContext(itemStack)) != null) {
            record = new class_9699(itemStack, inSlot, owner, item -> ref.breakStack());
            ((EnchantedItemInUseExtension)record).setSlotReference(ref);
        }
        if (record == null) {
            record = (class_9699)original.call(new Object[]{itemStack, inSlot, owner});
        }
        return record;
    }

    @WrapOperation(method={"method_60148"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/Enchantment;matchingSlot(Lnet/minecraft/world/entity/EquipmentSlot;)Z")})
    private static boolean allowAccessoriesSlotEnchentments(class_1887 instance, class_1304 slot, Operation<Boolean> original) {
        Boolean valid;
        if (slot.equals((Object)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot()) && (valid = EnchantmentHelperMixin.enchantmentValidForRedirect(null, instance)) != null) {
            return valid;
        }
        return (Boolean)original.call(new Object[]{instance, slot});
    }

    @Unique
    @Nullable
    private static Boolean enchantmentValidForRedirect(@Nullable class_5455 access, class_1887 enchantment) {
        class_2378 enchantments;
        if (access != null) {
            enchantments = access.method_30530(class_7924.field_41265);
        } else {
            MinecraftServer server = ServerInstanceHolder.getInstance();
            if (server == null) {
                return null;
            }
            enchantments = server.method_30611().method_30530(class_7924.field_41265);
        }
        return !((class_6880.class_6883)enchantments.method_46746((class_5321)enchantments.method_29113((Object)enchantment).orElseThrow()).orElseThrow()).method_40220(AccessoriesTags.INVALID_FOR_REDIRECTION);
    }
}

