/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.events.extra.ExtraEventHandler;
import io.wispforest.accessories.api.events.extra.OnTotemActivate;
import io.wispforest.accessories.api.events.extra.OnTotemConsumption;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotPathWithStack;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.core.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.pond.AccessoriesAPIAccess;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_10192;
import net.minecraft.class_10216;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.class_9722;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements AccessoriesAPIAccess,
AccessoriesLivingEntityExtension {
    @Unique
    private AccessoriesCapabilityImpl accessories$capability = null;
    @Unique
    private final Map<class_1799, SlotReference> accessories$enchantmentLocationContext = new Reference2ObjectOpenHashMap();
    @Unique
    private final Map<String, Reference2ObjectMap<class_1887, Set<class_9722>>> accessories$activeLocationDependentEnchantments = new HashMap<String, Reference2ObjectMap<class_1887, Set<class_9722>>>();

    @Shadow
    public abstract void swing(class_1268 var1, boolean var2);

    protected LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    public AccessoriesCapability getOrCreateAccessoriesCapability() {
        if (this.accessories$capability == null) {
            this.accessories$capability = new AccessoriesCapabilityImpl((class_1309)this);
        }
        return this.accessories$capability;
    }

    @Override
    @Nullable
    public AccessoriesCapability accessoriesCapability() {
        Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots((class_1309)this);
        if (slots.isEmpty()) {
            return null;
        }
        AccessoriesCapability capability = this.getOrCreateAccessoriesCapability();
        AccessoriesHolderImpl.getHolder(capability);
        return capability;
    }

    @Override
    public void pushEnchantmentContext(class_1799 stack, SlotReference reference) {
        this.accessories$enchantmentLocationContext.put(stack, reference);
    }

    @Override
    @Nullable
    public SlotReference popEnchantmentContext(class_1799 stack) {
        return this.accessories$enchantmentLocationContext.remove(stack);
    }

    @Override
    public Map<class_1887, Set<class_9722>> activeLocationDependentEnchantmentsFromSlotReference(SlotReference slotReference) {
        return (Map)this.accessories$activeLocationDependentEnchantments.computeIfAbsent(slotReference.createString(), equipmentSlot -> new Reference2ObjectArrayMap());
    }

    @Inject(method={"onEquippedItemBroken"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendAccessoriesBreakInstead(class_1792 item, class_1304 slot, CallbackInfo ci) {
        if (slot.equals((Object)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot())) {
            ci.cancel();
        }
    }

    @Inject(method={"entityEventForEquipmentBreak"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preventMatchExceptionForAccessories(class_1304 slot, CallbackInfoReturnable<Byte> cir) {
        if (slot.equals((Object)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot())) {
            cir.setReturnValue((Object)-1);
        }
    }

    @Override
    public void onEquipItem(SlotReference slotReference, class_1799 oldItem, class_1799 newItem) {
        class_1937 level = this.method_73183();
        if (!(class_1799.method_31577((class_1799)oldItem, (class_1799)newItem) || this.field_5953 || level.method_8608() || this.method_7325())) {
            SoundEventData sound;
            boolean isEquitableFor;
            boolean bl = isEquitableFor = newItem.method_7960() || SlotPredicateRegistry.canInsertIntoSlot(newItem, slotReference);
            if (!this.method_5701() && !newItem.method_7960() && (sound = AccessoryRegistry.getAccessoryOrDefault(newItem).getEquipSound(newItem, slotReference)) != null) {
                level.method_47967(null, this.method_23317(), this.method_23318(), this.method_23321(), (class_3414)sound.event().comp_349(), this.method_5634(), sound.volume(), sound.pitch(), this.field_5974.method_43055());
            }
            if (isEquitableFor) {
                this.method_32876((class_6880)(!newItem.method_7960() ? class_5712.field_28739 : class_5712.field_45787));
            }
        }
    }

    @Inject(method={"isLookingAtMe"}, at={@At(value="HEAD")}, cancellable=true)
    private void accessories$isGazeDisguised(class_1309 livingEntity, double tolerance, boolean scaleByDistance, boolean visual, double[] yValues, CallbackInfoReturnable<Boolean> cir) {
        TriState state = ExtraEventHandler.isGazedBlocked((class_1309)this, livingEntity);
        if (state != TriState.DEFAULT) {
            cir.setReturnValue((Object)(!state.get() ? 1 : 0));
        }
    }

    @ModifyReturnValue(method={"canFreeze"}, at={@At(value="RETURN", ordinal=1)})
    private boolean canFreezeAccessoriesCheck(boolean bl) {
        TriState state = ExtraEventHandler.canFreezeEntity((class_1309)this);
        return state.orElse(bl);
    }

    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="JUMP", opcode=198, ordinal=1, shift=At.Shift.BEFORE)})
    private void accessories$checkForTotems(class_1282 damageSource, CallbackInfoReturnable<Boolean> cir, @Local(ordinal=0) LocalRef<class_1799> itemStack, @Local(ordinal=0) LocalRef<class_10216> deathProtection, @Share(value="currentSlotReference") LocalRef<@Nullable SlotReference> currentSlotReference) {
        SlotPathWithStack totem;
        AccessoriesCapability capability = this.accessoriesCapability();
        SlotReference slotReference = null;
        if (capability != null && deathProtection.get() == null && (totem = capability.getFirstEquipped((Predicate)ItemStackBasedPredicate.ofComponents("totem_check", class_9334.field_54274))) != null) {
            OnTotemConsumption onTotemConsumption;
            slotReference = ((SlotEntryReference)totem).reference();
            class_1799 totemStack = ((SlotEntryReference)totem).stack();
            itemStack.set((Object)totemStack.method_7972());
            deathProtection.set((Object)((class_10216)totemStack.method_58694(class_9334.field_54274)));
            Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(totemStack);
            OnTotemConsumption consumptionAction = accessory instanceof OnTotemConsumption ? (onTotemConsumption = (OnTotemConsumption)((Object)accessory)) : OnTotemConsumption.DEFAULT_BEHAVIOR;
            totemStack = consumptionAction.onConsumption(slotReference, totemStack, damageSource);
            slotReference.setStack(totemStack);
        }
        currentSlotReference.set(slotReference);
    }

    @WrapOperation(method={"checkTotemDeathProtection"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/component/DeathProtection;applyEffects(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)V")})
    private void accessories$adjustTotemEffects(class_10216 instance, class_1799 itemStack, class_1309 livingEntity, Operation<Void> original, @Local(argsOnly=true) class_1282 damageSource, @Share(value="currentSlotReference") LocalRef<@Nullable SlotReference> currentSlotReference) {
        OnTotemActivate onTotemActivate;
        Accessory accessory;
        OnTotemActivate activationAction;
        SlotReference slotReference = (SlotReference)currentSlotReference.get();
        if (slotReference != null && (instance = (activationAction = (accessory = AccessoryRegistry.getAccessoryOrDefault(itemStack)) instanceof OnTotemActivate ? (onTotemActivate = (OnTotemActivate)((Object)accessory)) : OnTotemActivate.DEFAULT_BEHAVIOR).onActivation(instance, slotReference, itemStack, damageSource)) == null) {
            return;
        }
        original.call(new Object[]{instance, itemStack, livingEntity});
    }

    @WrapOperation(method={"updateFallFlying"}, at={@At(value="INVOKE", target="Ljava/util/stream/Stream;toList()Ljava/util/List;")})
    private List<class_1304> accessories$addEquipmentCheck(Stream<class_1304> instance, Operation<List<class_1304>> original, @Share(value="slotReference") LocalRef<@Nullable SlotReference> slotReference) {
        SlotEntryReference glider;
        List<SlotEntryReference> gliders;
        AccessoriesCapability capability = this.accessoriesCapability();
        slotReference.set(null);
        if (capability != null && !(gliders = capability.getEquipped(ItemStackBasedPredicate.ofComponents(class_9334.field_54197))).isEmpty() && class_1309.method_63624((class_1799)(glider = (SlotEntryReference)class_156.method_32309(gliders, (class_5819)this.field_5974)).stack(), (class_1304)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot())) {
            slotReference.set((Object)glider.reference());
            instance = Stream.concat(instance, Stream.of(AccessoriesInternals.INSTANCE.getInternalEquipmentSlot()));
        }
        return (List)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"updateFallFlying"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getItemBySlot(Lnet/minecraft/world/entity/EquipmentSlot;)Lnet/minecraft/world/item/ItemStack;")})
    private class_1799 accessories$adjustGottenStack(class_1309 instance, class_1304 equipmentSlot, Operation<class_1799> original, @Share(value="slotReference") LocalRef<@Nullable SlotReference> slotReference) {
        if (equipmentSlot != AccessoriesInternals.INSTANCE.getInternalEquipmentSlot()) {
            return (class_1799)original.call(new Object[]{instance, equipmentSlot});
        }
        class_1799 stack = ((SlotReference)slotReference.get()).getStack();
        return stack != null ? stack : class_1799.field_8037;
    }

    @WrapOperation(method={"updateFallFlying"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/EquipmentSlot;)V")})
    private void accessories$adjustHurtAndBreak(class_1799 instance, int amount, class_1309 entity, class_1304 slot, Operation<Void> original, @Share(value="slotReference") LocalRef<@Nullable SlotReference> slotReference) {
        SlotReference ref = (SlotReference)slotReference.get();
        if (ref == null) {
            original.call(new Object[]{instance, amount, entity, slot});
        } else {
            class_1937 class_19372 = entity.method_73183();
            if (class_19372 instanceof class_3218) {
                class_3222 serverPlayer;
                class_3218 serverLevel = (class_3218)class_19372;
                instance.method_7956(amount, serverLevel, entity instanceof class_3222 ? (serverPlayer = (class_3222)entity) : null, item -> ref.breakStack());
            }
        }
    }

    @Inject(method={"canGlide"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/EquipmentSlot;VALUES:Ljava/util/List;")}, cancellable=true)
    private void accessories$checkAccessoriesGliders(CallbackInfoReturnable<Boolean> cir) {
        AccessoriesCapability capability = this.accessoriesCapability();
        if (capability == null) {
            return;
        }
        List<SlotEntryReference> gliders = capability.getEquipped(ItemStackBasedPredicate.ofComponents(class_9334.field_54197));
        if (gliders.isEmpty()) {
            return;
        }
        for (SlotEntryReference glider : gliders) {
            if (!class_1309.method_63624((class_1799)glider.stack(), (class_1304)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot())) continue;
            cir.setReturnValue((Object)true);
        }
    }

    @WrapOperation(method={"canGlideUsing"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/equipment/Equippable;slot()Lnet/minecraft/world/entity/EquipmentSlot;")})
    private static class_1304 accessories$changeEquipmentSlot(class_10192 instance, Operation<class_1304> original, @Local(argsOnly=true) class_1304 equipmentSlot) {
        return equipmentSlot == AccessoriesInternals.INSTANCE.getInternalEquipmentSlot() ? AccessoriesInternals.INSTANCE.getInternalEquipmentSlot() : (class_1304)original.call(new Object[]{instance});
    }
}

