/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.impl.core.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.endec.util.MapCarrierDecodable;
import io.wispforest.endec.util.MapCarrierEncodable;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_5455;
import org.slf4j.Logger;

public record SyncContainerData(int entityId, Map<String, NbtMapCarrier> updatedContainers, Map<String, class_1799> dirtyStacks, Map<String, class_1799> dirtyCosmeticStacks) {
    public static StructEndec<SyncContainerData> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", SyncContainerData::entityId), (StructField)NbtMapCarrier.ENDEC.mapOf().fieldOf("updatedContainers", SyncContainerData::updatedContainers), (StructField)CodecUtils.toEndec((Codec)class_1799.field_49266).mapOf().fieldOf("dirtyStacks", SyncContainerData::dirtyStacks), (StructField)CodecUtils.toEndec((Codec)class_1799.field_49266).mapOf().fieldOf("dirtyCosmeticStacks", SyncContainerData::dirtyCosmeticStacks), SyncContainerData::new);
    private static final Logger LOGGER = LogUtils.getLogger();

    public static SyncContainerData of(class_1309 livingEntity, Collection<AccessoriesContainer> updatedContainers, Map<String, class_1799> dirtyStacks, Map<String, class_1799> dirtyCosmeticStacks) {
        HashMap<String, NbtMapCarrier> updatedContainerTags = new HashMap<String, NbtMapCarrier>();
        for (AccessoriesContainer updatedContainer : updatedContainers) {
            NbtMapCarrier syncCarrier = NbtMapCarrier.of();
            ((AccessoriesContainerImpl)updatedContainer).write((MapCarrierEncodable)syncCarrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)livingEntity.method_56673())}), true);
            updatedContainerTags.put(updatedContainer.getSlotName(), syncCarrier);
        }
        return new SyncContainerData(livingEntity.method_5628(), updatedContainerTags, dirtyStacks, dirtyCosmeticStacks);
    }

    public static void handlePacket(SyncContainerData packet, class_1657 player) {
        class_1703 class_17032;
        AccessoriesHolderLookupCache accessoriesHolderLookupCache;
        class_1937 level = player.method_73183();
        class_1297 entity = level.method_8469(packet.entityId());
        if (entity == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as it is null on the Client! [EntityId: {}]", (Object)packet.entityId());
            return;
        }
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        AccessoriesCapability capability = AccessoriesCapability.get(livingEntity);
        if (capability == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as its Capability is null on the Client! [EntityId: {}]", (Object)packet.entityId());
            return;
        }
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        boolean aContainerHasResized = false;
        HashSet<String> changedContainers = new HashSet<String>();
        HashSet<String> invalidSyncedContainers = new HashSet<String>();
        for (Map.Entry<String, NbtMapCarrier> entry : packet.updatedContainers().entrySet()) {
            if (!containers.containsKey(entry.getKey())) {
                invalidSyncedContainers.add(entry.getKey());
                continue;
            }
            AccessoriesContainer accessoriesContainer = containers.get(entry.getKey());
            changedContainers.add(accessoriesContainer.getSlotName());
            ((AccessoriesContainerImpl)accessoriesContainer).read((MapCarrierDecodable)entry.getValue(), SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)player.method_73183().method_30349())}), true);
            if (!accessoriesContainer.getAccessories().wasNewlyConstructed()) continue;
            aContainerHasResized = true;
        }
        if (!invalidSyncedContainers.isEmpty()) {
            LOGGER.warn("Unable to sync container data for the following containers: {}", invalidSyncedContainers);
        }
        HashSet<String> invalidDirtyStackContainers = new HashSet<String>();
        for (Map.Entry entry : packet.dirtyStacks().entrySet()) {
            String[] stringArray = ((String)entry.getKey()).split("/");
            String slot = stringArray[0];
            if (!containers.containsKey(slot)) {
                invalidDirtyStackContainers.add(slot);
                continue;
            }
            AccessoriesContainer container = containers.get(slot);
            changedContainers.add(container.getSlotName());
            try {
                container.getAccessories().method_5447(Integer.parseInt(stringArray[1]), (class_1799)entry.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!invalidDirtyStackContainers.isEmpty()) {
            LOGGER.warn("Unable to sync dirty stack data for the following containers: {}", invalidSyncedContainers);
        }
        HashSet<String> invalidDirtyCosmeticContainers = new HashSet<String>();
        for (Map.Entry<String, class_1799> entry : packet.dirtyCosmeticStacks().entrySet()) {
            String[] parts = entry.getKey().split("/");
            String slot = parts[0];
            if (!containers.containsKey(slot)) {
                invalidDirtyCosmeticContainers.add(slot);
                continue;
            }
            AccessoriesContainer container = containers.get(slot);
            changedContainers.add(container.getSlotName());
            try {
                container.getCosmeticAccessories().method_5447(Integer.parseInt(parts[1]), entry.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!invalidDirtyCosmeticContainers.isEmpty()) {
            LOGGER.warn("Unable to sync dirty stack data for the following containers: {}", invalidSyncedContainers);
        }
        if ((accessoriesHolderLookupCache = AccessoriesHolderImpl.getHolder(capability).getLookupCache()) != null) {
            changedContainers.forEach(accessoriesHolderLookupCache::clearContainerCache);
        }
        if ((class_17032 = player.field_7512) instanceof AccessoriesMenuBase) {
            AccessoriesMenuBase accessoriesMenuBase = (AccessoriesMenuBase)class_17032;
            if (aContainerHasResized) {
                accessoriesMenuBase.reopenMenu();
            }
        }
    }
}

