/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import io.netty.buffer.Unpooled;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.mixin.owo.ConfigSynchronizerAccessor;
import io.wispforest.accessories.mixin.owo.OptionAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.utils.ServerInstanceHolder;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.config.ConfigWrapper;
import io.wispforest.owo.config.Option;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.server.MinecraftServer;

public record SyncServerOverrideOption(String configId, Option.Key optionKey, class_2540 buf) {
    public static final StructEndec<SyncServerOverrideOption> ENDEC = StructEndecBuilder.of((StructField)Endec.STRING.fieldOf("config_id", SyncServerOverrideOption::configId), (StructField)Endec.STRING.xmap(Option.Key::new, Option.Key::asString).fieldOf("option_key", SyncServerOverrideOption::optionKey), (StructField)MinecraftEndecs.PACKET_BYTE_BUF.fieldOf("buf", SyncServerOverrideOption::buf), SyncServerOverrideOption::new);

    public static <T> void hookUpdate(Consumer<Consumer<T>> hook, ConfigWrapper<?> wrapper, Option.Key optionKey) {
        hook.accept(object -> SyncServerOverrideOption.sendUpdatePacket(wrapper, optionKey));
    }

    public static <T> void sendUpdatePacket(ConfigWrapper<?> wrapper, Option.Key optionKey) {
        Option option = wrapper.optionForKey(optionKey);
        if (option == null) {
            Accessories.LOGGER.warn("Unable to send config value change to clients as the wrapper '{}' dose not contain the given option '{}'!", (Object)wrapper.name(), (Object)optionKey);
            return;
        }
        SyncServerOverrideOption.sendUpdatePacket(option);
    }

    public static <T> void sendUpdatePacket(Option<T> option) {
        MinecraftServer currentServer = ServerInstanceHolder.getInstance();
        if (currentServer == null) {
            return;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        ((OptionAccessor)option).accessories$write(buf);
        SyncServerOverrideOption packet = new SyncServerOverrideOption(option.configName(), option.key(), buf);
        AccessoriesNetworking.sendToAllPlayers(currentServer, packet);
    }

    public static void handlePacket(SyncServerOverrideOption packet, class_1657 player) {
        ConfigWrapper<?> wrapper = ConfigSynchronizerAccessor.KNOWN_CONFIGS().get(packet.configId);
        if (wrapper == null) {
            Accessories.LOGGER.warn("Unable to sync config value change to client as the wrapper '{}' dose not exists!", (Object)packet.configId());
            return;
        }
        Option option = wrapper.optionForKey(packet.optionKey());
        if (wrapper == null) {
            Accessories.LOGGER.warn("Unable to sync config value change to client as the wrapper '{}' dose not contain the given option '{}'!", (Object)packet.configId(), (Object)packet.optionKey());
            return;
        }
        if (!option.detached()) {
            return;
        }
        ((OptionAccessor)option).accessories$read(packet.buf());
    }
}

