/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.utils;

import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_11343;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1657;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_9875;
import org.jetbrains.annotations.Nullable;

public class BaseContainer
implements class_1263,
class_1737 {
    private final int size;
    private final class_2371<class_1799> items;
    @Nullable
    private EventStream<class_1265> onContainerChange = null;

    public BaseContainer(int size) {
        this.size = size;
        this.items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public BaseContainer(class_1799 ... items) {
        this.size = items.length;
        this.items = class_2371.method_10212((Object)class_1799.field_8037, (Object[])items);
    }

    public EventSource.Subscription addListener(class_1265 listener) {
        if (this.onContainerChange == null) {
            this.onContainerChange = new EventStream(invokers -> container -> invokers.forEach(listenerEntry -> listenerEntry.method_5453(container)));
        }
        return this.onContainerChange.source().subscribe((Object)listener);
    }

    public List<class_1799> getItems() {
        return this.items;
    }

    public class_1799 method_5438(int slot) {
        return slot >= 0 && slot < this.items.size() ? (class_1799)this.items.get(slot) : class_1799.field_8037;
    }

    public List<class_1799> removeAllItems() {
        List<class_1799> list = this.items.stream().filter(itemStack -> !itemStack.method_7960()).collect(Collectors.toList());
        this.method_5448();
        return list;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 itemStack = class_1262.method_5430(this.items, (int)slot, (int)amount);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public class_1799 removeItemType(class_1792 item, int amount) {
        class_1799 itemStack = new class_1799((class_1935)item, 0);
        for (int i = this.size - 1; i >= 0; --i) {
            class_1799 itemStack2 = this.method_5438(i);
            if (!itemStack2.method_7909().equals(item)) continue;
            int j = amount - itemStack.method_7947();
            class_1799 itemStack3 = itemStack2.method_7971(j);
            itemStack.method_7933(itemStack3.method_7947());
            if (itemStack.method_7947() == amount) break;
        }
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public class_1799 addItem(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = stack.method_7972();
        this.moveItemToOccupiedSlotsWithSameType(itemStack);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.moveItemToEmptySlots(itemStack);
        return itemStack.method_7960() ? class_1799.field_8037 : itemStack;
    }

    public boolean canAddItem(class_1799 stack) {
        boolean bl = false;
        for (class_1799 itemStack : this.items) {
            if (!itemStack.method_7960() && (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack) || itemStack.method_7947() >= itemStack.method_7914())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public class_1799 method_5441(int slot) {
        class_1799 itemStack = (class_1799)this.items.get(slot);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.items.set(slot, (Object)class_1799.field_8037);
        return itemStack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.items.set(slot, (Object)stack);
        stack.method_58408(this.method_58350(stack));
        this.method_5431();
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.items) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public void method_5431() {
        if (this.onContainerChange != null) {
            ((class_1265)this.onContainerChange.sink()).method_5453((class_1263)this);
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.items.clear();
        this.method_5431();
    }

    public void method_7683(class_9875 stackedItemContents) {
        for (class_1799 itemStack : this.items) {
            stackedItemContents.method_61541(itemStack);
        }
    }

    public String toString() {
        return this.items.stream().filter(itemStack -> !itemStack.method_7960()).toList().toString();
    }

    private void moveItemToEmptySlots(class_1799 stack) {
        for (int i = 0; i < this.size; ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (!itemStack.method_7960()) continue;
            this.method_5447(i, stack.method_51164());
            return;
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(class_1799 stack) {
        for (int i = 0; i < this.size; ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) continue;
            this.moveItemsBetweenStacks(stack, itemStack);
            if (!stack.method_7960()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(class_1799 stack, class_1799 other) {
        int i = this.method_58350(other);
        int j = Math.min(stack.method_7947(), i - other.method_7947());
        if (j > 0) {
            other.method_7933(j);
            stack.method_7934(j);
            this.method_5431();
        }
    }

    public final void saveAllItems(class_11372 valueOutput) {
        class_11372.class_11373 typedOutputList = valueOutput.method_71467("Items", class_11343.field_60354);
        this.saveItemsToList((class_11372.class_11373<class_11343>)typedOutputList);
    }

    public final void loadAllItems(class_11368 valueInput) {
        this.loadItemsFromList((class_11368.class_11369<class_11343>)valueInput.method_71437("Items", class_11343.field_60354));
    }

    public void saveItemsToList(class_11372.class_11373<class_11343> valueOutput) {
        this.saveItemsToList().forEach(arg_0 -> valueOutput.method_71484(arg_0));
    }

    public void loadItemsFromList(class_11368.class_11369<class_11343> valueInput) {
        this.loadItemsFromList(valueInput.method_71456().toList());
    }

    public List<class_11343> saveItemsToList() {
        ArrayList<class_11343> slottedStacks = new ArrayList<class_11343>();
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 itemStack = (class_1799)this.items.get(i);
            if (itemStack.method_7960()) continue;
            slottedStacks.add(new class_11343(i, itemStack));
        }
        return slottedStacks;
    }

    public void loadItemsFromList(Collection<class_11343> slottedStacks) {
        for (class_11343 slottedStack : slottedStacks) {
            if (!slottedStack.method_71368(this.size)) continue;
            this.items.set(slottedStack.comp_4211(), (Object)slottedStack.comp_4212());
        }
    }

    public static interface ErrorableGetter<T> {
        public T getEntry(Consumer<String> var1);
    }
}

