/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7654;
import org.slf4j.Logger;

public class JsonUtils {
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T> Map<class_2960, class_3298> scanDirectoryWithReplace(class_3300 resourceManager, class_7654 fileToIdConverter) {
        LinkedHashMap<class_2960, FileResourceData> outputResources = new LinkedHashMap<class_2960, FileResourceData>();
        for (Map.Entry entry2 : fileToIdConverter.method_45116(resourceManager).entrySet()) {
            class_2960 filePath = (class_2960)entry2.getKey();
            class_2960 resourceLocation = fileToIdConverter.method_45115((class_2960)entry2.getKey());
            for (class_3298 resource : (List)entry2.getValue()) {
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class);
                        if (!(jsonElement instanceof JsonObject)) {
                            LOGGER.warn("File was found not to be parsed as a valid JsonObject, it will be skipped: [Location: " + String.valueOf(filePath) + "]");
                            continue;
                        }
                        JsonObject jsonObject = (JsonObject)jsonElement;
                        if (outputResources.containsKey(resourceLocation)) {
                            JsonObject jsonObject2 = ((FileResourceData)outputResources.get(resourceLocation)).obj().getAsJsonObject();
                            if (!class_3518.method_15270((JsonObject)jsonObject, (String)"replace")) continue;
                            jsonObject.asMap().forEach((arg_0, arg_1) -> ((JsonObject)jsonObject2).add(arg_0, arg_1));
                            continue;
                        }
                        outputResources.put(resourceLocation, new FileResourceData(filePath, jsonObject, resource));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException var14) {
                    LOGGER.error("Couldn't parse data file {} from {}", new Object[]{resourceLocation, filePath, var14});
                }
            }
        }
        return outputResources.entrySet().stream().collect(Collectors.toMap(entry -> ((FileResourceData)entry.getValue()).fileLocation(), entry -> ((FileResourceData)entry.getValue()).resource(), (object, object2) -> object, LinkedHashMap::new));
    }

    public record FileResourceData(class_2960 fileLocation, JsonObject obj, class_3298 resource) {
    }
}

