/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.attributes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesLoaderInternals;
import io.wispforest.accessories.api.attributes.AttributeModificationData;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class AccessoryAttributeBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<Holder<Attribute>, Map<ResourceLocation, AttributeModificationData>> exclusiveAttributes;
    private final Multimap<Holder<Attribute>, AttributeModificationData> stackedAttributes;
    private final SlotPath slotPath;
    private final Set<ResourceLocation> previouslyWarnedLocations = new HashSet<ResourceLocation>();

    @ApiStatus.Internal
    public AccessoryAttributeBuilder(SlotPath slotPath, @Nullable AccessoryAttributeBuilder parentBuilder) {
        this.slotPath = slotPath;
        if (parentBuilder != null) {
            this.exclusiveAttributes = parentBuilder.exclusiveAttributes;
            this.stackedAttributes = parentBuilder.stackedAttributes;
        } else {
            this.exclusiveAttributes = new HashMap<Holder<Attribute>, Map<ResourceLocation, AttributeModificationData>>();
            this.stackedAttributes = LinkedHashMultimap.create();
        }
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder(SlotPath slotPath) {
        this(slotPath, null);
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder(String slotName, int slot) {
        this(SlotPath.of(slotName, slot));
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder() {
        this(SlotPath.of("", 0));
    }

    public AccessoryAttributeBuilder addExclusive(Holder<Attribute> attribute, ResourceLocation location, double amount, AttributeModifier.Operation operation) {
        return this.addExclusive(attribute, location, amount, operation, false);
    }

    public AccessoryAttributeBuilder addStackable(Holder<Attribute> attribute, ResourceLocation location, double amount, AttributeModifier.Operation operation) {
        return this.addStackable(attribute, location, amount, operation, false);
    }

    public AccessoryAttributeBuilder addExclusive(Holder<Attribute> attribute, ResourceLocation location, double amount, AttributeModifier.Operation operation, boolean usedInSlotValidation) {
        return this.addExclusive(attribute, new AttributeModifier(location, amount, operation), usedInSlotValidation);
    }

    public AccessoryAttributeBuilder addStackable(Holder<Attribute> attribute, ResourceLocation location, double amount, AttributeModifier.Operation operation, boolean usedInSlotValidation) {
        return this.addStackable(attribute, new AttributeModifier(location, amount, operation), usedInSlotValidation);
    }

    public AccessoryAttributeBuilder addExclusive(Holder<Attribute> attribute, AttributeModifier modifier) {
        return this.addExclusive(attribute, modifier, false);
    }

    public AccessoryAttributeBuilder addStackable(Holder<Attribute> attribute, AttributeModifier modifier) {
        return this.addStackable(attribute, modifier, false);
    }

    public AccessoryAttributeBuilder addExclusive(Holder<Attribute> attribute, AttributeModifier modifier, boolean usedInSlotValidation) {
        ResourceLocation id = modifier.id();
        Map innerMap = this.exclusiveAttributes.computeIfAbsent(attribute, attributeHolder -> new HashMap());
        if (AccessoriesLoaderInternals.isDevelopmentEnv() && innerMap.containsKey(id) && !this.previouslyWarnedLocations.contains(id)) {
            LOGGER.warn("A given Modifier was found to have a duplicate location but was added as exclusive, was such on purpose as such will not stack with the other: {}", (Object)id);
            this.previouslyWarnedLocations.add(id);
        }
        innerMap.putIfAbsent(id, new AttributeModificationData(attribute, modifier, usedInSlotValidation));
        return this;
    }

    public AccessoryAttributeBuilder addStackable(Holder<Attribute> attribute, AttributeModifier modifier, boolean usedInSlotValidation) {
        this.stackedAttributes.put(attribute, (Object)new AttributeModificationData(this.slotPath.createString(), attribute, modifier, usedInSlotValidation));
        return this;
    }

    @Nullable
    public AttributeModificationData getExclusive(Holder<Attribute> attribute, ResourceLocation location) {
        Map<ResourceLocation, AttributeModificationData> innerMap = this.exclusiveAttributes.get(attribute);
        if (innerMap == null) {
            return null;
        }
        return innerMap.get(location);
    }

    public Collection<AttributeModificationData> getStacks(Holder<Attribute> attribute, ResourceLocation location) {
        return this.stackedAttributes.get(attribute).stream().filter(data -> data.modifier().id().equals((Object)location)).toList();
    }

    @Nullable
    public AttributeModificationData removeExclusive(Holder<Attribute> attribute, ResourceLocation location) {
        Map<ResourceLocation, AttributeModificationData> innerMap = this.exclusiveAttributes.get(attribute);
        if (innerMap == null) {
            return null;
        }
        return innerMap.remove(location);
    }

    public Collection<AttributeModificationData> removeStacks(Holder<Attribute> attribute, ResourceLocation location) {
        HashSet<AttributeModificationData> removedData = new HashSet<AttributeModificationData>();
        for (AttributeModificationData data : List.copyOf(this.stackedAttributes.get(attribute))) {
            if (!data.modifier().id().equals((Object)location)) continue;
            removedData.add(data);
            this.stackedAttributes.remove(attribute, (Object)data);
        }
        return removedData;
    }

    public Multimap<String, AttributeModifier> getSlotModifiers() {
        return this.getSlotModifiers(false);
    }

    public Multimap<String, AttributeModifier> getSlotModifiers(boolean usedWithinSlotPredicate) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        this.exclusiveAttributes.forEach((attribute, innerMap) -> innerMap.forEach((location, uniqueInstance) -> {
            if (uniqueInstance.isValid(AttributeModificationData.AllowedType.SLOT, usedWithinSlotPredicate)) {
                map.put((Object)((SlotAttribute)((Object)((Object)((Object)uniqueInstance.attribute().value())))).slotName(), (Object)uniqueInstance.modifier());
            }
        }));
        this.stackedAttributes.forEach((location, stackedInstance) -> {
            if (stackedInstance.isValid(AttributeModificationData.AllowedType.SLOT, usedWithinSlotPredicate)) {
                map.put((Object)((SlotAttribute)((Object)((Object)stackedInstance.attribute().value()))).slotName(), (Object)stackedInstance.modifier());
            }
        });
        return map;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(boolean removeSlotAttributes) {
        return this.getAttributeModifiers(removeSlotAttributes, false);
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(boolean removeSlotAttributes, boolean usedWithinSlotPredicate) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        this.exclusiveAttributes.forEach((attribute, innerMap) -> innerMap.forEach((location, uniqueInstance) -> {
            if (uniqueInstance.isValid(removeSlotAttributes, usedWithinSlotPredicate)) {
                map.put(uniqueInstance.attribute(), (Object)uniqueInstance.modifier());
            }
        }));
        this.stackedAttributes.forEach((location, stackedInstance) -> {
            if (stackedInstance.isValid(removeSlotAttributes, usedWithinSlotPredicate)) {
                map.put(stackedInstance.attribute(), (Object)stackedInstance.modifier());
            }
        });
        return map;
    }

    public boolean isEmpty() {
        return this.exclusiveAttributes.isEmpty() && this.stackedAttributes.isEmpty();
    }

    public Map<Holder<Attribute>, Map<ResourceLocation, AttributeModificationData>> exclusiveAttributes() {
        return ImmutableMap.copyOf(this.exclusiveAttributes);
    }

    public Multimap<Holder<Attribute>, AttributeModificationData> stackedAttributes() {
        return ImmutableMultimap.copyOf(this.stackedAttributes);
    }

    public AccessoryAttributeBuilder addFrom(AccessoryAttributeBuilder builder) {
        builder.exclusiveAttributes.forEach(this.exclusiveAttributes::putIfAbsent);
        this.stackedAttributes.putAll(builder.stackedAttributes);
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessoryAttributeBuilder)) {
            return false;
        }
        AccessoryAttributeBuilder otherBuilder = (AccessoryAttributeBuilder)obj;
        if (!AccessoryAttributeBuilder.areMapsEqual(this.stackedAttributes, otherBuilder.stackedAttributes)) {
            return false;
        }
        return this.exclusiveAttributes.equals(otherBuilder.exclusiveAttributes);
    }

    private static <K, V> boolean areMapsEqual(Multimap<K, V> multimap1, Multimap<K, V> multimap2) {
        for (Map.Entry entry : multimap1.asMap().entrySet()) {
            if (((Collection)entry.getValue()).equals(multimap2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String createSlotPath(SlotReference ref) {
        return ref.createString();
    }

    @Deprecated
    public static String createSlotPath(String slotname, int slot) {
        return SlotPath.createBaseSlotPath(slotname, slot);
    }
}

